/*
 * Decompiled with CFR 0.152.
 */
package vscan;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import vscan.CheckCliArgs;
import vscan.CheckWeackCiphers;
import vscan.ConnectToUrlForContent;

public class Vscan {
    public static void main(String[] args) throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        CheckCliArgs.parseArgs(args);
        String targetUrl = args[0];
        System.out.println("Target: " + targetUrl);
        ArrayList<String> sslTlsVersions = new ArrayList<String>();
        sslTlsVersions.add("SSLv3");
        sslTlsVersions.add("TLSv1");
        sslTlsVersions.add("TLSv1.1");
        sslTlsVersions.add("TLSv1.2");
        for (String protocol : sslTlsVersions) {
            System.out.println();
            System.out.println("Testing with protocol " + protocol);
            System.out.println();
            System.setProperty("https.protocols", protocol);
            SSLContext sc = SSLContext.getInstance(protocol);
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            SSLSocketFactory sf = (SSLSocketFactory)SSLSocketFactory.getDefault();
            String[] supportedCiphers = sf.getSupportedCipherSuites();
            ArrayList<String> listOfSuccessfulCiphers = new ArrayList<String>();
            System.out.println("Testing CipherSuites accepted by tartget please wait...");
            for (int j = 0; j < supportedCiphers.length; ++j) {
                System.out.print(" " + (j + 1));
                System.out.print(" Connecting with " + supportedCiphers[j]);
                System.setProperty("https.cipherSuites", supportedCiphers[j]);
                String successfulCipher = new Vscan().connectToUrlForCVE(targetUrl);
                if (successfulCipher.length() == 0) continue;
                listOfSuccessfulCiphers.add(successfulCipher);
            }
            System.out.println("\n");
            System.out.println("List of cipher suites supported by the target:");
            System.out.println(listOfSuccessfulCiphers);
            System.out.println("\n");
            System.out.println("Number of cipher suites supported by the target:" + listOfSuccessfulCiphers.size());
            System.out.println("List of vulnerabilities and solution containing work around:");
            CheckWeackCiphers.parseTargetCipher(listOfSuccessfulCiphers, protocol);
            Boolean cbctest = false;
            for (int k = 0; k < listOfSuccessfulCiphers.size(); ++k) {
                String cCS = listOfSuccessfulCiphers.get(k);
                if (!cCS.toLowerCase().contains("cbc") || cbctest.booleanValue()) continue;
                cbctest = true;
            }
            System.setProperty("https.cipherSuites", "TLS_RSA_WITH_AES_128_CBC_SHA");
        }
        ConnectToUrlForContent.connectToUrl(targetUrl);
    }

    public String connectToUrlForCVE(String https_url) {
        String cs;
        block7: {
            cs = "";
            try {
                URL url = new URL(https_url);
                HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
                if (con == null) break block7;
                try {
                    System.out.print(": Response Code: " + con.getResponseCode());
                    String ciphersuite = con.getCipherSuite();
                    if (ciphersuite.length() == 0 | ciphersuite == null) {
                        System.out.println(" Failed");
                        break block7;
                    }
                    System.out.println(": Success");
                    cs = ciphersuite;
                }
                catch (SSLPeerUnverifiedException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    System.out.println(": Failed");
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return "";
            }
            catch (IOException e) {
                e.printStackTrace();
                return "";
            }
        }
        return cs;
    }

    public void connectToUrl(String https_url) {
        System.out.println("Target: " + https_url);
        try {
            URL url = new URL(https_url);
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            this.print_https_cert(con);
            this.print_content(con);
        }
        catch (MalformedURLException e) {
            System.out.println("There is a problem with the provided URL");
        }
        catch (IOException e) {
            System.out.println("We have a problem please check the provided URL");
        }
    }

    private void print_https_cert(HttpsURLConnection con) {
        if (con != null) {
            try {
                Certificate[] certs;
                System.out.println("Response Code: " + con.getResponseCode());
                System.out.println("Cipher Suite: " + con.getCipherSuite());
                String cipherSuite = con.getCipherSuite();
                System.out.println("\n");
                System.out.println("\n");
                for (Certificate cert : certs = con.getServerCertificates()) {
                    System.out.println("Certificate type: " + cert.getType());
                    System.out.println("Certificate hash: " + cert.hashCode());
                    System.out.println("Certificate Public Key Algorithm: " + cert.getPublicKey().getAlgorithm());
                    System.out.println("Certificate Public Key format: " + cert.getPublicKey().getFormat());
                    System.out.println("Pkey type: " + cert.getPublicKey());
                    System.out.println("\n");
                }
            }
            catch (SSLPeerUnverifiedException e) {
                System.out.println("Connection fails. The protocol may not be supported 1");
            }
            catch (IOException e) {
                System.out.println("Connection fails. The protocol may not be supported 2");
            }
            Map<String, List<String>> headers = con.getHeaderFields();
            System.out.println("HTTP Headers received from server:");
            String headerName = null;
            int i = 1;
            while ((headerName = con.getHeaderFieldKey(i)) != null) {
                System.out.print(headerName);
                System.out.println(": " + con.getHeaderField(i));
                ++i;
            }
            System.out.println("\n");
        }
    }

    private void print_content(HttpsURLConnection con) {
        if (con != null) {
            try {
                String input;
                System.out.println("****URL return content****");
                BufferedReader buff = new BufferedReader(new InputStreamReader(con.getInputStream()));
                while ((input = buff.readLine()) != null) {
                    System.out.println(input);
                }
                buff.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

