/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.sslprobe;

import com.subgraph.vega.internal.sslprobe.ProbeBase;
import com.subgraph.vega.internal.sslprobe.SSLServerScanResult;
import com.subgraph.vega.internal.sslprobe.TLSProtocol;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class TLSVersionProbe
extends ProbeBase<Void> {
    private static final Logger logger = Logger.getLogger(TLSVersionProbe.class.getName());
    private static final byte[] VER_SSLv3;
    private static final byte[] VER_TLS1;
    private static final byte[] VER_TLS1_1;
    private static final byte[] VER_TLS1_2;
    private static final List<byte[]> ALL_VERSIONS;
    private final byte[] version;

    static {
        byte[] byArray = new byte[2];
        byArray[0] = 3;
        VER_SSLv3 = byArray;
        VER_TLS1 = new byte[]{3, 1};
        VER_TLS1_1 = new byte[]{3, 2};
        VER_TLS1_2 = new byte[]{3, 3};
        ALL_VERSIONS = Arrays.asList(VER_SSLv3, VER_TLS1, VER_TLS1_1, VER_TLS1_2);
    }

    static List<TLSVersionProbe> getVersionProbes(SSLServerScanResult sSLServerScanResult) {
        ArrayList<TLSVersionProbe> arrayList = new ArrayList<TLSVersionProbe>();
        for (byte[] byArray : ALL_VERSIONS) {
            arrayList.add(new TLSVersionProbe(sSLServerScanResult, byArray));
        }
        return arrayList;
    }

    TLSVersionProbe(SSLServerScanResult sSLServerScanResult, byte[] byArray) {
        super(sSLServerScanResult);
        this.version = byArray;
    }

    @Override
    protected Void runProbe() throws IOException {
        TLSProtocol tLSProtocol = new TLSProtocol(this.getInputStream(), this.getOutputStream());
        tLSProtocol.sendTLSClientHello(this.scanResult.getServerTLSCiphers(), this.version);
        byte[] byArray = new byte[3];
        if (!this.readAll(byArray)) {
            logger.warning("Failed to read response in TLSVersionProbe");
        } else if (byArray[0] != 22) {
            logger.warning("Unexpected record type received in response in TLSVersionProbe.  type = " + byArray[0]);
        } else {
            boolean bl;
            boolean bl2 = bl = byArray[1] == this.version[0] && byArray[2] == this.version[1];
            if (bl) {
                this.processProbeResult(bl);
            }
        }
        return null;
    }

    private void processProbeResult(boolean bl) {
        if (this.version != null) {
            switch (this.version[1]) {
                case 0: {
                    this.scanResult.setFlag(SSLServerScanResult.Flag.SSLV3);
                    break;
                }
                case 1: {
                    this.scanResult.setFlag(SSLServerScanResult.Flag.TLS1);
                    break;
                }
                case 2: {
                    this.scanResult.setFlag(SSLServerScanResult.Flag.TLS11);
                    break;
                }
                case 3: {
                    this.scanResult.setFlag(SSLServerScanResult.Flag.TLS12);
                    break;
                }
            }
        }
    }
}

