/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.sslprobe;

import com.subgraph.vega.internal.sslprobe.CipherSuites;
import com.subgraph.vega.internal.sslprobe.ProbeBase;
import com.subgraph.vega.internal.sslprobe.SSLServerScanResult;
import com.subgraph.vega.internal.sslprobe.TLSAlertException;
import com.subgraph.vega.internal.sslprobe.TLSCipherSpec;
import com.subgraph.vega.internal.sslprobe.TLSProtocol;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class TLSServerCipherPreferenceProbe
extends ProbeBase<Void> {
    private static final Logger logger = Logger.getLogger(TLSServerCipherPreferenceProbe.class.getName());

    TLSServerCipherPreferenceProbe(SSLServerScanResult sSLServerScanResult) {
        super(sSLServerScanResult);
    }

    @Override
    public Void runProbe() {
        List<TLSCipherSpec> list = this.scanResult.getServerTLSCiphers();
        if (list.size() < 2) {
            return null;
        }
        if (this.isServerPreference(list)) {
            this.scanResult.setFlag(SSLServerScanResult.Flag.SERVER_PREFERENCE);
            List<TLSCipherSpec> list2 = this.orderCiphersByServerPreference(list);
            if (list2 != null) {
                this.scanResult.setServerTLSCiphersServerPreferenceOrder(list2);
            }
        }
        return null;
    }

    private boolean isServerPreference(List<TLSCipherSpec> list) {
        return this.serverDemonstratePreference(list.get(0), list.get(1)) || this.serverDemonstratePreference(list.get(1), list.get(0));
    }

    private boolean serverDemonstratePreference(TLSCipherSpec tLSCipherSpec, TLSCipherSpec tLSCipherSpec2) {
        this.closeConnection();
        try {
            TLSProtocol tLSProtocol = new TLSProtocol(this.getInputStream(), this.getOutputStream());
            tLSProtocol.sendTLSClientHello(Arrays.asList(tLSCipherSpec, tLSCipherSpec2));
            ByteBuffer byteBuffer = tLSProtocol.getNextHandshakeMessage();
            int n = tLSProtocol.extractCipherFromServerHello(byteBuffer);
            return n == tLSCipherSpec2.getNumber();
        }
        catch (IOException iOException) {
            logger.warning("I/O error sending server order preference probe: " + iOException);
        }
        catch (TLSAlertException tLSAlertException) {
            logger.info("TLS alert received sending server order preference probe: " + tLSAlertException);
        }
        return false;
    }

    private List<TLSCipherSpec> orderCiphersByServerPreference(List<TLSCipherSpec> list) {
        ArrayList<TLSCipherSpec> arrayList = new ArrayList<TLSCipherSpec>();
        ArrayList<TLSCipherSpec> arrayList2 = new ArrayList<TLSCipherSpec>(list);
        while (!arrayList2.isEmpty()) {
            TLSCipherSpec tLSCipherSpec = this.chooseCipher(arrayList2);
            if (tLSCipherSpec == null) {
                return null;
            }
            arrayList.add(tLSCipherSpec);
            arrayList2.remove(tLSCipherSpec);
        }
        return arrayList;
    }

    private TLSCipherSpec chooseCipher(List<TLSCipherSpec> list) {
        this.closeConnection();
        try {
            TLSProtocol tLSProtocol = new TLSProtocol(this.getInputStream(), this.getOutputStream());
            tLSProtocol.sendTLSClientHello(list);
            int n = tLSProtocol.extractCipherFromServerHello(tLSProtocol.getNextHandshakeMessage());
            return CipherSuites.lookupTLSCipher(n);
        }
        catch (IOException iOException) {
            logger.info("I/O error sending server cipher ordering probe: " + iOException);
        }
        catch (TLSAlertException tLSAlertException) {
            logger.info("TLS alert received sending server cipher ordering probe: " + tLSAlertException);
        }
        return null;
    }
}

