/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.sslprobe;

import com.subgraph.vega.internal.sslprobe.TLSAlertException;
import com.subgraph.vega.internal.sslprobe.TLSCipherSpec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Random;

public class TLSProtocol {
    private static final int TLS_RECORD_HEADER_LENGTH = 5;
    private static final int TLS_MAXIMUM_RECORD_LENGTH = 16384;
    private static final int MAXIMUM_HANDSHAKE_MESSAGE_LENGTH = 65536;
    private static final int TLS_RECORD_ALERT = 21;
    public static final int TLS_RECORD_HANDSHAKE = 22;
    private static final byte TLS_HANDSHAKE_CLIENTHELLO = 1;
    private static final byte[] DEFAULT_VERSION = new byte[]{3, 1};
    private static final Random random = new Random();
    private final InputStream input;
    private final OutputStream output;
    private final ByteBuffer recordBuffer;
    private final ByteBuffer handshakeBuffer;

    TLSProtocol(InputStream inputStream, OutputStream outputStream) {
        this.input = inputStream;
        this.output = outputStream;
        this.recordBuffer = ByteBuffer.allocate(16389);
        this.handshakeBuffer = ByteBuffer.allocate(65536);
        this.handshakeBuffer.flip();
    }

    ByteBuffer getNextHandshakeMessage() throws IOException, TLSAlertException {
        while (!this.hasFullHandshakeMessage()) {
            if (this.readNextRecord()) continue;
            return null;
        }
        return this.extractNextHandshakeMessage();
    }

    private boolean hasFullHandshakeMessage() {
        int n = this.handshakeBuffer.remaining();
        return n >= 4 && n >= this.peekHandshakeLength() + 4;
    }

    private int peekHandshakeLength() {
        return this.handshakeBuffer.getInt(this.handshakeBuffer.position()) & 0xFFFFFF;
    }

    private ByteBuffer extractNextHandshakeMessage() {
        int n = this.peekHandshakeLength();
        byte[] byArray = new byte[n + 4];
        this.handshakeBuffer.get(byArray);
        this.handshakeBuffer.compact().flip();
        return ByteBuffer.wrap(byArray);
    }

    private void appendMessageBytes(byte[] byArray) {
        this.handshakeBuffer.mark();
        this.handshakeBuffer.position(this.handshakeBuffer.limit());
        this.handshakeBuffer.limit(this.handshakeBuffer.capacity());
        this.handshakeBuffer.put(byArray);
        this.handshakeBuffer.limit(this.handshakeBuffer.position());
        this.handshakeBuffer.reset();
    }

    private boolean readNextRecord() throws IOException, TLSAlertException {
        while (!this.hasFullRecord()) {
            if (this.readToRecordBuffer()) continue;
            return false;
        }
        this.recordBuffer.flip();
        int n = this.recordBuffer.get() & 0xFF;
        this.recordBuffer.getShort();
        int n2 = this.recordBuffer.getShort() & 0xFFFF;
        byte[] byArray = new byte[n2];
        this.recordBuffer.get(byArray);
        this.recordBuffer.compact();
        if (n == 22) {
            this.appendMessageBytes(byArray);
        } else if (n == 21) {
            int cfr_ignored_0 = byArray.length;
            throw new TLSAlertException(byArray[0] & 0xFF, byArray[1] & 0xFF);
        }
        return true;
    }

    private boolean readToRecordBuffer() throws IOException {
        int n;
        int n2;
        byte[] byArray = this.recordBuffer.array();
        int n3 = this.input.read(byArray, n2 = this.recordBuffer.position(), n = this.recordBuffer.remaining());
        if (n3 == -1) {
            return false;
        }
        this.recordBuffer.position(this.recordBuffer.position() + n3);
        return true;
    }

    boolean hasFullRecord() {
        if (this.recordBuffer.position() < 5) {
            return false;
        }
        int n = this.recordBuffer.getShort(3) & 0xFFFF;
        return this.recordBuffer.position() >= n + 5;
    }

    void createTLSClientHello(ByteBuffer byteBuffer, List<TLSCipherSpec> list, byte[] byArray) {
        byteBuffer.clear();
        this.skip(byteBuffer, 5);
        int n = byteBuffer.position();
        byteBuffer.put((byte)1);
        byteBuffer.mark();
        this.skip(byteBuffer, 3);
        int n2 = this.packClientHello(byteBuffer, list, byArray);
        int n3 = byteBuffer.position();
        byteBuffer.reset();
        byteBuffer.put(TLSProtocol.packInt24(n2));
        byteBuffer.rewind();
        this.packRecordHeader(byteBuffer, byArray, n3 - n);
        byteBuffer.flip();
    }

    int packClientHello(ByteBuffer byteBuffer, List<TLSCipherSpec> list, byte[] byArray) {
        int n = byteBuffer.position();
        byteBuffer.put(byArray);
        byteBuffer.putInt(TLSProtocol.getTimeSeconds());
        byteBuffer.put(TLSProtocol.getRandomBytes());
        byteBuffer.put((byte)0);
        byteBuffer.putShort((short)(2 * list.size()));
        for (TLSCipherSpec tLSCipherSpec : list) {
            byteBuffer.putShort((short)tLSCipherSpec.getNumber());
        }
        byteBuffer.put((byte)2);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)1);
        return byteBuffer.position() - n;
    }

    int extractCipherFromServerHello(ByteBuffer byteBuffer) {
        this.skipStartOfServerHello(byteBuffer);
        return byteBuffer.getShort() & 0xFFFF;
    }

    int extractCompressionFromServerHello(ByteBuffer byteBuffer) {
        this.skipStartOfServerHello(byteBuffer);
        byteBuffer.getShort();
        return byteBuffer.get() & 0xFF;
    }

    private void skipStartOfServerHello(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        int n = byteBuffer.get() & 0xFF;
        int n2 = this.getInt24(byteBuffer);
        byteBuffer.remaining();
        this.skip(byteBuffer, 2);
        this.skip(byteBuffer, 32);
        int n3 = byteBuffer.get() & 0xFF;
        this.skip(byteBuffer, n3);
    }

    public int getInt24(ByteBuffer byteBuffer) {
        int n = 0;
        int n2 = 0;
        while (n2 < 3) {
            n <<= 8;
            n |= byteBuffer.get() & 0xFF;
            ++n2;
        }
        return n;
    }

    void packRecordHeader(ByteBuffer byteBuffer, byte[] byArray, int n) {
        byteBuffer.put((byte)22);
        byteBuffer.put(byArray);
        byteBuffer.putShort((short)n);
    }

    private int skip(ByteBuffer byteBuffer, int n) {
        int n2 = byteBuffer.position();
        byteBuffer.position(n2 + n);
        return n2;
    }

    public void sendTLSClientHello(List<TLSCipherSpec> list) throws IOException {
        this.sendTLSClientHello(list, null);
    }

    public void sendTLSClientHello(List<TLSCipherSpec> list, byte[] byArray) throws IOException {
        this.writeAll(TLSProtocol.createTLSClientHello(list, byArray));
    }

    protected void writeAll(ByteBuffer byteBuffer) throws IOException {
        this.output.write(byteBuffer.array(), byteBuffer.position(), byteBuffer.remaining());
        byteBuffer.position(byteBuffer.position() + byteBuffer.remaining());
        this.output.flush();
    }

    private static ByteBuffer createTLSClientHello(List<TLSCipherSpec> list, byte[] byArray) {
        byte[] byArray2 = byArray == null ? DEFAULT_VERSION : byArray;
        ByteBuffer byteBuffer = ByteBuffer.allocate(TLSProtocol.getTLSHelloLength(list.size()));
        int n = 44 + 2 * list.size();
        int n2 = n - 4;
        byteBuffer.put((byte)22);
        byteBuffer.put(byArray2);
        byteBuffer.putShort((short)n);
        byteBuffer.put((byte)1);
        byteBuffer.put(TLSProtocol.packInt24(n2));
        byteBuffer.put(byArray2);
        byteBuffer.putInt(TLSProtocol.getTimeSeconds());
        byteBuffer.put(TLSProtocol.getRandomBytes());
        byteBuffer.put((byte)0);
        byteBuffer.putShort((short)(2 * list.size()));
        for (TLSCipherSpec tLSCipherSpec : list) {
            byteBuffer.putShort((short)tLSCipherSpec.getNumber());
        }
        byteBuffer.put((byte)2);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)1);
        byteBuffer.flip();
        return byteBuffer;
    }

    static int getTLSHelloLength(int n) {
        return 49 + 2 * n;
    }

    static byte[] packInt24(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 16), (byte)(n >> 8), (byte)n};
        return byArray;
    }

    private static int getTimeSeconds() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    private static byte[] getRandomBytes() {
        byte[] byArray = new byte[28];
        random.nextBytes(byArray);
        return byArray;
    }
}

