/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.sslprobe;

import com.subgraph.vega.internal.sslprobe.CertificateAnalyzer;
import com.subgraph.vega.internal.sslprobe.TLSCipherSpec;
import java.util.ArrayList;
import java.util.List;

public class TLSProbeResult {
    private List<TLSCipherSpec> rejectedCiphers;
    private TLSCipherSpec acceptedCipher;
    private ArrayList<CertificateAnalyzer> serverCertificates = new ArrayList();
    private boolean TLScompressionSupport;
    private boolean error;
    private String errorMessage = "";

    TLSProbeResult() {
    }

    public void addCiphers(List<TLSCipherSpec> list, TLSCipherSpec tLSCipherSpec) {
        this.setRejectedCiphers(list);
        this.acceptedCipher = tLSCipherSpec;
    }

    public void addRejectedCiphersOnly(List<TLSCipherSpec> list) {
        this.setRejectedCiphers(list);
    }

    public void addServerCertificate(CertificateAnalyzer certificateAnalyzer) {
        this.serverCertificates.add(certificateAnalyzer);
    }

    public void setTLSCompressionSupport(boolean bl) {
        this.TLScompressionSupport = bl;
    }

    public void setError(boolean bl, String string) {
        this.error = bl;
        this.errorMessage = string;
    }

    public void addCertificate(CertificateAnalyzer certificateAnalyzer) {
        this.serverCertificates.add(certificateAnalyzer);
    }

    public boolean isError() {
        return this.error;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public TLSCipherSpec getAcceptedCipher() {
        return this.acceptedCipher;
    }

    public ArrayList<CertificateAnalyzer> getServerCertificates() {
        return this.serverCertificates;
    }

    public List<TLSCipherSpec> getRejectedCiphers() {
        return this.rejectedCiphers;
    }

    public void setRejectedCiphers(List<TLSCipherSpec> list) {
        this.rejectedCiphers = list;
    }

    public boolean getTLSCompressionSupport() {
        return this.TLScompressionSupport;
    }
}

