/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.sslprobe;

import com.google.common.collect.Lists;
import com.subgraph.vega.internal.sslprobe.SSLv2CipherSpec;
import com.subgraph.vega.internal.sslprobe.TLSCipherSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CipherSuites {
    private static final List<TLSCipherSpec> TLS_CIPHERS = new ArrayList<TLSCipherSpec>();
    private static final Map<Integer, TLSCipherSpec> TLS_CIPHER_MAP = new HashMap<Integer, TLSCipherSpec>();
    private static final List<SSLv2CipherSpec> SSLv2_CIPHERS = new ArrayList<SSLv2CipherSpec>();
    private static final Map<Integer, SSLv2CipherSpec> SSLv2_CIPHER_MAP = new HashMap<Integer, SSLv2CipherSpec>();

    static {
        CipherSuites.addCipher("TLS_NULL_WITH_NULL_NULL", 0, TLSCipherSpec.keyStrength.NONE, false, false, false);
        CipherSuites.addCipher("TLS_RSA_WITH_NULL_MD5", 1, TLSCipherSpec.keyStrength.NONE, false, false, false);
        CipherSuites.addCipher("TLS_RSA_WITH_NULL_SHA", 2, TLSCipherSpec.keyStrength.NONE, false, false, false);
        CipherSuites.addCipher("TLS_RSA_EXPORT_WITH_RC4_40_MD5", 3, TLSCipherSpec.keyStrength.EXPORT, false, false, true);
        CipherSuites.addCipher("TLS_RSA_WITH_RC4_128_MD5", 4, TLSCipherSpec.keyStrength.HIGH, false, false, true);
        CipherSuites.addCipher("TLS_RSA_WITH_RC4_128_SHA", 5, TLSCipherSpec.keyStrength.HIGH, false, false, true);
        CipherSuites.addCipher("TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5", 6, TLSCipherSpec.keyStrength.EXPORT, false, false, false);
        CipherSuites.addCipher("TLS_RSA_WITH_IDEA_CBC_SHA", 7, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_RSA_EXPORT_WITH_DES40_CBC_SHA", 8, TLSCipherSpec.keyStrength.EXPORT, false, false, false);
        CipherSuites.addCipher("TLS_RSA_WITH_DES_CBC_SHA", 9, TLSCipherSpec.keyStrength.LOW, false, false, false);
        CipherSuites.addCipher("TLS_RSA_WITH_3DES_EDE_CBC_SHA", 10, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA", 11, TLSCipherSpec.keyStrength.EXPORT, false, false, false);
        CipherSuites.addCipher("TLS_DH_DSS_WITH_DES_CBC_SHA", 12, TLSCipherSpec.keyStrength.LOW, false, false, false);
        CipherSuites.addCipher("TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA", 13, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA", 14, TLSCipherSpec.keyStrength.EXPORT, false, false, false);
        CipherSuites.addCipher("TLS_DH_RSA_WITH_DES_CBC_SHA", 15, TLSCipherSpec.keyStrength.LOW, false, false, false);
        CipherSuites.addCipher("TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA", 16, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", 17, TLSCipherSpec.keyStrength.EXPORT, false, false, false);
        CipherSuites.addCipher("TLS_DHE_DSS_WITH_DES_CBC_SHA", 18, TLSCipherSpec.keyStrength.LOW, false, false, false);
        CipherSuites.addCipher("TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA", 19, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", 20, TLSCipherSpec.keyStrength.EXPORT, false, false, false);
        CipherSuites.addCipher("TLS_DHE_RSA_WITH_DES_CBC_SHA", 21, TLSCipherSpec.keyStrength.LOW, false, false, false);
        CipherSuites.addCipher("TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA", 22, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DH_Anon_EXPORT_WITH_RC4_40_MD5", 23, TLSCipherSpec.keyStrength.EXPORT, true, false, true);
        CipherSuites.addCipher("TLS_DH_Anon_WITH_RC4_128_MD5", 24, TLSCipherSpec.keyStrength.HIGH, true, false, true);
        CipherSuites.addCipher("TLS_DH_Anon_EXPORT_WITH_DES40_CBC_SHA", 25, TLSCipherSpec.keyStrength.EXPORT, true, false, false);
        CipherSuites.addCipher("TLS_DH_Anon_WITH_DES_CBC_SHA", 26, TLSCipherSpec.keyStrength.LOW, true, false, false);
        CipherSuites.addCipher("TLS_DH_Anon_WITH_3DES_EDE_CBC_SHA", 27, TLSCipherSpec.keyStrength.HIGH, true, false, false);
        CipherSuites.addCipher("TLS_KRB5_WITH_DES_CBC_SHA", 30, TLSCipherSpec.keyStrength.LOW, false, false, false);
        CipherSuites.addCipher("TLS_KRB5_WITH_3DES_EDE_CBC_SHA", 31, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_KRB5_WITH_RC4_128_SHA", 32, TLSCipherSpec.keyStrength.HIGH, false, false, true);
        CipherSuites.addCipher("TLS_KRB5_WITH_IDEA_CBC_SHA", 33, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_KRB5_WITH_DES_CBC_MD5", 34, TLSCipherSpec.keyStrength.LOW, false, false, false);
        CipherSuites.addCipher("TLS_KRB5_WITH_3DES_EDE_CBC_MD5", 35, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_KRB5_WITH_RC4_128_MD5", 36, TLSCipherSpec.keyStrength.HIGH, false, false, true);
        CipherSuites.addCipher("TLS_KRB5_WITH_IDEA_CBC_MD5", 37, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA", 38, TLSCipherSpec.keyStrength.LOW, false, false, false);
        CipherSuites.addCipher("TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA", 39, TLSCipherSpec.keyStrength.EXPORT, false, false, false);
        CipherSuites.addCipher("TLS_KRB5_EXPORT_WITH_RC4_40_SHA", 40, TLSCipherSpec.keyStrength.EXPORT, false, false, true);
        CipherSuites.addCipher("TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5", 41, TLSCipherSpec.keyStrength.EXPORT, false, false, false);
        CipherSuites.addCipher("TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5", 42, TLSCipherSpec.keyStrength.EXPORT, false, false, false);
        CipherSuites.addCipher("TLS_KRB5_EXPORT_WITH_RC4_40_MD5", 43, TLSCipherSpec.keyStrength.EXPORT, false, false, true);
        CipherSuites.addCipher("TLS_PSK_WITH_NULL_SHA", 44, TLSCipherSpec.keyStrength.NONE, false, false, false);
        CipherSuites.addCipher("TLS_DHE_PSK_WITH_NULL_SHA", 45, TLSCipherSpec.keyStrength.NONE, false, false, false);
        CipherSuites.addCipher("TLS_RSA_PSK_WITH_NULL_SHA", 46, TLSCipherSpec.keyStrength.NONE, false, false, false);
        CipherSuites.addCipher("TLS_RSA_WITH_AES_128_CBC_SHA", 47, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_DSS_WITH_AES_128_CBC_SHA", 48, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_RSA_WITH_AES_128_CBC_SHA", 49, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_DSS_WITH_AES_128_CBC_SHA", 50, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_RSA_WITH_AES_128_CBC_SHA", 51, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DH_Anon_WITH_AES_128_CBC_SHA", 52, TLSCipherSpec.keyStrength.HIGH, true, false, false);
        CipherSuites.addCipher("TLS_RSA_WITH_AES_256_CBC_SHA", 53, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_DSS_WITH_AES_256_CBC_SHA", 54, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_RSA_WITH_AES_256_CBC_SHA", 55, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_DSS_WITH_AES_265_CBC_SHA", 56, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_RSA_WITH_AES_256_CBC_SHA", 57, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DH_Anon_WITH_AES_256_CBC_SHA", 58, TLSCipherSpec.keyStrength.HIGH, true, false, false);
        CipherSuites.addCipher("TLS_RSA_WITH_NULL_SHA256", 59, TLSCipherSpec.keyStrength.NONE, false, false, false);
        CipherSuites.addCipher("TLS_RSA_WITH_AES_128_CBC_SHA256", 60, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_RSA_WITH_AES_256_CBC_SHA256", 61, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_DSS_WITH_AES_128_CBC_SHA256", 62, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_RSA_WITH_AES_128_CBC_SHA256", 63, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", 64, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_RSA_WITH_CAMELLIA_128_CBC_SHA", 65, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA", 66, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA", 67, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA", 68, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA", 69, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DH_Anon_WITH_CAMELLIA_128_CBC_SHA", 70, TLSCipherSpec.keyStrength.HIGH, true, false, false);
        CipherSuites.addCipher("TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", 103, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DH_DSS_WITH_AES_256_CBC_SHA256", 104, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_RSA_WITH_AES_256_CBC_SHA256", 105, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", 106, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", 107, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DH_Anon_WITH_AES_128_CBC_SHA256", 108, TLSCipherSpec.keyStrength.HIGH, true, false, false);
        CipherSuites.addCipher("TLS_DH_Anon_WITH_AES_256_CBC_SHA256", 109, TLSCipherSpec.keyStrength.HIGH, true, false, false);
        CipherSuites.addCipher("TLS_RSA_WITH_CAMELLIA_256_CBC_SHA", 132, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA", 133, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA", 134, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA", 135, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA", 136, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DH_Anon_WITH_CAMELLIA_256_CBC_SHA", 137, TLSCipherSpec.keyStrength.HIGH, true, false, false);
        CipherSuites.addCipher("TLS_PSK_WITH_RC4_128_SHA", 138, TLSCipherSpec.keyStrength.HIGH, false, false, true);
        CipherSuites.addCipher("TLS_PSK_WITH_3DES_EDE_CBC_SHA", 139, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_PSK_WITH_AES_128_CBC_SHA", 140, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_PSK_WITH_AES_256_CBC_SHA", 141, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_PSK_WITH_RC4_128_SHA", 142, TLSCipherSpec.keyStrength.HIGH, false, true, true);
        CipherSuites.addCipher("DHE_PSK_WITH_3DES_EDE_CBC_SHA", 143, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_PSK_WITH_AES_128_CBC_SHA", 144, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_PSK_WITH_AES_256_CBC_SHA", 145, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_RSA_PSK_WITH_RC4_128_SHA", 146, TLSCipherSpec.keyStrength.HIGH, false, false, true);
        CipherSuites.addCipher("TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA", 147, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_RSA_PSK_WITH_AES_128_CBC_SHA", 148, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_RSA_PSK_WITH_AES_256_CBC_SHA", 149, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_RSA_WITH_SEED_CBC_SHA", 150, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_DSS_WITH_SEED_CBC_SHA", 151, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_RSA_WITH_SEED_CBC_SHA", 152, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_DSS_WITH_SEED_CBC_SHA", 153, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_RSA_WITH_SEED_CBC_SHA", 154, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DH_Anon_WITH_SEED_CBC_SHA", 155, TLSCipherSpec.keyStrength.HIGH, true, false, false);
        CipherSuites.addCipher("TLS_RSA_WITH_AES_128_GCM_SHA256", 156, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_RSA_WITH_AES_256_GCM_SHA384", 157, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", 158, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", 159, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DH_RSA_WITH_AES_128_GCM_SHA256", 160, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_RSA_WITH_AES_256_GCM_SHA384", 161, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", 162, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", 163, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DH_DSS_WITH_AES_128_GCM_SHA256", 164, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_DSS_WITH_AES_256_GCM_SHA384", 165, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_Anon_WITH_AES_128_GCM_SHA256", 166, TLSCipherSpec.keyStrength.HIGH, true, false, false);
        CipherSuites.addCipher("TLS_DH_anon_WITH_AES_256_GCM_SHA384", 167, TLSCipherSpec.keyStrength.HIGH, true, false, false);
        CipherSuites.addCipher("TLS_PSK_WITH_AES_128_GCM_SHA256", 168, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_PSK_WITH_AES_256_GCM_SHA384", 169, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_PSK_WITH_AES_128_GCM_SHA256", 170, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_PSK_WITH_AES_256_GCM_SHA384", 171, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_RSA_PSK_WITH_AES_128_GCM_SHA256", 172, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_RSA_PSK_WITH_AES_256_GCM_SHA384", 173, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_PSK_WITH_AES_128_CBC_SHA256", 174, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_PSK_WITH_AES_256_CBC_SHA384", 175, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_PSK_WITH_NULL_SHA256", 176, TLSCipherSpec.keyStrength.NONE, false, false, false);
        CipherSuites.addCipher("TLS_PSK_WITH_NULL_SHA384", 177, TLSCipherSpec.keyStrength.NONE, false, false, false);
        CipherSuites.addCipher("TLS_DHE_PSK_WITH_AES_128_CBC_SHA256", 178, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_PSK_WITH_AES_256_CBC_SHA384", 179, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_PSK_WITH_NULL_SHA256", 180, TLSCipherSpec.keyStrength.NONE, false, true, false);
        CipherSuites.addCipher("TLS_DHE_PSK_WITH_NULL_SHA384", 181, TLSCipherSpec.keyStrength.NONE, false, true, false);
        CipherSuites.addCipher("TLS_RSA_PSK_WITH_AES_128_CBC_SHA256", 182, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_RSA_PSK_WITH_AES_256_CBC_SHA384", 183, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_RSA_PSK_WITH_NULL_SHA256", 184, TLSCipherSpec.keyStrength.NONE, false, false, false);
        CipherSuites.addCipher("TLS_RSA_PSK_WITH_NULL_SHA384", 185, TLSCipherSpec.keyStrength.NONE, false, false, false);
        CipherSuites.addCipher("TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256", 186, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256", 187, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256", 188, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256", 189, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256", 190, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DH_Anon_WITH_CAMELLIA_128_CBC_SHA256", 191, TLSCipherSpec.keyStrength.HIGH, true, false, false);
        CipherSuites.addCipher("TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256", 192, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256", 193, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256", 194, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256", 195, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256", 196, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256", 197, TLSCipherSpec.keyStrength.HIGH, true, false, false);
        CipherSuites.addCipher("TLS_ECDH_ECDSA_WITH_NULL_SHA", 49153, TLSCipherSpec.keyStrength.NONE, false, false, false);
        CipherSuites.addCipher("TLS_ECDH_ECDSA_WITH_RC4_128_SHA", 49154, TLSCipherSpec.keyStrength.HIGH, false, false, true);
        CipherSuites.addCipher("TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", 49155, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA", 49156, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA", 49157, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDHE_ECDSA_WITH_NULL_SHA", 49158, TLSCipherSpec.keyStrength.NONE, false, false, false);
        CipherSuites.addCipher("TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", 49159, TLSCipherSpec.keyStrength.HIGH, false, true, true);
        CipherSuites.addCipher("TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", 49160, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", 49161, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", 49162, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDH_RSA_WITH_NULL_SHA", 49163, TLSCipherSpec.keyStrength.NONE, false, false, false);
        CipherSuites.addCipher("TLS_ECDH_RSA_WITH_RC4_128_SHA", 49164, TLSCipherSpec.keyStrength.HIGH, false, false, true);
        CipherSuites.addCipher("TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA", 49165, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA", 49166, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", 49167, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDHE_RSA_WITH_NULL_SHA", 49168, TLSCipherSpec.keyStrength.NONE, false, false, false);
        CipherSuites.addCipher("TLS_ECDHE_RSA_WITH_RC4_128_SHA", 49169, TLSCipherSpec.keyStrength.HIGH, false, true, true);
        CipherSuites.addCipher("TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", 49170, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", 49171, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", 49172, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDH_Anon_WITH_NULL_SHA", 49173, TLSCipherSpec.keyStrength.NONE, true, false, false);
        CipherSuites.addCipher("TLS_ECDH_Anon_WITH_RC4_128_SHA", 49174, TLSCipherSpec.keyStrength.HIGH, true, false, true);
        CipherSuites.addCipher("TLS_ECDH_Anon_WITH_3DES_EDE_CBC_SHA", 49175, TLSCipherSpec.keyStrength.HIGH, true, false, false);
        CipherSuites.addCipher("TLS_ECDH_Anon_WITH_AES_128_CBC_SHA", 49176, TLSCipherSpec.keyStrength.HIGH, true, false, false);
        CipherSuites.addCipher("TLS_ECDH_Anon_WITH_AES_256_CBC_SHA", 49177, TLSCipherSpec.keyStrength.HIGH, true, false, false);
        CipherSuites.addCipher("TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA", 49178, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA", 49179, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA", 49180, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_SRP_SHA_WITH_AES_128_CBC_SHA", 49181, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA", 49182, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA", 49183, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_SRP_SHA_WITH_AES_256_CBC_SHA", 49184, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA", 49185, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA", 49186, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", 49187, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", 49188, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256", 49189, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384", 49190, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", 49191, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", 49192, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256", 49193, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384", 49194, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", 49195, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", 49196, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256", 49197, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384", 49198, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", 49199, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", 49200, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256", 49201, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384", 49202, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDHE_PSK_WITH_RC4_128_SHA", 49203, TLSCipherSpec.keyStrength.HIGH, false, true, true);
        CipherSuites.addCipher("TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA", 49204, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA", 49205, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA", 49206, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256", 49207, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384", 49208, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDHE_PSK_WITH_NULL_SHA", 49209, TLSCipherSpec.keyStrength.NONE, false, false, false);
        CipherSuites.addCipher("TLS_ECDHE_PSK_WITH_NULL_SHA256", 49210, TLSCipherSpec.keyStrength.NONE, false, false, false);
        CipherSuites.addCipher("TLS_ECDHE_PSK_WITH_NULL_SHA384", 49211, TLSCipherSpec.keyStrength.NONE, false, false, false);
        CipherSuites.addCipher("TLS_RSA_WITH_ARIA_128_CBC_SHA256", 49212, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_RSA_WITH_ARIA_256_CBC_SHA384", 49213, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256", 49214, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384", 49215, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256", 49216, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384", 49217, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256", 49218, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384", 49219, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256", 49220, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384", 49221, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DH_Anon_WITH_ARIA_128_CBC_SHA256", 49222, TLSCipherSpec.keyStrength.HIGH, true, false, false);
        CipherSuites.addCipher("TLS_DH_Anon_WITH_ARIA_256_CBC_SHA384", 49223, TLSCipherSpec.keyStrength.HIGH, true, false, false);
        CipherSuites.addCipher("TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256", 49224, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384", 49225, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256", 49226, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384", 49227, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256", 49228, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384", 49229, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256", 49230, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384", 49231, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_RSA_WITH_ARIA_128_GCM_SHA256", 49232, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_RSA_WITH_ARIA_256_GCM_SHA384", 49233, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256", 49234, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384", 49235, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256", 49236, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384", 49237, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256", 49238, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384", 49239, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256", 49240, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384", 49241, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_Anon_WITH_ARIA_128_GCM_SHA256", 49242, TLSCipherSpec.keyStrength.HIGH, true, false, false);
        CipherSuites.addCipher("TLS_DH_Anon_WITH_ARIA_256_GCM_SHA384", 49243, TLSCipherSpec.keyStrength.HIGH, true, false, false);
        CipherSuites.addCipher("TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256", 49244, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384", 49245, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256", 49246, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384", 49247, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256", 49248, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384", 49249, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256", 49250, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384", 49251, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_PSK_WITH_ARIA_128_CBC_SHA256", 49252, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_PSK_WITH_ARIA_256_CBC_SHA384", 49253, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256", 49254, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384", 49255, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256", 49256, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384", 49257, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_PSK_WITH_ARIA_128_GCM_SHA256", 49258, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_PSK_WITH_ARIA_256_GCM_SHA384", 49259, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256", 49260, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384", 49261, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256", 49262, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384", 49263, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256", 49264, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384", 49265, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256", 49266, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384", 49267, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256", 49268, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384", 49269, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256", 49270, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384", 49271, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256", 49272, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384", 49273, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256", 49274, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384", 49275, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256", 49276, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384", 49277, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256", 49278, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384", 49279, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256", 49280, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384", 49281, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256", 49282, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384", 49283, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DH_Anon_WITH_CAMELLIA_128_GCM_SHA256", 49284, TLSCipherSpec.keyStrength.HIGH, true, false, false);
        CipherSuites.addCipher("TLS_DH_Anon_WITH_CAMELLIA_256_GCM_SHA384", 49285, TLSCipherSpec.keyStrength.HIGH, true, false, false);
        CipherSuites.addCipher("TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256", 49286, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384", 49287, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256", 49288, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384", 49289, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256", 49290, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384", 49291, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256", 49292, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384", 49293, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256", 49294, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384", 49295, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256", 49296, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384", 49297, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256", 49298, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384", 49299, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256", 49300, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384", 49301, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256", 49302, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384", 49303, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256", 49304, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384", 49305, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256", 49306, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384", 49307, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_RSA_WITH_AES_128_CCM", 49308, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_RSA_WITH_AES_256_CCM", 49309, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_RSA_WITH_AES_128_CCM", 49310, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_RSA_WITH_AES_256_CCM", 49311, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_RSA_WITH_AES_128_CCM_8", 49312, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_RSA_WITH_AES_256_CCM_8", 49313, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_RSA_WITH_AES_128_CCM_8", 49314, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_RSA_WITH_AES_256_CCM_8", 49315, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_PSK_WITH_AES_128_CCM", 49316, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_PSK_WITH_AES_256_CCM", 49317, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_DHE_PSK_WITH_AES_128_CCM", 49318, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_DHE_PSK_WITH_AES_256_CCM", 49319, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_PSK_WITH_AES_128_CCM_8", 49320, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_PSK_WITH_AES_256_CCM_8", 49321, TLSCipherSpec.keyStrength.HIGH, false, false, false);
        CipherSuites.addCipher("TLS_PSK_DHE_WITH_AES_128_CCM_8", 49322, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        CipherSuites.addCipher("TLS_PSK_DHE_WITH_AES_256_CCM_8", 49323, TLSCipherSpec.keyStrength.HIGH, false, true, false);
        byte[] byArray = new byte[3];
        byArray[0] = 7;
        byArray[2] = -64;
        CipherSuites.addCipher("SSL2_DES_192_EDE3_CBC_WITH_MD5", byArray, SSLv2CipherSpec.keyStrength.HIGH, false);
        CipherSuites.addCipher("SSL2_DES_192_EDE3_CBC_WITH_SHA", new byte[]{7, 1, -64}, SSLv2CipherSpec.keyStrength.HIGH, false);
        byte[] byArray2 = new byte[3];
        byArray2[0] = 6;
        byArray2[2] = 64;
        CipherSuites.addCipher("SSL2_DES_64_CBC_WITH_MD5", byArray2, SSLv2CipherSpec.keyStrength.LOW, false);
        CipherSuites.addCipher("SSL2_DES_64_CBC_WITH_SHA", new byte[]{6, 1, 64}, SSLv2CipherSpec.keyStrength.LOW, false);
        byte[] byArray3 = new byte[3];
        byArray3[0] = 5;
        byArray3[2] = -128;
        CipherSuites.addCipher("SSL2_IDEA_128_CBC_WITH_MD5", byArray3, SSLv2CipherSpec.keyStrength.HIGH, false);
        byte[] byArray4 = new byte[3];
        byArray4[0] = 3;
        byArray4[2] = -128;
        CipherSuites.addCipher("SSL2_RC2_CBC_WITH_MD5", byArray4, SSLv2CipherSpec.keyStrength.HIGH, false);
        byte[] byArray5 = new byte[3];
        byArray5[0] = 1;
        byArray5[2] = -128;
        CipherSuites.addCipher("SSL2_RC4_128_WITH_MD5", byArray5, SSLv2CipherSpec.keyStrength.HIGH, true);
        byte[] byArray6 = new byte[3];
        byArray6[0] = 6;
        byArray6[2] = 64;
        CipherSuites.addCipher("SSL2_DES_64_CBC_WITH_MD5", byArray6, SSLv2CipherSpec.keyStrength.LOW, false);
        byte[] byArray7 = new byte[3];
        byArray7[0] = 4;
        byArray7[2] = -128;
        CipherSuites.addCipher("SSL2_RC2_CBC_128_CBC_WITH_MD5", byArray7, SSLv2CipherSpec.keyStrength.HIGH, false);
        byte[] byArray8 = new byte[3];
        byArray8[0] = 2;
        byArray8[2] = -128;
        CipherSuites.addCipher("SSL2_RC4_128_EXPORT40_WITH_MD5", byArray8, SSLv2CipherSpec.keyStrength.EXPORT, true);
        CipherSuites.addCipher("SSL2_NULL_WITH_MD5", new byte[3], SSLv2CipherSpec.keyStrength.NONE, false);
        CipherSuites.addCipher("SSL2_NULL", new byte[]{-1, 8, 16}, SSLv2CipherSpec.keyStrength.NONE, false);
        byte[] byArray9 = new byte[3];
        byArray9[0] = -1;
        byArray9[1] = 8;
        CipherSuites.addCipher("SSL2_DES_64_CFB64_WITH_MD5_1", byArray9, SSLv2CipherSpec.keyStrength.LOW, false);
        byte[] byArray10 = new byte[3];
        byArray10[0] = 8;
        byArray10[2] = -128;
        CipherSuites.addCipher("SSL2_RC4_64_WITH_MD5", byArray10, SSLv2CipherSpec.keyStrength.LOW, true);
    }

    public static List<List<TLSCipherSpec>> paritionTLSCiphers(int n) {
        return Lists.partition(TLS_CIPHERS, (int)n);
    }

    static TLSCipherSpec lookupTLSCipher(int n) {
        return TLS_CIPHER_MAP.get(n);
    }

    public static List<SSLv2CipherSpec> getV2CipherSuites() {
        return Collections.unmodifiableList(new ArrayList<SSLv2CipherSpec>(SSLv2_CIPHERS));
    }

    public static SSLv2CipherSpec lookupSSLv2Cipher(int n) {
        return SSLv2_CIPHER_MAP.get(n);
    }

    private static void addCipher(String string, int n, TLSCipherSpec.keyStrength keyStrength2, boolean bl, boolean bl2, boolean bl3) {
        TLSCipherSpec tLSCipherSpec = new TLSCipherSpec(string, n, keyStrength2, bl, bl2, bl3);
        TLS_CIPHER_MAP.put(n, tLSCipherSpec);
        TLS_CIPHERS.add(tLSCipherSpec);
    }

    private static void addCipher(String string, byte[] byArray, SSLv2CipherSpec.keyStrength keyStrength2, boolean bl) {
        SSLv2CipherSpec sSLv2CipherSpec = new SSLv2CipherSpec(string, byArray, keyStrength2, bl);
        SSLv2_CIPHER_MAP.put(sSLv2CipherSpec.getNum(), sSLv2CipherSpec);
        SSLv2_CIPHERS.add(sSLv2CipherSpec);
    }
}

