/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.analysis;

import com.subgraph.vega.api.http.requests.IHttpResponse;

public class JavascriptDetector {
    private static final int MAX_JS_WHITE = 16;

    boolean isBodyJavascript(IHttpResponse iHttpResponse) {
        if (!iHttpResponse.isMostlyAscii()) {
            return false;
        }
        String string = iHttpResponse.getBodyAsString();
        if (string == null || string.isEmpty()) {
            return false;
        }
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        while (n < string.length()) {
            if ((n = this.skipComments(string, n)) >= string.length()) break;
            if (string.startsWith(" saved from url=", n)) {
                return false;
            }
            char c = string.charAt(n);
            if ("({[\"'".indexOf(c) != -1) {
                return true;
            }
            if (bl && "=;".indexOf(c) != -1) {
                return true;
            }
            if (!Character.isLetterOrDigit(c) && !Character.isWhitespace(c) && c != '_' && c != '$' && c != '.') {
                return false;
            }
            if (!Character.isWhitespace(c) && ++n2 > 16) {
                return false;
            }
            bl = true;
            ++n;
        }
        return false;
    }

    private int skipComments(String string, int n) {
        while (n < string.length()) {
            int n2;
            if (string.startsWith("<!--", n)) {
                n += 4;
                continue;
            }
            if (string.startsWith("//")) {
                n2 = string.indexOf("\r\n", 2);
                n = n2 == -1 ? string.length() : n + n2 + 2;
                continue;
            }
            if (string.startsWith("/*")) {
                n2 = string.indexOf("*/");
                n = n2 == -1 ? string.length() : n + n2 + 2;
                continue;
            }
            return n;
        }
        return n;
    }
}

