/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.tree.web;

import com.subgraph.vega.api.model.web.IWebPath;
import com.subgraph.vega.api.model.web.IWebResponse;
import com.subgraph.vega.ui.tree.ITreeAdapter;
import java.util.ArrayList;

public class WebPathTreeStrategy
implements ITreeAdapter<IWebPath> {
    @Override
    public Object[] getChildren(IWebPath iWebPath) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (IWebPath iWebPath2 : iWebPath.getChildPaths()) {
            Object object = this.collapsedNode(iWebPath, iWebPath2);
            if (object != null) {
                arrayList.add(object);
            }
            for (IWebResponse iWebResponse : iWebPath2.getGetResponses()) {
                arrayList.add(iWebResponse);
            }
            for (IWebResponse iWebResponse : iWebPath2.getPostResponses()) {
                arrayList.add(iWebResponse);
            }
        }
        return arrayList.toArray();
    }

    private Object collapsedNode(IWebPath iWebPath, IWebPath iWebPath2) {
        boolean bl;
        boolean bl2 = bl = iWebPath2.getGetResponses().size() == 0 && iWebPath2.getPostResponses().size() == 0;
        if (iWebPath2.getChildPaths().size() == 1 && bl) {
            return this.collapsedNode(iWebPath, (IWebPath)iWebPath2.getChildPaths().iterator().next());
        }
        if (iWebPath2.getChildPaths().isEmpty() && !bl) {
            IWebPath iWebPath3 = iWebPath2.getParentPath();
            if (iWebPath3 == null || iWebPath3 == iWebPath) {
                return null;
            }
            return iWebPath3;
        }
        return iWebPath2;
    }

    @Override
    public int getChildrenCount(IWebPath iWebPath) {
        return this.getChildren(iWebPath).length;
    }

    @Override
    public Object getParent(IWebPath iWebPath) {
        if (iWebPath.getParentPath() == null) {
            return iWebPath.getMountPoint().getWebHost();
        }
        if (iWebPath.getParentPath().getChildPaths().size() == 1) {
            return this.getParent(iWebPath.getParentPath());
        }
        return iWebPath.getParentPath();
    }

    @Override
    public String getLabel(IWebPath iWebPath) {
        if (iWebPath.getParentPath() == null) {
            return "/";
        }
        if (this.getChildrenCount(iWebPath) == 0 && (iWebPath.getPathComponent().contains(".") || iWebPath.getMimeType() != null)) {
            return iWebPath.getPathComponent();
        }
        return String.valueOf(this.prevLabel(iWebPath)) + "/" + iWebPath.getPathComponent();
    }

    private String prevLabel(IWebPath iWebPath) {
        IWebPath iWebPath2 = iWebPath.getParentPath();
        if (iWebPath2.getChildPaths().size() == 1 && iWebPath2.getParentPath() != null) {
            return this.getLabel(iWebPath2);
        }
        return "";
    }
}

