/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.application.workspaces;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class WorkspaceNamePage
extends WizardPage {
    private Text workspaceNameText;

    WorkspaceNamePage() {
        super("firstPage");
        this.setTitle("New Workspace");
        this.setDescription("Create a new Workspace.");
        this.setPageComplete(false);
    }

    public void createControl(Composite composite) {
        Composite composite2 = this.createComposite(composite);
        this.workspaceNameText = this.createWorkspaceName(composite2);
    }

    public String getWorkspaceName() {
        return this.workspaceNameText.getText();
    }

    private Text createWorkspaceName(Composite composite) {
        this.createLabel(composite, "Workspace Name:");
        final Text text = this.createText(composite, 16);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (text.getText().length() > 0) {
                    WorkspaceNamePage.this.setErrorMessage(null);
                    WorkspaceNamePage.this.setPageComplete(true);
                } else {
                    WorkspaceNamePage.this.setErrorMessage("Workspace name is empty.");
                    WorkspaceNamePage.this.setPageComplete(false);
                }
            }
        });
        return text;
    }

    private void createLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData(0x1000008, 0x1000000, false, false);
        label.setLayoutData((Object)gridData);
        label.setText(string);
    }

    private Composite createComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 20;
        composite2.setLayout((Layout)gridLayout);
        this.setControl((Control)composite2);
        return composite2;
    }

    private Text createText(Composite composite, int n) {
        Text text = new Text(composite, 2048);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 10 * n;
        text.setLayoutData((Object)gridData);
        text.setTextLimit(n);
        return text;
    }
}

