/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.application.workspaces;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.api.model.WorkspaceLockStatusEvent;
import com.subgraph.vega.application.Activator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.AbstractSourceProvider;

public class WorkspaceLockStateSourceProvider
extends AbstractSourceProvider {
    static final String WORKSPACE_LOCK_STATE = "vega.workspaceLockState";
    static final String WORKSPACE_LOCKED = "locked";
    static final String WORKSPACE_UNLOCKED = "unlocked";
    private boolean isLocked = false;

    public WorkspaceLockStateSourceProvider() {
        IModel iModel = Activator.getDefault().getModel();
        iModel.addWorkspaceListener(new IEventHandler(){

            public void handleEvent(IEvent iEvent) {
                if (iEvent instanceof WorkspaceLockStatusEvent) {
                    WorkspaceLockStateSourceProvider.this.handleWorkspaceLockStatus((WorkspaceLockStatusEvent)iEvent);
                }
            }
        });
    }

    private void handleWorkspaceLockStatus(WorkspaceLockStatusEvent workspaceLockStatusEvent) {
        boolean bl = workspaceLockStatusEvent.isLockEvent();
        if (bl != this.isLocked) {
            this.isLocked = bl;
            this.fireSourceChanged(0, WORKSPACE_LOCK_STATE, this.getCurrentWorkspaceLockState());
        }
    }

    public void dispose() {
    }

    public synchronized Map<?, ?> getCurrentState() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put(WORKSPACE_LOCK_STATE, this.getCurrentWorkspaceLockState());
        return hashMap;
    }

    private String getCurrentWorkspaceLockState() {
        if (this.isLocked) {
            return WORKSPACE_LOCKED;
        }
        return WORKSPACE_UNLOCKED;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{WORKSPACE_LOCK_STATE};
    }
}

