/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.application.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    Date dat = new Date();
    private static final String format = "{0,time}";
    private MessageFormat formatter;
    private Object[] args = new Object[1];

    @Override
    public synchronized String format(LogRecord logRecord) {
        StringBuilder stringBuilder = new StringBuilder();
        this.dat.setTime(logRecord.getMillis());
        this.args[0] = this.dat;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.formatter == null) {
            this.formatter = new MessageFormat(format);
        }
        this.formatter.format(this.args, stringBuffer, (FieldPosition)null);
        stringBuilder.append(stringBuffer);
        stringBuilder.append(" [");
        stringBuilder.append(logRecord.getLevel().getLocalizedName());
        stringBuilder.append("] (");
        stringBuilder.append(logRecord.getLoggerName());
        stringBuilder.append(") ");
        stringBuilder.append(this.formatMessage(logRecord));
        stringBuilder.append("\n");
        if (logRecord.getThrown() != null) {
            try {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                logRecord.getThrown().printStackTrace(printWriter);
                printWriter.close();
                stringBuilder.append(stringWriter.toString());
            }
            catch (Exception exception) {
                stringBuilder.append("Exception caused by writing exception backtrace to message!  : " + exception.getMessage());
            }
        }
        return stringBuilder.toString();
    }
}

