/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.application.console;

import com.subgraph.vega.api.console.IConsoleDisplay;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ConsoleHandler
implements IConsoleDisplay {
    private final MessageConsole console = ConsoleHandler.createMessageConsole();
    private final MessageConsoleStream outputStream = this.console.newMessageStream();
    private final MessageConsoleStream debugStream = this.console.newMessageStream();
    private final MessageConsoleStream errorStream;

    public ConsoleHandler(Display display, com.subgraph.vega.api.console.IConsole iConsole) {
        this.debugStream.setColor(display.getSystemColor(9));
        this.errorStream = this.console.newMessageStream();
        this.errorStream.setColor(display.getSystemColor(3));
        iConsole.registerDisplay((IConsoleDisplay)this);
    }

    public void activate() {
    }

    private static MessageConsole createMessageConsole() {
        MessageConsole messageConsole = new MessageConsole("Vega Log", null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{messageConsole});
        return messageConsole;
    }

    public void printOutput(String string) {
        this.outputStream.print(string);
    }

    public void printDebug(String string) {
        this.debugStream.print(string);
    }

    public void printError(String string) {
        this.errorStream.print(string);
    }
}

