/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.application.about;

import com.subgraph.vega.application.Activator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AboutDialog
extends TitleAreaDialog {
    private static final String LOGO_IMAGE = "icons/subgraph.png";
    private String aboutText = "Vega, the Open Source Web Application Security Platform.\n\nVersion: 1.0\nBuild id: devel-130\n\n(c) Copyright Subgraph Technologies, Inc. and others, 2014. All rights reserved.\nhttps://subgraph.com\n\nVega would not have been possible without the generous contributions of the \nopen source and security research communities.\n\nWith much appreciation, we acknowledge that Vega is built upon the work of many \nother individuals and projects, and includes code from the following:\n \nthe Eclipse Foundation http://www.eclipse.org\nthe Apache Software Foundation http://apache.org\nthe Mozilla Foundation http://mozilla.org\nJonathan Headley http://jsoup.org\nGoogle, Inc. http://www.google.com\n\nThe Vega scanner owes much to the innovative work implemented in Skipfish\nby Michal Zalewski. \n\nThe Vega 1.0 team is:\n\nBruce Leidl\nDavid Mirza Ahmad\nTina Salameh\nDavid McKinney\n\nVega Beta contributors also included Hugo Fortier and Cade Cairns.\n\nSpecial thanks to Lars Vogel for his Eclipse RCP tutorials.\n";

    public AboutDialog(Shell shell) {
        super(shell);
        this.setTitle("About Vega");
        this.setTitleImage(this.createLogoImage());
    }

    private Image createLogoImage() {
        ImageDescriptor imageDescriptor = Activator.getImageDescriptor(LOGO_IMAGE);
        if (imageDescriptor != null) {
            return imageDescriptor.createImage();
        }
        return null;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        Text text = new Text(composite2, 2568);
        text.setLayoutData((Object)gridData);
        text.setText(this.aboutText);
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        Button button = this.createButton(composite, 0, "Close", true);
        button.setEnabled(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AboutDialog.this.close();
            }
        });
    }
}

