/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.application;

import com.subgraph.vega.api.console.IConsole;
import com.subgraph.vega.api.http.requests.IHttpRequestEngineFactory;
import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.api.paths.IPathFinder;
import org.apache.http.HttpHost;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.subgraph.vega.application";
    private static Activator plugin;
    private ServiceTracker<IModel, IModel> modelTracker;
    private ServiceTracker<IConsole, IConsole> consoleTracker;
    private ServiceTracker<IPathFinder, IPathFinder> pathFinderTracker;
    private ServiceTracker<IHttpRequestEngineFactory, IHttpRequestEngineFactory> httpRequestEngineFactoryServiceTracker;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        this.modelTracker = new ServiceTracker(bundleContext, IModel.class.getName(), null);
        this.modelTracker.open();
        this.consoleTracker = new ServiceTracker(bundleContext, IConsole.class.getName(), null);
        this.consoleTracker.open();
        this.pathFinderTracker = new ServiceTracker(bundleContext, IPathFinder.class.getName(), null);
        this.pathFinderTracker.open();
        this.httpRequestEngineFactoryServiceTracker = new ServiceTracker(bundleContext, IHttpRequestEngineFactory.class.getName(), null);
        this.httpRequestEngineFactoryServiceTracker.open();
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Activator.this.configureSocks();
                Activator.this.configureHttpProxy();
            }
        });
        this.configureSocks();
        this.configureHttpProxy();
    }

    private void configureSocks() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        if (!iPreferenceStore.getBoolean("vega.preferences.socksEnabled")) {
            System.getProperties().remove("socksProxyHost");
            System.getProperties().remove("socksProxyPort");
            System.getProperties().remove("socksEnabled");
            return;
        }
        System.setProperty("socksProxyHost", iPreferenceStore.getString("vega.preferences.socksAddress"));
        System.setProperty("socksProxyPort", iPreferenceStore.getString("vega.preferences.socksPort"));
        System.setProperty("socksEnabled", "true");
    }

    private void configureHttpProxy() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        IHttpRequestEngineFactory iHttpRequestEngineFactory = this.getHttpRequestEngineFactoryService();
        if (iPreferenceStore.getBoolean("vega.preferences.proxyEnabled")) {
            String string = iPreferenceStore.getString("vega.preferences.proxyAddress");
            Integer n = iPreferenceStore.getInt("vega.preferences.proxyPort");
            iHttpRequestEngineFactory.setProxy(new HttpHost(string, n.intValue()));
        } else {
            iHttpRequestEngineFactory.setProxy(null);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        super.stop(bundleContext);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)string);
    }

    public IModel getModel() {
        return (IModel)this.modelTracker.getService();
    }

    public IConsole getConsole() {
        return (IConsole)this.consoleTracker.getService();
    }

    public IPathFinder getPathFinder() {
        return (IPathFinder)this.pathFinderTracker.getService();
    }

    public IHttpRequestEngineFactory getHttpRequestEngineFactoryService() {
        return (IHttpRequestEngineFactory)this.httpRequestEngineFactoryServiceTracker.getService();
    }
}

