/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.modules.scripting.dom;

import com.subgraph.vega.impl.scanner.modules.scripting.dom.DocumentJS;
import com.subgraph.vega.impl.scanner.modules.scripting.dom.HTMLElementJS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLElement;

public class HTMLCollectionJS
extends ScriptableObject {
    private static final long serialVersionUID = 1L;
    private final List<Scriptable> byIndex = new ArrayList<Scriptable>();
    private final Map<String, Scriptable> byName = new HashMap<String, Scriptable>();
    private final Map<String, Scriptable> byId = new HashMap<String, Scriptable>();

    public HTMLCollectionJS() {
    }

    public HTMLCollectionJS(HTMLCollection hTMLCollection, Scriptable scriptable, DocumentJS documentJS) {
        int n = 0;
        while (n < hTMLCollection.getLength()) {
            Node node = hTMLCollection.item(n);
            if (node instanceof HTMLElement) {
                this.addHTMLElement((HTMLElement)node, scriptable, documentJS);
            }
            ++n;
        }
    }

    private void addHTMLElement(HTMLElement hTMLElement, Scriptable scriptable, DocumentJS documentJS) {
        HTMLElementJS hTMLElementJS = HTMLElementJS.domHTMLElementToJS(hTMLElement, documentJS);
        hTMLElementJS.setParentScope(scriptable);
        hTMLElementJS.setPrototype(ScriptableObject.getClassPrototype((Scriptable)scriptable, (String)hTMLElementJS.getClassName()));
        this.byIndex.add((Scriptable)hTMLElementJS);
        String string = hTMLElement.getId();
        String string2 = hTMLElement.getAttribute("name");
        if (string != null) {
            this.byId.put(string, (Scriptable)hTMLElementJS);
        }
        if (string2 != null) {
            this.byName.put(string2, (Scriptable)hTMLElementJS);
        }
    }

    public void jsConstructor(Object object) {
    }

    public String getClassName() {
        return "HTMLCollection";
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = this.jsFunction_namedItem(string);
        if (object != null) {
            return object;
        }
        return super.get(string, scriptable);
    }

    public int jsGet_length() {
        return this.byIndex.size();
    }

    public Scriptable jsFunction_item(int n) {
        if (n < 0 || n >= this.byIndex.size()) {
            return null;
        }
        return this.byIndex.get(n);
    }

    public Object jsFunction_namedItem(String string) {
        if (this.byId.containsKey(string)) {
            return this.byId.get(string);
        }
        return this.byName.get(string);
    }
}

