/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.modules.scripting;

import com.subgraph.vega.api.scanner.modules.ModuleScriptType;
import com.subgraph.vega.impl.scanner.modules.scripting.ModuleValidator;
import com.subgraph.vega.impl.scanner.modules.scripting.ScriptFile;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class ScriptedModule {
    private final ScriptFile scriptFile;
    private String categoryName;
    private String moduleName;
    private ModuleScriptType moduleType;
    private Function runFunction;
    private boolean isDisabledInScript;
    private boolean isDefaultEnabled;
    private boolean isTimeSensitive;
    private boolean isDifferential;

    public ScriptedModule(ScriptFile scriptFile, String string, ModuleValidator moduleValidator) {
        this.scriptFile = scriptFile;
        this.updateFromValidator(moduleValidator);
        this.categoryName = string;
    }

    public ScriptedModule(ScriptFile scriptFile, ModuleValidator moduleValidator) {
        this.scriptFile = scriptFile;
        this.updateFromValidator(moduleValidator);
    }

    public void updateFromValidator(ModuleValidator moduleValidator) {
        this.categoryName = moduleValidator.getCategoryName();
        this.moduleName = moduleValidator.getName();
        this.moduleType = moduleValidator.getType();
        this.runFunction = moduleValidator.getRunFunction();
        this.isDisabledInScript = moduleValidator.isDisabled();
        this.isDefaultEnabled = moduleValidator.isDefaultEnabled();
        this.isTimeSensitive = moduleValidator.isTimeSensitive();
        this.isDifferential = moduleValidator.isDifferential();
    }

    public Scriptable createInstanceScope(Context context) {
        Scriptable scriptable = context.newObject(this.scriptFile.getCompiledScript());
        scriptable.setPrototype(this.scriptFile.getCompiledScript());
        scriptable.setParentScope(null);
        return scriptable;
    }

    public void runModule(Context context, Scriptable scriptable) {
        this.runModule(context, scriptable, new Object[0]);
    }

    public void runModule(Context context, Scriptable scriptable, Object[] objectArray) {
        this.runFunction.call(context, scriptable, scriptable, objectArray);
    }

    public ScriptFile getScriptFile() {
        return this.scriptFile;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public boolean isDifferential() {
        return this.isDifferential;
    }

    public boolean isTimeSensitive() {
        return this.isTimeSensitive;
    }

    public ModuleScriptType getModuleType() {
        return this.moduleType;
    }

    public Scriptable getModuleScope() {
        return this.scriptFile.getCompiledScript();
    }

    public boolean isDefaultEnabled() {
        return this.isDefaultEnabled;
    }

    public boolean isDisabled() {
        return this.isDisabledInScript;
    }
}

