/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.modules.scripting;

import com.subgraph.vega.api.scanner.modules.ModuleScriptType;
import com.subgraph.vega.impl.scanner.modules.scripting.ModuleValidator;
import com.subgraph.vega.impl.scanner.modules.scripting.PreludeLoader;
import com.subgraph.vega.impl.scanner.modules.scripting.ScriptCompiler;
import com.subgraph.vega.impl.scanner.modules.scripting.ScriptFile;
import com.subgraph.vega.impl.scanner.modules.scripting.ScriptedModule;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ScriptLoader {
    private final Logger logger = Logger.getLogger("script-loader");
    private final Scriptable globalScope;
    private final File moduleRoot;
    private final PreludeLoader preludeLoader;
    private final ScriptCompiler moduleCompiler;
    private final boolean preludeLoadFailed;
    private final Map<File, ScriptedModule> modulePathMap = new HashMap<File, ScriptedModule>();
    private final Map<File, ScriptFile> scriptPathMap = new HashMap<File, ScriptFile>();
    private final FileFilter scriptFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(".js");
        }
    };
    private final FileFilter directoryFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    };

    public ScriptLoader(File file) {
        this.logger.info("Loading scripts from " + file.getAbsolutePath());
        this.moduleRoot = file;
        this.enableDynamicScope();
        this.globalScope = this.createGlobalScope();
        this.preludeLoader = new PreludeLoader(new File(file, "prelude"), this.globalScope);
        this.preludeLoadFailed = !this.preludeLoader.load();
        this.moduleCompiler = this.preludeLoadFailed ? null : new ScriptCompiler(this.preludeLoader.getPreludeScope());
    }

    private void enableDynamicScope() {
        ContextFactory.initGlobal((ContextFactory)new ContextFactory(){

            protected boolean hasFeature(Context context, int n) {
                if (n == 7) {
                    return true;
                }
                return super.hasFeature(context, n);
            }
        });
    }

    private Scriptable createGlobalScope() {
        try {
            Context context = Context.enter();
            ImporterTopLevel importerTopLevel = new ImporterTopLevel(context, true);
            ScriptableObject scriptableObject = context.initStandardObjects((ScriptableObject)importerTopLevel, true);
            return scriptableObject;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ScriptedModule> getAllModulesByType(ModuleScriptType moduleScriptType) {
        ArrayList<ScriptedModule> arrayList = new ArrayList<ScriptedModule>();
        Map<File, ScriptedModule> map = this.modulePathMap;
        synchronized (map) {
            for (ScriptedModule scriptedModule : this.modulePathMap.values()) {
                if (scriptedModule.isDisabled() || moduleScriptType != null && moduleScriptType != scriptedModule.getModuleType()) continue;
                arrayList.add(scriptedModule);
            }
        }
        return arrayList;
    }

    public List<ScriptedModule> getAllModules() {
        return this.getAllModulesByType(null);
    }

    public Scriptable getPreludeScope() {
        return this.preludeLoader.getPreludeScope();
    }

    private ScriptedModule compileModuleScript(ScriptFile scriptFile) {
        ModuleValidator moduleValidator = this.compileAndValidate(scriptFile);
        if (moduleValidator == null) {
            return null;
        }
        return new ScriptedModule(scriptFile, moduleValidator);
    }

    private boolean recompileModule(ScriptedModule scriptedModule) {
        ModuleValidator moduleValidator = this.compileAndValidate(scriptedModule.getScriptFile());
        if (moduleValidator == null) {
            return false;
        }
        scriptedModule.updateFromValidator(moduleValidator);
        return true;
    }

    private ModuleValidator compileAndValidate(ScriptFile scriptFile) {
        if (!this.moduleCompiler.compile(scriptFile) || scriptFile.getCompileStatus() != ScriptFile.CompileStatus.COMPILE_SUCCEEDED) {
            this.logger.warning(scriptFile.getCompileFailureMessage());
            return null;
        }
        return this.validateModule(scriptFile.getCompiledScript(), scriptFile.getPath());
    }

    private ModuleValidator validateModule(Scriptable scriptable, String string) {
        ModuleValidator moduleValidator = new ModuleValidator(scriptable);
        try {
            moduleValidator.validate();
            return moduleValidator;
        }
        catch (ModuleValidator.ModuleValidationException moduleValidationException) {
            this.logger.warning("Failed to validate module script " + string + " :" + moduleValidationException.getMessage());
            return null;
        }
    }

    private List<File> allScriptPaths() {
        File file = new File(this.moduleRoot, "modules");
        ArrayList<File> arrayList = new ArrayList<File>();
        this.crawlDirectory(file, arrayList);
        return arrayList;
    }

    private void crawlDirectory(File file, List<File> list) {
        File file2;
        File[] fileArray = file.listFiles(this.scriptFilter);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            file2 = fileArray[n2];
            list.add(file2);
            ++n2;
        }
        fileArray = file.listFiles(this.directoryFilter);
        n = fileArray.length;
        n2 = 0;
        while (n2 < n) {
            file2 = fileArray[n2];
            this.crawlDirectory(file2, list);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reloadModules() {
        boolean bl = false;
        if (this.preludeLoadFailed) {
            return false;
        }
        Map<File, ScriptedModule> map = this.modulePathMap;
        synchronized (map) {
            this.synchronizeScriptPaths();
            for (Map.Entry<File, ScriptFile> entry : this.scriptPathMap.entrySet()) {
                if (!this.compileScriptFileIfNeeded(entry.getKey(), entry.getValue())) continue;
                bl = true;
            }
        }
        return bl;
    }

    private void synchronizeScriptPaths() {
        HashSet<File> hashSet = new HashSet<File>();
        for (File serializable2 : this.allScriptPaths()) {
            hashSet.add(serializable2);
            if (this.scriptPathMap.containsKey(serializable2)) continue;
            this.scriptPathMap.put(serializable2, new ScriptFile(serializable2));
        }
        ArrayList<File> arrayList = new ArrayList<File>(this.scriptPathMap.keySet());
        for (Object file : arrayList) {
            if (hashSet.contains(file)) continue;
            this.modulePathMap.remove(file);
            this.scriptPathMap.remove(file);
        }
    }

    private boolean compileScriptFileIfNeeded(File file, ScriptFile scriptFile) {
        if (!this.isCompileNeeded(scriptFile)) {
            return false;
        }
        if (this.modulePathMap.containsKey(file)) {
            if (!this.recompileModule(this.modulePathMap.get(file))) {
                this.modulePathMap.remove(file);
            }
        } else {
            ScriptedModule scriptedModule = this.compileModuleScript(scriptFile);
            if (scriptedModule != null) {
                this.modulePathMap.put(file, scriptedModule);
            }
        }
        return true;
    }

    private boolean isCompileNeeded(ScriptFile scriptFile) {
        return scriptFile.getCompileStatus() == ScriptFile.CompileStatus.NOT_COMPILED || scriptFile.hasFileChanged();
    }
}

