/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.modules.scripting;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.mozilla.javascript.Scriptable;

public class ScriptFile {
    private final URL scriptURL;
    private final File scriptFile;
    private long fileLastModified;
    private CompileStatus compileStatus;
    private Scriptable compiledScript;
    private String compileFailureMessage = "";

    public ScriptFile(File file) {
        this(file, null, file.lastModified());
    }

    public ScriptFile(URL uRL) {
        this(null, uRL, 0L);
    }

    private ScriptFile(File file, URL uRL, long l) {
        this.scriptFile = file;
        this.scriptURL = uRL;
        this.fileLastModified = l;
        this.compileStatus = CompileStatus.NOT_COMPILED;
        this.compileFailureMessage = "";
    }

    public String getPath() {
        if (this.scriptFile != null) {
            return this.scriptFile.getAbsolutePath();
        }
        if (this.scriptURL != null) {
            return this.scriptURL.getPath();
        }
        return null;
    }

    public Reader createReader() throws IOException {
        if (this.scriptFile != null) {
            return new FileReader(this.scriptFile);
        }
        if (this.scriptURL != null) {
            return new InputStreamReader(this.scriptURL.openStream());
        }
        return null;
    }

    void setCompiledScript(Scriptable scriptable) {
        this.compiledScript = scriptable;
        this.compileFailureMessage = "";
        this.setCompileStatus(CompileStatus.COMPILE_SUCCEEDED);
    }

    void setCompileFailed(String string) {
        this.compileFailureMessage = string;
        this.compiledScript = null;
        this.setCompileStatus(CompileStatus.COMPILE_FAILED);
    }

    public String getCompileFailureMessage() {
        return this.compileFailureMessage;
    }

    private void setCompileStatus(CompileStatus compileStatus) {
        this.compileStatus = compileStatus;
        if (this.scriptFile != null) {
            this.fileLastModified = this.scriptFile.lastModified();
        }
    }

    public CompileStatus getCompileStatus() {
        return this.compileStatus;
    }

    public Scriptable getCompiledScript() {
        return this.compiledScript;
    }

    public boolean hasFileChanged() {
        if (this.scriptURL != null) {
            return false;
        }
        return this.scriptFile.lastModified() > this.fileLastModified;
    }

    public static enum CompileStatus {
        NOT_COMPILED,
        COMPILE_FAILED,
        COMPILE_SUCCEEDED;

    }
}

