/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.modules.scripting;

import com.subgraph.vega.impl.scanner.modules.scripting.ResponseJS;
import com.subgraph.vega.impl.scanner.modules.scripting.ScriptCompiler;
import com.subgraph.vega.impl.scanner.modules.scripting.ScriptFile;
import com.subgraph.vega.impl.scanner.modules.scripting.dom.AnchorJS;
import com.subgraph.vega.impl.scanner.modules.scripting.dom.AttrJS;
import com.subgraph.vega.impl.scanner.modules.scripting.dom.CharacterDataJS;
import com.subgraph.vega.impl.scanner.modules.scripting.dom.CommentJS;
import com.subgraph.vega.impl.scanner.modules.scripting.dom.DocumentJS;
import com.subgraph.vega.impl.scanner.modules.scripting.dom.ElementJS;
import com.subgraph.vega.impl.scanner.modules.scripting.dom.FormJS;
import com.subgraph.vega.impl.scanner.modules.scripting.dom.HTMLCollectionJS;
import com.subgraph.vega.impl.scanner.modules.scripting.dom.HTMLDocumentJS;
import com.subgraph.vega.impl.scanner.modules.scripting.dom.InputJS;
import com.subgraph.vega.impl.scanner.modules.scripting.dom.LinkJS;
import com.subgraph.vega.impl.scanner.modules.scripting.dom.NodeJS;
import com.subgraph.vega.impl.scanner.modules.scripting.dom.NodeListJS;
import com.subgraph.vega.impl.scanner.modules.scripting.dom.OptionJS;
import com.subgraph.vega.impl.scanner.modules.scripting.dom.SelectJS;
import com.subgraph.vega.impl.scanner.modules.scripting.dom.TextJS;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class PreludeLoader {
    private final Logger logger = Logger.getLogger("prelude-loader");
    private final File preludeDirectory;
    private final ScriptCompiler preludeCompiler;
    private final FileFilter scriptFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(".js");
        }
    };
    private Scriptable preludeScope;

    PreludeLoader(File file, Scriptable scriptable) {
        this.preludeDirectory = file;
        this.preludeCompiler = new ScriptCompiler(scriptable);
    }

    boolean load() {
        try {
            Context context = Context.enter();
            Scriptable scriptable = this.preludeCompiler.newScope(context);
            File[] fileArray = this.preludeDirectory.listFiles(this.scriptFilter);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                ScriptFile scriptFile = new ScriptFile(file);
                if (!this.preludeCompiler.compile(scriptFile, context, scriptable)) {
                    this.logger.warning("Failed to load module prelude");
                    this.logger.warning(scriptFile.getCompileFailureMessage());
                    return false;
                }
                ++n2;
            }
            this.defineHostObject(scriptable, NodeJS.class);
            this.defineHostObject(scriptable, DocumentJS.class);
            this.defineHostObject(scriptable, ElementJS.class);
            this.defineHostObject(scriptable, AttrJS.class);
            this.defineHostObject(scriptable, CharacterDataJS.class);
            this.defineHostObject(scriptable, TextJS.class);
            this.defineHostObject(scriptable, AnchorJS.class);
            this.defineHostObject(scriptable, FormJS.class);
            this.defineHostObject(scriptable, CommentJS.class);
            this.defineHostObject(scriptable, HTMLCollectionJS.class);
            this.defineHostObject(scriptable, HTMLDocumentJS.class);
            this.defineHostObject(scriptable, InputJS.class);
            this.defineHostObject(scriptable, LinkJS.class);
            this.defineHostObject(scriptable, OptionJS.class);
            this.defineHostObject(scriptable, SelectJS.class);
            this.defineHostObject(scriptable, NodeListJS.class);
            this.defineHostObject(scriptable, ResponseJS.class);
            this.preludeScope = scriptable;
            return true;
        }
        catch (Exception exception) {
            this.logger.log(Level.WARNING, "Unexpected exception loading prelude: " + exception);
            return false;
        }
        finally {
            Context.exit();
        }
    }

    private void defineHostObject(Scriptable scriptable, Class<? extends ScriptableObject> clazz) {
        try {
            ScriptableObject.defineClass((Scriptable)scriptable, clazz, (boolean)true, (boolean)true);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.logger.warning("IllegalAccessException defining class '" + clazz.getName() + "' : " + illegalAccessException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            this.logger.warning("InstantiationException defining class '" + clazz.getName() + "' : " + instantiationException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            this.logger.warning("InvocationTargetException defining class '" + clazz.getName() + "' : " + invocationTargetException.getMessage());
        }
    }

    Scriptable getPreludeScope() {
        return this.preludeScope;
    }
}

