/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.modules.scripting;

import com.subgraph.vega.api.scanner.modules.ModuleScriptType;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class ModuleValidator {
    private final Scriptable moduleScope;
    private String moduleName;
    private String categoryName;
    private ModuleScriptType moduleType;
    private Function runFunction;
    private boolean isValidated;
    private boolean isDisabled;
    private boolean isDefaultDisabled;
    private boolean isTimeSensitive;
    private boolean isDifferential;

    public ModuleValidator(Scriptable scriptable) {
        this.moduleScope = scriptable;
    }

    public void validate() throws ModuleValidationException {
        if (this.isValidated) {
            return;
        }
        Scriptable scriptable = this.getModule();
        this.moduleName = this.getStringFromModuleObject(scriptable, "name");
        this.moduleType = this.getScriptType(scriptable);
        this.categoryName = this.hasStringInModuleObject(scriptable, "category") ? this.getStringFromModuleObject(scriptable, "category") : this.moduleType.getVerboseName();
        this.runFunction = this.getEntryFunction();
        this.isDisabled = this.getFlagFromModuleObject(scriptable, "disabled");
        this.isDefaultDisabled = this.getFlagFromModuleObject(scriptable, "defaultDisabled");
        this.isTimeSensitive = this.getFlagFromModuleObject(scriptable, "timeSensitive");
        this.isDifferential = this.getFlagFromModuleObject(scriptable, "differential");
        this.isValidated = true;
    }

    public String getName() {
        if (!this.isValidated) {
            throw new IllegalStateException("Cannot get name because module is not validated");
        }
        return this.moduleName;
    }

    public String getCategoryName() {
        if (!this.isValidated) {
            throw new IllegalStateException("Cannot get category name because module is not validated");
        }
        return this.categoryName;
    }

    public boolean isDisabled() {
        if (!this.isValidated) {
            throw new IllegalStateException("Cannot get disabled flag because module is not validated");
        }
        return this.isDisabled;
    }

    public boolean isDefaultEnabled() {
        if (!this.isValidated) {
            throw new IllegalStateException("Cannot get default enabled flag because module is not validated");
        }
        return !this.isDefaultDisabled;
    }

    public boolean isTimeSensitive() {
        if (!this.isValidated) {
            throw new IllegalStateException("Cannot get time sensitive flag because module is not validated");
        }
        return this.isTimeSensitive;
    }

    public boolean isDifferential() {
        if (!this.isValidated) {
            throw new IllegalStateException("Cannot get differential flag because module is not validated");
        }
        return this.isDifferential;
    }

    public ModuleScriptType getType() {
        if (!this.isValidated) {
            throw new IllegalStateException("Cannot get type because module is not validated");
        }
        return this.moduleType;
    }

    public Function getRunFunction() {
        if (!this.isValidated) {
            throw new IllegalStateException("Cannot get run function because module is not validated");
        }
        return this.runFunction;
    }

    private Scriptable getModule() throws ModuleValidationException {
        Object object = this.moduleScope.get("module", this.moduleScope);
        if (object == Scriptable.NOT_FOUND) {
            throw new ModuleValidationException("No 'module' object found.");
        }
        return Context.toObject((Object)object, (Scriptable)this.moduleScope);
    }

    private ModuleScriptType getScriptType(Scriptable scriptable) throws ModuleValidationException {
        if (!this.hasStringInModuleObject(scriptable, "type")) {
            return ModuleScriptType.BASIC_MODULE;
        }
        String string = this.getStringFromModuleObject(scriptable, "type");
        ModuleScriptType moduleScriptType = ModuleScriptType.lookup((String)string);
        if (moduleScriptType == null) {
            throw new ModuleValidationException("Unrecognized module type: " + string);
        }
        return moduleScriptType;
    }

    private boolean hasStringInModuleObject(Scriptable scriptable, String string) {
        Object object = scriptable.get(string, this.moduleScope);
        return object != Scriptable.NOT_FOUND && object instanceof String;
    }

    private String getStringFromModuleObject(Scriptable scriptable, String string) throws ModuleValidationException {
        Object object = scriptable.get(string, this.moduleScope);
        if (object == Scriptable.NOT_FOUND) {
            throw new ModuleValidationException("Could not find module property '" + string + "'.");
        }
        if (!(object instanceof String)) {
            throw new ModuleValidationException("Module property '" + string + "' is not a string type as expected.");
        }
        return (String)object;
    }

    private boolean getFlagFromModuleObject(Scriptable scriptable, String string) {
        Object object = scriptable.get(string, this.moduleScope);
        return object != Scriptable.NOT_FOUND;
    }

    private Function getEntryFunction() throws ModuleValidationException {
        Function function = this.getGlobalFunction("run");
        if (function == null) {
            function = this.getGlobalFunction("initialize");
        }
        if (function == null) {
            throw new ModuleValidationException("Could not find global entry function 'run()' or 'initialize()' in module.");
        }
        return function;
    }

    private Function getGlobalFunction(String string) throws ModuleValidationException {
        Object object = this.moduleScope.get(string, this.moduleScope);
        if (object == Scriptable.NOT_FOUND) {
            return null;
        }
        if (!(object instanceof Function)) {
            throw new ModuleValidationException("Global identifier '" + string + "' is not a function as expected");
        }
        return (Function)object;
    }

    public static class ModuleValidationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        ModuleValidationException(String string) {
            super(string);
        }
    }
}

