/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.hexeditor;

import com.subgraph.vega.ui.hexeditor.HexEditModel;

public class HexEditModelItem {
    private final HexEditModel model;
    private final int itemOffset;
    private final byte[] data;
    private final int rowCount;
    private final int rowLength;

    HexEditModelItem(HexEditModel hexEditModel, int n, byte[] byArray, int n2, int n3) {
        this.model = hexEditModel;
        this.itemOffset = n;
        this.data = byArray;
        this.rowCount = n2;
        this.rowLength = n3;
    }

    int getOffset() {
        return this.itemOffset;
    }

    int getRowByteCount() {
        return this.rowCount;
    }

    int getRowLength() {
        return this.rowLength;
    }

    int getByteAt(int n) {
        if (n < 0 || n >= this.rowLength) {
            throw new IllegalArgumentException();
        }
        if (n + this.itemOffset >= this.data.length) {
            return -1;
        }
        return this.data[n + this.itemOffset] & 0xFF;
    }

    void setByteAt(int n, int n2) {
        if (n < 0 || n >= this.rowCount) {
            throw new IllegalArgumentException();
        }
        this.data[n + this.itemOffset] = (byte)n2;
        this.model.markDirty();
    }

    void getData(byte[] byArray) {
        this.getData(byArray, 0);
    }

    void getData(byte[] byArray, int n) {
        if (byArray.length - n < this.rowCount) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(this.data, this.itemOffset, byArray, n, this.rowCount);
    }
}

