/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.hexeditor;

import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class HexEditFonts {
    private static final String HEX_ELEMENT_FONT = "hex-element";
    private static final String HEX_ASCII_FONT = "hex-ascii";
    private static final int FONT_PADDING = 10;
    private final FontRegistry fontRegistry = new FontRegistry();
    private final int offsetColumnWidth;
    private final int dataColumnWidth;
    private final int asciiColumnWordWidth;

    HexEditFonts(Composite composite) {
        this.addFonts(composite.getDisplay());
        this.offsetColumnWidth = this.calculateOffsetColumnWidth(composite);
        this.dataColumnWidth = this.calculateDataColumnWidth(composite);
        this.asciiColumnWordWidth = this.calculateAsciiColumnWordWidth(composite);
    }

    private void addFonts(Display display) {
        this.add(display, HEX_ELEMENT_FONT, 10, "Monospace", "Courier");
        this.add(display, HEX_ASCII_FONT, 10, "Monospace", "Courier");
    }

    private void add(Display display, String string, int n, String ... stringArray) {
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray2[n3];
            if (this.fontNameExists(display, string2)) {
                this.fontRegistry.put(string, new FontData[]{new FontData(string2, n, 0)});
            }
            ++n3;
        }
    }

    boolean fontNameExists(Display display, String string) {
        return display.getFontList(string, true).length > 0 || display.getFontList(string, false).length > 0;
    }

    Font getElementFont() {
        return this.fontRegistry.get(HEX_ELEMENT_FONT);
    }

    Font getAsciiFont() {
        return this.fontRegistry.get(HEX_ASCII_FONT);
    }

    int getOffsetColumnWidth() {
        return this.offsetColumnWidth;
    }

    int getDataColumnWidth() {
        return this.dataColumnWidth;
    }

    int getAsciiColumnWordWidth() {
        return this.asciiColumnWordWidth;
    }

    private int calculateOffsetColumnWidth(Composite composite) {
        GC gC = new GC((Drawable)composite);
        return this.getColumnWidth(HEX_ELEMENT_FONT, "000000", gC);
    }

    private int calculateDataColumnWidth(Composite composite) {
        GC gC = new GC((Drawable)composite);
        return this.getColumnWidth(HEX_ELEMENT_FONT, "00", gC);
    }

    private int calculateAsciiColumnWordWidth(Composite composite) {
        GC gC = new GC((Drawable)composite);
        return this.getColumnWidth(HEX_ASCII_FONT, "0000", gC);
    }

    private int getColumnWidth(String string, String string2, GC gC) {
        gC.setFont(this.fontRegistry.get(string));
        Point point = gC.textExtent(string2);
        return point.x + 20;
    }
}

