/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.hexeditor;

import com.subgraph.vega.ui.hexeditor.HexEditContentProvider;
import com.subgraph.vega.ui.hexeditor.HexEditFonts;
import com.subgraph.vega.ui.hexeditor.HexEditLabelProvider;
import com.subgraph.vega.ui.hexeditor.HexEditModel;
import com.subgraph.vega.ui.hexeditor.HexEditTableEditor;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class HexEditControl
extends Composite {
    private static final int WORD_SIZE = 4;
    private static final int MINIMUM_DATA_COLUMNS = 4;
    private final HexEditFonts fonts = new HexEditFonts(this);
    private TableViewer tableViewer;
    private HexEditModel model;
    private int currentDataColumnCount;
    private boolean editable = true;
    private volatile boolean enablePreserveSelection = true;

    public HexEditControl(Composite composite) {
        super(composite, 0);
        this.currentDataColumnCount = this.calculateDataColumnCount(this.getClientArea().width);
        this.tableViewer = this.createTableViewer();
        this.tableViewer.setContentProvider((IContentProvider)new HexEditContentProvider(this.tableViewer));
        this.createColumns(this.currentDataColumnCount);
        this.addControlListener(this.createControlListener());
    }

    private TableViewer createTableViewer() {
        TableViewer tableViewer = new TableViewer(this, 0x10000B00){

            protected void preservingSelection(Runnable runnable) {
                if (HexEditControl.this.enablePreserveSelection) {
                    super.preservingSelection(runnable);
                }
            }
        };
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.setUseHashlookup(true);
        if (this.editable) {
            this.addEditorSupport(tableViewer);
        }
        return tableViewer;
    }

    private void addEditorSupport(TableViewer tableViewer) {
        CellNavigationStrategy cellNavigationStrategy = this.createCellNavigationStrategy(tableViewer);
        TableViewerFocusCellManager tableViewerFocusCellManager = new TableViewerFocusCellManager(tableViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)tableViewer), cellNavigationStrategy);
        ColumnViewerEditorActivationStrategy columnViewerEditorActivationStrategy = this.createEditorActivationStrategy(tableViewer);
        TableViewerEditor.create((TableViewer)tableViewer, (SWTFocusCellManager)tableViewerFocusCellManager, (ColumnViewerEditorActivationStrategy)columnViewerEditorActivationStrategy, (int)58);
        tableViewer.getColumnViewerEditor().addEditorActivationListener(this.createEditorActivationListener(tableViewer));
    }

    private CellNavigationStrategy createCellNavigationStrategy(TableViewer tableViewer) {
        final Table table = tableViewer.getTable();
        return new CellNavigationStrategy(){

            public ViewerCell findSelectedCell(ColumnViewer columnViewer, ViewerCell viewerCell, Event event) {
                ViewerCell viewerCell2 = super.findSelectedCell(columnViewer, viewerCell, event);
                if (viewerCell2 != null) {
                    table.showColumn(table.getColumn(viewerCell2.getColumnIndex()));
                }
                return viewerCell2;
            }
        };
    }

    private ColumnViewerEditorActivationStrategy createEditorActivationStrategy(TableViewer tableViewer) {
        return new ColumnViewerEditorActivationStrategy((ColumnViewer)tableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent columnViewerEditorActivationEvent) {
                return columnViewerEditorActivationEvent.eventType == 5 || columnViewerEditorActivationEvent.eventType == 3 || columnViewerEditorActivationEvent.eventType == 1 && columnViewerEditorActivationEvent.keyCode == 13;
            }
        };
    }

    private ColumnViewerEditorActivationListener createEditorActivationListener(TableViewer tableViewer) {
        final Table table = tableViewer.getTable();
        return new ColumnViewerEditorActivationListener(){

            public void beforeEditorDeactivated(ColumnViewerEditorDeactivationEvent columnViewerEditorDeactivationEvent) {
            }

            public void beforeEditorActivated(ColumnViewerEditorActivationEvent columnViewerEditorActivationEvent) {
                ViewerCell viewerCell = (ViewerCell)columnViewerEditorActivationEvent.getSource();
                table.showColumn(table.getColumn(viewerCell.getColumnIndex()));
            }

            public void afterEditorDeactivated(ColumnViewerEditorDeactivationEvent columnViewerEditorDeactivationEvent) {
            }

            public void afterEditorActivated(ColumnViewerEditorActivationEvent columnViewerEditorActivationEvent) {
            }
        };
    }

    public void setInput(byte[] byArray) {
        this.model = this.currentDataColumnCount == 0 ? new HexEditModel(byArray) : new HexEditModel(byArray, this.currentDataColumnCount);
        this.changeModel(this.model);
    }

    public boolean isContentDirty() {
        if (this.model != null) {
            return this.model.isDirty();
        }
        return false;
    }

    public byte[] getContent() {
        return this.model.getContent();
    }

    private void changeModel(HexEditModel hexEditModel) {
        this.enablePreserveSelection = false;
        this.tableViewer.setInput((Object)hexEditModel);
        this.enablePreserveSelection = true;
    }

    private void createColumns(int n) {
        this.tableViewer.getTable().dispose();
        this.tableViewer = this.createTableViewer();
        this.tableViewer.setContentProvider((IContentProvider)new HexEditContentProvider(this.tableViewer));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        this.createOffsetColumn(tableColumnLayout);
        int n2 = 0;
        while (n2 < n) {
            this.createDataColumn(tableColumnLayout, n2);
            ++n2;
        }
        this.createAsciiColumn(tableColumnLayout);
        this.setLayout((Layout)tableColumnLayout);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new HexEditLabelProvider(this.fonts));
    }

    private void createOffsetColumn(TableColumnLayout tableColumnLayout) {
        TableColumn tableColumn = this.createColumn("Offset", 0x1000000);
        tableColumn.setAlignment(131072);
        tableColumnLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnPixelData(this.fonts.getOffsetColumnWidth(), false, false));
    }

    private void createAsciiColumn(TableColumnLayout tableColumnLayout) {
        TableColumn tableColumn = this.createColumn("", 0x1000000);
        tableColumnLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(100));
    }

    private void createDataColumn(TableColumnLayout tableColumnLayout, int n) {
        HexEditTableEditor hexEditTableEditor = this.editable ? new HexEditTableEditor(this.tableViewer, n) : null;
        TableColumn tableColumn = this.createColumn(String.format("%02X", n), 0x1000000, hexEditTableEditor);
        tableColumnLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnPixelData(this.fonts.getDataColumnWidth(), false, false));
    }

    private TableColumn createColumn(String string, int n) {
        return this.createColumn(string, n, null);
    }

    private TableColumn createColumn(String string, int n, EditingSupport editingSupport) {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, n);
        TableColumn tableColumn = tableViewerColumn.getColumn();
        tableColumn.setMoveable(false);
        tableColumn.setResizable(false);
        tableColumn.setText(string);
        if (editingSupport != null) {
            tableViewerColumn.setEditingSupport(editingSupport);
        }
        return tableColumn;
    }

    private ControlListener createControlListener() {
        return new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                HexEditControl.this.doResize();
            }
        };
    }

    private void doResize() {
        int n = this.getClientArea().width;
        int n2 = this.calculateDataColumnCount(n);
        if (n2 != this.currentDataColumnCount) {
            this.changeModel(null);
            this.createColumns(n2);
            if (this.model != null) {
                HexEditModel hexEditModel = this.model.getModelForRowLength(n2);
                int n3 = this.tableViewer.getTable().getTopIndex();
                int n4 = this.model.getOffsetForLine(n3);
                int n5 = hexEditModel.getLineForOffset(n4);
                this.changeModel(hexEditModel);
                this.model = hexEditModel;
                if (n5 != 0) {
                    this.tableViewer.getTable().setTopIndex(n5);
                }
            } else {
                this.changeModel(this.model);
            }
            this.currentDataColumnCount = n2;
        }
    }

    private int calculateDataColumnCount(int n) {
        int n2;
        int n3 = n - this.fonts.getOffsetColumnWidth() - 30;
        int n4 = n3 / (n2 = 4 * this.fonts.getDataColumnWidth() + this.fonts.getAsciiColumnWordWidth());
        int n5 = n4 * 4;
        return n5 < 4 ? 4 : n5;
    }
}

