/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.html.dom;

import com.subgraph.vega.internal.html.dom.CharacterDataImpl;
import com.subgraph.vega.internal.html.dom.CommentImpl;
import com.subgraph.vega.internal.html.dom.HTMLElementImpl;
import com.subgraph.vega.internal.html.dom.NodeListImpl;
import com.subgraph.vega.internal.html.dom.TextImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public class NodeImpl
implements org.w3c.dom.Node {
    private final Node jsoupNode;
    private Document ownerDocument;
    private List<Integer> treePosition = new ArrayList<Integer>();

    static NodeImpl createFromJsoupNode(Node node, Document document) {
        if (node == null) {
            return null;
        }
        if (node instanceof Element) {
            return HTMLElementImpl.create((Element)node, document);
        }
        if (node instanceof TextNode) {
            return new TextImpl((TextNode)node, document);
        }
        if (node instanceof Comment) {
            return new CommentImpl((Comment)node, document);
        }
        if (node instanceof DataNode) {
            return new CharacterDataImpl((Node)((DataNode)node), ((DataNode)node).getWholeData(), document);
        }
        return new NodeImpl(node, document);
    }

    static DOMException createReadOnlyException() {
        return new DOMException(7, "Modifying the DOM is not permitted");
    }

    static DOMException createNoLevel3SupportException() {
        return new DOMException(9, "This implementation does not support DOM Level 3");
    }

    static DOMException createNoXMLSupportException() {
        return new DOMException(9, "No support for XML feature.");
    }

    NodeImpl(Node node, Document document) {
        this.jsoupNode = node;
        this.ownerDocument = document;
        this.calculateTreePosition();
    }

    void calculateTreePosition() {
        Node node = this.jsoupNode;
        while (node != null) {
            this.treePosition.add(node.siblingIndex());
            node = node.parent();
        }
        Collections.reverse(this.treePosition);
    }

    void setOwnerDocument(Document document) {
        this.ownerDocument = document;
    }

    @Override
    public String getNodeName() {
        return "#node";
    }

    @Override
    public String getNodeValue() {
        return null;
    }

    @Override
    public void setNodeValue(String string) throws DOMException {
        throw NodeImpl.createReadOnlyException();
    }

    @Override
    public short getNodeType() {
        return 0;
    }

    @Override
    public org.w3c.dom.Node getParentNode() {
        if (this.jsoupNode == null) {
            return null;
        }
        return NodeImpl.createFromJsoupNode(this.jsoupNode.parent(), this.ownerDocument);
    }

    @Override
    public NodeList getChildNodes() {
        if (this.jsoupNode == null || this.jsoupNode.childNodes().size() == 0) {
            return NodeListImpl.emptyList;
        }
        ArrayList<NodeImpl> arrayList = new ArrayList<NodeImpl>();
        for (Node node : this.jsoupNode.childNodes()) {
            arrayList.add(NodeImpl.createFromJsoupNode(node, this.ownerDocument));
        }
        return new NodeListImpl(arrayList);
    }

    @Override
    public org.w3c.dom.Node getFirstChild() {
        NodeList nodeList = this.getChildNodes();
        if (nodeList.getLength() == 0) {
            return null;
        }
        return nodeList.item(0);
    }

    @Override
    public org.w3c.dom.Node getLastChild() {
        NodeList nodeList = this.getChildNodes();
        if (nodeList.getLength() == 0) {
            return null;
        }
        return nodeList.item(nodeList.getLength() - 1);
    }

    @Override
    public org.w3c.dom.Node getPreviousSibling() {
        if (this.jsoupNode == null) {
            return null;
        }
        return NodeImpl.createFromJsoupNode(this.jsoupNode.previousSibling(), this.ownerDocument);
    }

    @Override
    public org.w3c.dom.Node getNextSibling() {
        if (this.jsoupNode == null) {
            return null;
        }
        return NodeImpl.createFromJsoupNode(this.jsoupNode.nextSibling(), this.ownerDocument);
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    @Override
    public org.w3c.dom.Node insertBefore(org.w3c.dom.Node node, org.w3c.dom.Node node2) throws DOMException {
        throw NodeImpl.createNoLevel3SupportException();
    }

    @Override
    public org.w3c.dom.Node replaceChild(org.w3c.dom.Node node, org.w3c.dom.Node node2) throws DOMException {
        throw NodeImpl.createNoLevel3SupportException();
    }

    @Override
    public org.w3c.dom.Node removeChild(org.w3c.dom.Node node) throws DOMException {
        throw NodeImpl.createNoLevel3SupportException();
    }

    @Override
    public org.w3c.dom.Node appendChild(org.w3c.dom.Node node) throws DOMException {
        throw NodeImpl.createNoLevel3SupportException();
    }

    @Override
    public boolean hasChildNodes() {
        return this.getChildNodes().getLength() > 0;
    }

    @Override
    public org.w3c.dom.Node cloneNode(boolean bl) {
        throw NodeImpl.createReadOnlyException();
    }

    @Override
    public void normalize() {
        throw NodeImpl.createNoLevel3SupportException();
    }

    @Override
    public boolean isSupported(String string, String string2) {
        return false;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public void setPrefix(String string) throws DOMException {
        throw NodeImpl.createReadOnlyException();
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public String getBaseURI() {
        throw NodeImpl.createNoLevel3SupportException();
    }

    List<Integer> getTreePosition() {
        return this.treePosition;
    }

    @Override
    public short compareDocumentPosition(org.w3c.dom.Node node) throws DOMException {
        if (!(node instanceof NodeImpl)) {
            return 1;
        }
        List<Integer> list = ((NodeImpl)node).getTreePosition();
        if (list.isEmpty() || this.getTreePosition().isEmpty()) {
            return 1;
        }
        int n = 0;
        while (n != list.size() || n != this.treePosition.size()) {
            if (n == list.size()) {
                return 10;
            }
            if (n == this.treePosition.size()) {
                return 20;
            }
            if (list.get(n) < this.treePosition.get(n)) {
                return 2;
            }
            if (list.get(n) > this.treePosition.get(n)) {
                return 4;
            }
            ++n;
        }
        return 0;
    }

    void printTree() {
        System.out.print(String.valueOf(this.getNodeName()) + ": [");
        int n = 0;
        while (n < this.treePosition.size()) {
            if (n > 0) {
                System.out.print(", ");
            }
            System.out.print(this.treePosition.get(n));
            ++n;
        }
        System.out.println("]");
    }

    @Override
    public String getTextContent() throws DOMException {
        return null;
    }

    @Override
    public void setTextContent(String string) throws DOMException {
        throw NodeImpl.createNoLevel3SupportException();
    }

    @Override
    public boolean isSameNode(org.w3c.dom.Node node) {
        throw NodeImpl.createNoLevel3SupportException();
    }

    @Override
    public String lookupPrefix(String string) {
        throw NodeImpl.createNoLevel3SupportException();
    }

    @Override
    public boolean isDefaultNamespace(String string) {
        throw NodeImpl.createNoLevel3SupportException();
    }

    @Override
    public String lookupNamespaceURI(String string) {
        throw NodeImpl.createNoLevel3SupportException();
    }

    @Override
    public boolean isEqualNode(org.w3c.dom.Node node) {
        throw NodeImpl.createNoLevel3SupportException();
    }

    @Override
    public Object getFeature(String string, String string2) {
        throw NodeImpl.createNoLevel3SupportException();
    }

    @Override
    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        throw NodeImpl.createNoLevel3SupportException();
    }

    @Override
    public Object getUserData(String string) {
        throw NodeImpl.createNoLevel3SupportException();
    }

    public boolean equals(Object object) {
        if (!(object instanceof NodeImpl)) {
            return false;
        }
        NodeImpl nodeImpl = (NodeImpl)object;
        return this.jsoupNode.equals((Object)nodeImpl.jsoupNode);
    }

    public int hashCode() {
        return this.jsoupNode.hashCode();
    }
}

