/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.html.dom;

import com.subgraph.vega.internal.html.dom.DocumentImpl;
import com.subgraph.vega.internal.html.dom.HTMLCollectionImpl;
import com.subgraph.vega.internal.html.dom.HTMLElementImpl;
import com.subgraph.vega.internal.html.dom.HTMLLinkElementImpl;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.w3c.dom.DOMException;
import org.w3c.dom.NodeList;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLDocument;
import org.w3c.dom.html2.HTMLElement;

public class HTMLDocumentImpl
extends DocumentImpl
implements HTMLDocument {
    public static HTMLDocumentImpl createFromJsoup(Document document) {
        HTMLDocumentImpl hTMLDocumentImpl = new HTMLDocumentImpl(document);
        hTMLDocumentImpl.setOwnerDocument(hTMLDocumentImpl);
        return hTMLDocumentImpl;
    }

    HTMLDocumentImpl(Document document) {
        super(document);
    }

    @Override
    public String getTitle() {
        Elements elements = this.jsoupDocument.getElementsByTag("title");
        Element element = elements.first();
        if (element == null) {
            return null;
        }
        return element.text();
    }

    @Override
    public void setTitle(String string) {
    }

    @Override
    public String getReferrer() {
        return null;
    }

    @Override
    public String getDomain() {
        return null;
    }

    @Override
    public String getURL() {
        return null;
    }

    @Override
    public HTMLElement getBody() {
        Elements elements = this.jsoupDocument.getElementsByTag("body");
        Element element = elements.first();
        if (element == null) {
            return null;
        }
        return new HTMLElementImpl(element, (org.w3c.dom.Document)this);
    }

    @Override
    public void setBody(HTMLElement hTMLElement) {
    }

    @Override
    public HTMLCollection getImages() {
        return this.selectCollection("img");
    }

    @Override
    public HTMLCollection getApplets() {
        return this.selectCollection("applet, object[classid]");
    }

    @Override
    public HTMLCollection getLinks() {
        ArrayList<HTMLElementImpl> arrayList = new ArrayList<HTMLElementImpl>();
        for (Element element : this.jsoupDocument.select("a[href], area[href]")) {
            arrayList.add(new HTMLLinkElementImpl(element, this.getOwnerDocument()));
        }
        return new HTMLCollectionImpl(arrayList);
    }

    @Override
    public HTMLCollection getForms() {
        return this.selectCollection("form");
    }

    @Override
    public HTMLCollection getAnchors() {
        return this.selectCollection("a[name]");
    }

    @Override
    public String getCookie() {
        return "";
    }

    @Override
    public void setCookie(String string) throws DOMException {
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public void write(String string) {
    }

    @Override
    public void writeln(String string) {
    }

    @Override
    public NodeList getElementsByName(String string) {
        return this.selectCollection("*[name=" + string + "]").toNodeList();
    }

    private HTMLCollectionImpl selectCollection(String string) {
        return new HTMLCollectionImpl((List<Element>)this.jsoupDocument.select(string), this);
    }
}

