/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.html.dom;

import com.subgraph.vega.internal.html.dom.AttrImpl;
import com.subgraph.vega.internal.html.dom.HTMLElementImpl;
import com.subgraph.vega.internal.html.dom.NamedNodeMapImpl;
import com.subgraph.vega.internal.html.dom.NodeImpl;
import com.subgraph.vega.internal.html.dom.NodeListImpl;
import java.util.ArrayList;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.FormElement;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class ElementImpl
extends NodeImpl
implements Element {
    protected final org.jsoup.nodes.Element jsoupElement;

    protected ElementImpl(org.jsoup.nodes.Element element, Document document) {
        super((Node)element, document);
        this.jsoupElement = element;
    }

    @Override
    public String getNodeName() {
        return this.getTagName();
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    org.jsoup.nodes.Element getJsoupElement() {
        return this.jsoupElement;
    }

    @Override
    public String getTagName() {
        return this.jsoupElement.tagName().toUpperCase();
    }

    @Override
    public String getTextContent() {
        short s = this.getNodeType();
        switch (s) {
            case 3: 
            case 4: 
            case 8: {
                return this.getNodeValue();
            }
        }
        return this.concatenateChildTextContent();
    }

    private String concatenateChildTextContent() {
        StringBuilder stringBuilder = new StringBuilder();
        NodeList nodeList = this.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            String string;
            org.w3c.dom.Node node = nodeList.item(n);
            if (node.getNodeType() != 8 && node.getNodeType() != 7 && (string = node.getTextContent()) != null) {
                stringBuilder.append(string);
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    Element getElementById(String string) {
        org.jsoup.nodes.Element element = this.jsoupElement.getElementById(string);
        if (element == null) {
            return null;
        }
        return HTMLElementImpl.create(element, this.getOwnerDocument());
    }

    @Override
    public NamedNodeMap getAttributes() {
        NamedNodeMapImpl namedNodeMapImpl = new NamedNodeMapImpl();
        for (Attribute attribute : this.jsoupElement.attributes()) {
            namedNodeMapImpl.addNode(attribute.getKey(), new AttrImpl(attribute.getKey(), attribute.getValue(), this, this.getOwnerDocument()));
        }
        return namedNodeMapImpl;
    }

    @Override
    public boolean hasAttributes() {
        return this.jsoupElement.attributes().size() > 0;
    }

    @Override
    public String getAttribute(String string) {
        if (this.jsoupElement.hasAttr(string)) {
            return this.jsoupElement.attr(string);
        }
        if (this.getTagName().equals("LABEL") && string.equals("htmlFor") && this.jsoupElement.hasAttr("for")) {
            return this.jsoupElement.attr("for");
        }
        if (string.equals("className") && this.jsoupElement.hasAttr("class")) {
            return this.jsoupElement.attr("class");
        }
        return null;
    }

    @Override
    public void setAttribute(String string, String string2) throws DOMException {
        throw ElementImpl.createReadOnlyException();
    }

    @Override
    public void removeAttribute(String string) throws DOMException {
        throw ElementImpl.createReadOnlyException();
    }

    @Override
    public Attr getAttributeNode(String string) {
        if (this.jsoupElement.hasAttr(string)) {
            return new AttrImpl(string, this.getAttribute(string), this, this.getOwnerDocument());
        }
        return null;
    }

    @Override
    public Attr setAttributeNode(Attr attr) throws DOMException {
        throw ElementImpl.createReadOnlyException();
    }

    @Override
    public Attr removeAttributeNode(Attr attr) throws DOMException {
        throw ElementImpl.createReadOnlyException();
    }

    @Override
    public NodeList getElementsByTagName(String string) {
        ArrayList<NodeImpl> arrayList = new ArrayList<NodeImpl>();
        if (this.getTagName().equals("HTML") && string.equalsIgnoreCase("html")) {
            arrayList.add(this);
            return new NodeListImpl(arrayList);
        }
        if (this.getTagName().equals("FORM") && "*".equals(string)) {
            Elements elements = ((FormElement)this.jsoupElement).elements();
            for (org.jsoup.nodes.Element element : elements) {
                arrayList.add(HTMLElementImpl.create(element, this.getOwnerDocument()));
            }
            return new NodeListImpl(arrayList);
        }
        for (org.jsoup.nodes.Element element : this.jsoupElementsForTag(string)) {
            if (element == this.jsoupElement) continue;
            arrayList.add(HTMLElementImpl.create(element, this.getOwnerDocument()));
        }
        return new NodeListImpl(arrayList);
    }

    private Elements jsoupElementsForTag(String string) {
        if ("*".equals(string)) {
            return this.jsoupElement.getAllElements();
        }
        return this.jsoupElement.getElementsByTag(string);
    }

    @Override
    public String getAttributeNS(String string, String string2) throws DOMException {
        throw ElementImpl.createNoXMLSupportException();
    }

    @Override
    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        throw ElementImpl.createNoXMLSupportException();
    }

    @Override
    public void removeAttributeNS(String string, String string2) throws DOMException {
        throw ElementImpl.createNoXMLSupportException();
    }

    @Override
    public Attr getAttributeNodeNS(String string, String string2) throws DOMException {
        throw ElementImpl.createNoXMLSupportException();
    }

    @Override
    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        throw ElementImpl.createNoXMLSupportException();
    }

    @Override
    public NodeList getElementsByTagNameNS(String string, String string2) throws DOMException {
        throw ElementImpl.createNoXMLSupportException();
    }

    @Override
    public boolean hasAttribute(String string) {
        return this.jsoupElement.hasAttr(string);
    }

    @Override
    public boolean hasAttributeNS(String string, String string2) throws DOMException {
        throw ElementImpl.createNoXMLSupportException();
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw ElementImpl.createNoLevel3SupportException();
    }

    @Override
    public void setIdAttribute(String string, boolean bl) throws DOMException {
        throw ElementImpl.createNoLevel3SupportException();
    }

    @Override
    public void setIdAttributeNS(String string, String string2, boolean bl) throws DOMException {
        throw ElementImpl.createNoLevel3SupportException();
    }

    @Override
    public void setIdAttributeNode(Attr attr, boolean bl) throws DOMException {
        throw ElementImpl.createNoLevel3SupportException();
    }
}

