/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.api.util;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.utils.URIUtils;

public class VegaURI {
    private final HttpHost targetHost;
    private final String path;
    private final String query;

    public static VegaURI fromHostAndRequest(HttpHost httpHost, HttpRequest httpRequest) {
        String string = httpRequest.getRequestLine().getUri();
        return new VegaURI(httpHost, VegaURI.lineToPath(string), VegaURI.lineToQuery(string));
    }

    private static String lineToPath(String string) {
        int n = string.indexOf(63);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    private static String lineToQuery(String string) {
        int n = string.indexOf(63);
        if (n == -1) {
            return null;
        }
        return string.substring(n + 1);
    }

    public VegaURI(HttpHost httpHost, String string, String string2) {
        this.targetHost = httpHost;
        this.path = string;
        this.query = string2;
    }

    public HttpHost getTargetHost() {
        return this.targetHost;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public URI toURI() {
        try {
            URI uRI = new URI(null, null, null, -1, this.path, this.query, null);
            return URIUtils.rewriteURI((URI)uRI, (HttpHost)this.targetHost);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException("Failed to convert VegaURI to URI: " + this.toString(), uRISyntaxException);
        }
    }

    public VegaURI resolve(String string) {
        String string2 = VegaURI.lineToPath(string);
        String string3 = VegaURI.lineToQuery(string);
        if (string2.startsWith("/")) {
            return new VegaURI(this.targetHost, string2, string3);
        }
        return new VegaURI(this.targetHost, VegaURI.resolvePath(this.path, string2, true), string3);
    }

    private static String resolvePath(String string, String string2, boolean bl) {
        CharSequence charSequence;
        int n = string.lastIndexOf(47);
        int n2 = string2.length();
        String string3 = "";
        if (n2 == 0) {
            if (n >= 0) {
                string3 = string.substring(0, n + 1);
            }
        } else {
            charSequence = new StringBuffer(string.length() + n2);
            if (n >= 0) {
                ((StringBuffer)charSequence).append(string.substring(0, n + 1));
            }
            ((StringBuffer)charSequence).append(string2);
            string3 = ((StringBuffer)charSequence).toString();
        }
        charSequence = VegaURI.normalize(string3);
        return charSequence;
    }

    private static String normalize(String string) {
        int n = VegaURI.needsNormalization(string);
        if (n < 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int[] nArray = new int[n];
        VegaURI.split(cArray, nArray);
        VegaURI.removeDots(cArray, nArray);
        VegaURI.maybeAddLeadingDot(cArray, nArray);
        String string2 = new String(cArray, 0, VegaURI.join(cArray, nArray));
        if (string2.equals(string)) {
            return string;
        }
        return string2;
    }

    /*
     * Unable to fully structure code
     */
    private static int needsNormalization(String var0) {
        var1_1 = true;
        var2_2 = 0;
        var3_3 = var0.length() - 1;
        var4_4 = 0;
        while (var4_4 <= var3_3) {
            if (var0.charAt(var4_4) != '/') break;
            ++var4_4;
        }
        if (var4_4 > 1) {
            var1_1 = false;
        }
        block1: while (var4_4 <= var3_3) {
            if (var0.charAt(var4_4) == '.' && (var4_4 == var3_3 || var0.charAt(var4_4 + 1) == '/' || var0.charAt(var4_4 + 1) == '.' && (var4_4 + 1 == var3_3 || var0.charAt(var4_4 + 2) == '/'))) {
                var1_1 = false;
            }
            ++var2_2;
            while (var4_4 <= var3_3) {
                if (var0.charAt(var4_4++) == '/') ** GOTO lbl21
                continue;
                while (var0.charAt(var4_4) == '/') {
                    var1_1 = false;
                    ++var4_4;
lbl21:
                    // 2 sources

                    if (var4_4 <= var3_3) continue;
                    continue block1;
                }
                continue block1;
            }
        }
        return var1_1 != false ? -1 : var2_2;
    }

    private static void split(char[] cArray, int[] nArray) {
        int n = cArray.length - 1;
        int n2 = 0;
        int n3 = 0;
        while (n2 <= n) {
            if (cArray[n2] != '/') break;
            cArray[n2] = '\u0000';
            ++n2;
        }
        block1: while (n2 <= n) {
            nArray[n3++] = n2++;
            while (n2 <= n) {
                if (cArray[n2++] != '/') continue;
                cArray[n2 - 1] = '\u0000';
                while (n2 <= n) {
                    if (cArray[n2] != '/') continue block1;
                    cArray[n2++] = '\u0000';
                }
                continue block1;
            }
        }
        if (n3 != nArray.length) {
            throw new InternalError();
        }
    }

    private static int join(char[] cArray, int[] nArray) {
        int n = nArray.length;
        int n2 = cArray.length - 1;
        int n3 = 0;
        if (cArray[n3] == '\u0000') {
            cArray[n3++] = 47;
        }
        int n4 = 0;
        while (n4 < n) {
            int n5 = nArray[n4];
            if (n5 != -1) {
                if (n3 == n5) {
                    while (n3 <= n2 && cArray[n3] != '\u0000') {
                        ++n3;
                    }
                    if (n3 <= n2) {
                        cArray[n3++] = 47;
                    }
                } else if (n3 < n5) {
                    while (n5 <= n2 && cArray[n5] != '\u0000') {
                        cArray[n3++] = cArray[n5++];
                    }
                    if (n5 <= n2) {
                        cArray[n3++] = 47;
                    }
                } else {
                    throw new InternalError();
                }
            }
            ++n4;
        }
        return n3;
    }

    private static void removeDots(char[] cArray, int[] nArray) {
        int n = nArray.length;
        int n2 = cArray.length - 1;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int n5 = 0;
            do {
                if (cArray[n4 = nArray[n3]] != '.') continue;
                if (n4 == n2) {
                    n5 = 1;
                    break;
                }
                if (cArray[n4 + 1] == '\u0000') {
                    n5 = 1;
                    break;
                }
                if (cArray[n4 + 1] != '.' || n4 + 1 != n2 && cArray[n4 + 2] != '\u0000') continue;
                n5 = 2;
                break;
            } while (++n3 < n);
            if (n3 > n || n5 == 0) break;
            if (n5 == 1) {
                nArray[n3] = -1;
            } else {
                int n6;
                n4 = n3 - 1;
                while (n4 >= 0) {
                    if (nArray[n4] != -1) break;
                    --n4;
                }
                if (n4 >= 0 && (cArray[n6 = nArray[n4]] != '.' || cArray[n6 + 1] != '.' || cArray[n6 + 2] != '\u0000')) {
                    nArray[n3] = -1;
                    nArray[n4] = -1;
                }
            }
            ++n3;
        }
    }

    private static void maybeAddLeadingDot(char[] cArray, int[] nArray) {
        if (cArray[0] == '\u0000') {
            return;
        }
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] >= 0) break;
            ++n2;
        }
        if (n2 >= n || n2 == 0) {
            return;
        }
        int n3 = nArray[n2];
        while (n3 < cArray.length && cArray[n3] != ':' && cArray[n3] != '\u0000') {
            ++n3;
        }
        if (n3 >= cArray.length || cArray[n3] == '\u0000') {
            return;
        }
        cArray[0] = 46;
        cArray[1] = '\u0000';
        nArray[0] = 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.targetHost.toURI());
        if (!this.path.startsWith("/")) {
            stringBuilder.append("/");
        }
        stringBuilder.append(this.path);
        if (this.query != null) {
            stringBuilder.append("?");
            stringBuilder.append(this.query);
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.path == null ? 0 : this.path.hashCode());
        n = 31 * n + (this.query == null ? 0 : this.query.hashCode());
        n = 31 * n + (this.targetHost == null ? 0 : this.targetHost.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        VegaURI vegaURI = (VegaURI)object;
        if (this.path == null ? vegaURI.path != null : !this.path.equals(vegaURI.path)) {
            return false;
        }
        if (this.query == null ? vegaURI.query != null : !this.query.equals(vegaURI.query)) {
            return false;
        }
        return !(this.targetHost == null ? vegaURI.targetHost != null : !this.targetHost.equals((Object)vegaURI.targetHost));
    }
}

