/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor.parser;

import com.subgraph.vega.api.http.requests.IHttpMessageBuilder;
import org.apache.http.Header;
import org.apache.http.ParseException;
import org.apache.http.message.LineParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.CharArrayBuffer;

public abstract class ParserBase {
    protected void stripLeadingWhitspace(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        int n;
        int n2 = parserCursor.getUpperBound();
        int n3 = n = parserCursor.getPos();
        while (n < n2) {
            char c = charArrayBuffer.charAt(n);
            if (c == '\r') {
                if (n2 + 1 >= n || charArrayBuffer.charAt(n) != '\n') break;
                n3 = n += 2;
                continue;
            }
            if (c == '\n') {
                n3 = ++n;
                continue;
            }
            if (c != ' ' && c != '\t') break;
            ++n;
        }
        parserCursor.updatePos(n3);
    }

    protected int readLine(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor, CharArrayBuffer charArrayBuffer2) {
        int n;
        if (parserCursor.atEnd()) {
            return -1;
        }
        int n2 = parserCursor.getPos();
        int n3 = charArrayBuffer.indexOf(10, n2, parserCursor.getUpperBound());
        if (n3 >= 0) {
            n = n3 != 0 && charArrayBuffer.charAt(n3 - 1) == '\r' ? n3 - 1 : n3;
        } else {
            n = parserCursor.getUpperBound();
            n3 = n - 1;
        }
        charArrayBuffer2.append(charArrayBuffer, n2, n - n2);
        parserCursor.updatePos(n3 + 1);
        return n - n2;
    }

    protected int readLineHeader(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor, CharArrayBuffer charArrayBuffer2) {
        if (parserCursor.atEnd()) {
            return -1;
        }
        int n = parserCursor.getPos();
        int n2 = 0;
        do {
            int n3;
            int n4;
            if ((n4 = charArrayBuffer.indexOf(10, n, parserCursor.getUpperBound())) > 0) {
                n3 = n4 != parserCursor.getPos() && charArrayBuffer.charAt(n4 - 1) == '\r' ? n4 - 1 : n4;
            } else {
                n3 = parserCursor.getUpperBound();
                n4 = n3 - 1;
            }
            if (n2 != 0) {
                while (n < n3 && (charArrayBuffer.charAt(n) == '\t' || charArrayBuffer.charAt(n) == ' ')) {
                    ++n;
                }
                if (n != n3) {
                    charArrayBuffer2.append(' ');
                }
            }
            charArrayBuffer2.append(charArrayBuffer, n, n3 - n);
            n2 += n3 - n;
            n = n4 + 1;
            parserCursor.updatePos(n);
        } while (n < parserCursor.getUpperBound() && (charArrayBuffer.charAt(n) == '\t' || charArrayBuffer.charAt(n) == ' '));
        return n2;
    }

    protected String nextWord(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        this.skipSpHt(charArrayBuffer, parserCursor);
        int n = parserCursor.getPos();
        int n2 = charArrayBuffer.indexOf(32, n, parserCursor.getUpperBound());
        if (n2 < 0) {
            if (n == parserCursor.getUpperBound()) {
                return null;
            }
            n2 = parserCursor.getUpperBound();
        }
        parserCursor.updatePos(n2);
        return charArrayBuffer.substringTrimmed(n, n2);
    }

    protected void skipSpHt(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        int n = parserCursor.getUpperBound();
        int n2 = parserCursor.getPos();
        while (n2 < n && (charArrayBuffer.charAt(n2) == ' ' || charArrayBuffer.charAt(n2) == '\t')) {
            ++n2;
        }
        parserCursor.updatePos(n2);
    }

    protected void parseHeaders(LineParser lineParser, IHttpMessageBuilder iHttpMessageBuilder, CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        CharArrayBuffer charArrayBuffer2 = new CharArrayBuffer(0);
        while (true) {
            charArrayBuffer2.clear();
            int n = parserCursor.getPos();
            if (this.readLineHeader(charArrayBuffer, parserCursor, charArrayBuffer2) <= 0) break;
            try {
                Header header = lineParser.parseHeader(charArrayBuffer2);
                iHttpMessageBuilder.addHeader(header.getName(), header.getValue());
            }
            catch (ParseException parseException) {
                parserCursor.updatePos(n);
                return;
            }
        }
    }
}

