/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor.js.formatter;

import com.subgraph.vega.ui.httpeditor.js.formatter.FormatterState;
import com.subgraph.vega.ui.httpeditor.js.formatter.JavascriptFormatterConfig;
import java.util.ArrayList;
import java.util.List;

public class JavascriptFormatter {
    private static final String[] PUNCTUATION = new String[]{"++", "--", "+=", "-=", "*=", "/=", "%=", "===", "==", "!==", "!=", ">>>=", ">>>", ">>=", "<<=", ">=", "<=", ">>", "<<", ">", "<", "&&", "&=", "||", "!=", "|", "!!", "!", ",", "::", "^=", "^", ":", "=", "+", "-", "*", "/", "%", "&"};
    private static final String[] LINE_STARTERS = new String[]{"continue", "try", "throw", "return", "var", "if", "switch", "case", "default", "for", "while", "break", "function"};
    private static final int PREFIX_NONE = 0;
    private static final int PREFIX_NEWLINE = 1;
    private static final int PREFIX_SPACE = 2;
    private static final int CHAR_EOF = -1;
    private StringBuilder output;
    private String lastWord = "";
    private String secondLastText = "";
    private String lastText = "";
    private TokenType lastTokenType = TokenType.TK_START_EXPR;
    private String input;
    private int pos;
    private int newlineCount = 0;
    private boolean wantedNewline;
    private boolean justAddedNewline;
    private boolean doBlockJustClosed;
    private String indentString;
    private FormatterState state = new FormatterState(FormatterState.Mode.BLOCK);
    private List<FormatterState> stateStack = new ArrayList<FormatterState>();
    private JavascriptFormatterConfig config = new JavascriptFormatterConfig();

    public String format(String string) {
        this.output = new StringBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.config.indentCount) {
            stringBuilder.append(' ');
            ++n;
        }
        this.indentString = stringBuilder.toString();
        this.reset(string);
        Token token = this.nextToken();
        while (token.type != TokenType.TK_EOF) {
            switch (token.type) {
                case TK_START_EXPR: {
                    this.handleStartExpr(token.text);
                    break;
                }
                case TK_END_EXPR: {
                    this.handleEndExpr(token.text);
                    break;
                }
                case TK_START_BLOCK: {
                    this.handleStartBlock(token.text);
                    break;
                }
                case TK_END_BLOCK: {
                    this.handleEndBlock(token.text);
                    break;
                }
                case TK_WORD: {
                    this.handleWord(token.text);
                    break;
                }
                case TK_SEMICOLON: {
                    this.handleSemicolon(token.text);
                    break;
                }
                case TK_STRING: {
                    this.handleString(token.text);
                    break;
                }
                case TK_EQUALS: {
                    this.handleEquals(token.text);
                    break;
                }
                case TK_OPERATOR: {
                    this.handleOperator(token.text);
                    break;
                }
                case TK_BLOCK_COMMENT: {
                    this.handleBlockComment(token.text);
                    break;
                }
                case TK_INLINE_COMMENT: {
                    this.handleInlineComment(token.text);
                    break;
                }
                case TK_COMMENT: {
                    this.handleComment(token.text);
                    break;
                }
                case TK_UNKNOWN: {
                    this.handleUnknown(token.text);
                    break;
                }
                case TK_EOF: {
                    break;
                }
            }
            this.pushToken(token);
            token = this.nextToken();
        }
        return this.output.toString();
    }

    private void pushToken(Token token) {
        this.secondLastText = this.lastText;
        this.lastText = token.text;
        this.lastTokenType = token.type;
    }

    private void reset(String string) {
        this.pos = 0;
        this.input = string;
    }

    /*
     * Unable to fully structure code
     */
    private Token nextToken() {
        block59: {
            block60: {
                block58: {
                    this.newlineCount = 0;
                    if (this.pos >= this.input.length()) {
                        return new Token(TokenType.TK_EOF, "");
                    }
                    this.wantedNewline = false;
                    var1_1 = this.input.charAt(this.pos);
                    ++this.pos;
                    v0 = var2_2 = this.config.keepArrayIndentation != false && this.state.mode.isArray != false;
                    if (!var2_2) ** GOTO lbl51
                    var3_3 = 0;
                    while (Character.isWhitespace(var1_1)) {
                        if (var1_1 == 10) {
                            this.trimOutput();
                            this.output.append("\n");
                            this.justAddedNewline = true;
                            var3_3 = 0;
                        } else if (var1_1 == 9) {
                            var3_3 += 4;
                        } else if (var1_1 != 13) {
                            ++var3_3;
                        }
                        if (this.pos >= this.input.length()) {
                            return new Token(TokenType.TK_EOF, "");
                        }
                        var1_1 = this.input.charAt(this.pos);
                        ++this.pos;
                    }
                    if (this.state.indentationBaseline == -1) {
                        this.state.indentationBaseline = var3_3;
                    }
                    if (!this.justAddedNewline) break block58;
                    var4_7 = 0;
                    while (var4_7 < this.state.indentationLevel + 1) {
                        this.output.append(this.indentString);
                        ++var4_7;
                    }
                    if (this.state.indentationBaseline == -1) break block58;
                    var4_7 = 0;
                    while (var4_7 < var3_3 - this.state.indentationBaseline) {
                        this.output.append(' ');
                        ++var4_7;
                    }
                    break block58;
lbl-1000:
                    // 1 sources

                    {
                        if (var1_1 == 10 && (this.config.maxPreserveNewline == 0 || this.config.maxPreserveNewline > this.newlineCount)) {
                            ++this.newlineCount;
                        }
                        if (this.pos >= this.input.length()) {
                            return new Token(TokenType.TK_EOF, "");
                        }
                        var1_1 = this.input.charAt(this.pos);
                        ++this.pos;
lbl51:
                        // 2 sources

                        ** while (Character.isWhitespace((int)var1_1))
                    }
lbl52:
                    // 1 sources

                    if (this.config.preserveNewlines && this.newlineCount > 1) {
                        var3_3 = 0;
                        while (var3_3 < this.newlineCount) {
                            this.printNewline(var3_3 == 0);
                            this.justAddedNewline = true;
                            ++var3_3;
                        }
                    }
                    v1 = this.wantedNewline = this.newlineCount > 0;
                }
                if (Character.isJavaIdentifierStart(var1_1)) {
                    var3_4 = new StringBuilder();
                    var3_4.append((char)var1_1);
                    if (this.pos < this.input.length()) {
                        while (Character.isJavaIdentifierPart(this.input.charAt(this.pos))) {
                            var3_4.append(this.input.charAt(this.pos));
                            ++this.pos;
                            if (this.pos == this.input.length()) break;
                        }
                    }
                    if (!this.atEnd() && var3_4.toString().matches("^[0-9]+[Ee]$") && (this.peek() == 45 || this.peek() == 43)) {
                        var4_7 = this.next();
                        var5_11 = this.nextToken();
                        var3_4.append((char)var4_7);
                        var3_4.append(var5_11.text);
                        return new Token(TokenType.TK_WORD, var3_4.toString());
                    }
                    if (var3_4.toString().equals("in")) {
                        return new Token(TokenType.TK_WORD, var3_4.toString());
                    }
                    if (this.wantedNewline && this.notLastToken(new TokenType[]{TokenType.TK_OPERATOR, TokenType.TK_EQUALS}) && !this.state.ifLine && (this.config.preserveNewlines || !"var".equals(this.lastText))) {
                        this.printNewline();
                    }
                    return new Token(TokenType.TK_WORD, var3_4.toString());
                }
                switch (var1_1) {
                    case 40: 
                    case 91: {
                        return new Token(TokenType.TK_START_EXPR, var1_1);
                    }
                    case 41: 
                    case 93: {
                        return new Token(TokenType.TK_END_EXPR, var1_1);
                    }
                    case 123: {
                        return new Token(TokenType.TK_START_BLOCK, var1_1);
                    }
                    case 125: {
                        return new Token(TokenType.TK_END_BLOCK, var1_1);
                    }
                    case 59: {
                        return new Token(TokenType.TK_SEMICOLON, var1_1);
                    }
                    case 47: {
                        var3_5 = this.maybeCommentToken();
                        if (var3_5 == null) break;
                        return var3_5;
                    }
                }
                v2 = var3_6 = var1_1 == 47 && (this.lastTokenType == TokenType.TK_WORD && ("return".equals(this.lastText) != false || "do".equals(this.lastText) != false) || this.lastTokenType == TokenType.TK_COMMENT || this.lastTokenType == TokenType.TK_START_EXPR || this.lastTokenType == TokenType.TK_START_BLOCK || this.lastTokenType == TokenType.TK_END_BLOCK || this.lastTokenType == TokenType.TK_OPERATOR || this.lastTokenType == TokenType.TK_EQUALS || this.lastTokenType == TokenType.TK_EOF || this.lastTokenType == TokenType.TK_SEMICOLON);
                if (var1_1 != 34 && var1_1 != 39 && !var3_6) break block59;
                var4_7 = var1_1;
                var5_12 = false;
                var6_14 = new StringBuilder();
                var6_14.append((char)var1_1);
                if (this.pos >= this.input.length()) break block60;
                if (var4_7 != 47) ** GOTO lbl132
                var7_16 = false;
                while (var5_12 || var7_16 || this.input.charAt(this.pos) != var4_7) {
                    var6_14.append(this.input.charAt(this.pos));
                    if (!var5_12) {
                        v3 = var5_12 = this.input.charAt(this.pos) == '\\';
                        if (this.input.charAt(this.pos) == '[') {
                            var7_16 = true;
                        } else if (this.input.charAt(this.pos) == ']') {
                            var7_16 = false;
                        }
                    } else {
                        var5_12 = false;
                    }
                    ++this.pos;
                    if (this.pos < this.input.length()) continue;
                    return new Token(TokenType.TK_STRING, var6_14.toString());
                }
                break block60;
lbl-1000:
                // 1 sources

                {
                    var6_14.append(this.input.charAt(this.pos));
                    var5_12 = var5_12 == false ? this.input.charAt(this.pos) == '\\' : false;
                    ++this.pos;
                    if (this.pos < this.input.length()) continue;
                    return new Token(TokenType.TK_STRING, var6_14.toString());
lbl132:
                    // 2 sources

                    ** while (var5_12 || this.input.charAt((int)this.pos) != var4_7)
                }
            }
            ++this.pos;
            var6_14.append((char)var4_7);
            if (var4_7 == 47) {
                while (this.pos < this.input.length() && Character.isJavaIdentifierPart(this.input.charAt(this.pos))) {
                    var6_14.append(this.input.charAt(this.pos));
                    ++this.pos;
                }
            }
            return new Token(TokenType.TK_STRING, var6_14.toString());
        }
        if (var1_1 == 35) {
            if (this.output.length() == 0 && this.peek() == 33) {
                var4_8 = new StringBuilder();
                var4_8.append((char)var1_1);
                while (!this.atEnd() && var1_1 != 10) {
                    var1_1 = this.next();
                    var4_8.append((char)var1_1);
                }
                this.output.append(var4_8.toString().trim());
                this.output.append('\n');
                this.printNewline();
                return this.nextToken();
            }
            if (!this.atEnd() && Character.isDigit(this.peek())) {
                var4_9 = new StringBuilder();
                var4_9.append('#');
                do {
                    var1_1 = this.next();
                    var4_9.append((char)var1_1);
                } while (this.pos < this.input.length() && var1_1 != 35 && var1_1 != 61);
                if (var1_1 != 35) {
                    if (this.peek() == 91 && this.input.charAt(this.pos + 1) == ']') {
                        var4_9.append("[]");
                        this.pos += 2;
                    } else if (this.peek() == 123 && this.input.charAt(this.pos + 1) == '}') {
                        var4_9.append("{}");
                        this.pos += 2;
                    }
                }
                return new Token(TokenType.TK_WORD, var4_9.toString());
            }
        }
        if (var1_1 == 60 && this.peekStr(3).equals("!--")) {
            this.pos += 3;
            this.state.inHtmlComment = true;
            return new Token(TokenType.TK_COMMENT, "<!--");
        }
        if (var1_1 == 45 && this.state.inHtmlComment && this.peekStr(2).equals("->")) {
            this.state.inHtmlComment = false;
            this.pos += 2;
            if (this.wantedNewline) {
                this.printNewline();
            }
            return new Token(TokenType.TK_COMMENT, "-->");
        }
        var7_17 = JavascriptFormatter.PUNCTUATION;
        var6_15 = JavascriptFormatter.PUNCTUATION.length;
        var5_13 = 0;
        while (var5_13 < var6_15) {
            var4_10 = var7_17[var5_13];
            var8_18 = var4_10.length();
            if (var1_1 == var4_10.charAt(0) && (var8_18 == 1 || var4_10.substring(1).equals(this.peekStr(var8_18 - 1)))) {
                this.pos += var8_18 - 1;
                if (var1_1 == 61) {
                    return new Token(TokenType.TK_EQUALS, var4_10);
                }
                return new Token(TokenType.TK_OPERATOR, var4_10);
            }
            ++var5_13;
        }
        return new Token(TokenType.TK_UNKNOWN, var1_1);
    }

    private boolean atEnd() {
        return this.pos >= this.input.length();
    }

    private int next() {
        if (this.atEnd()) {
            return -1;
        }
        ++this.pos;
        return this.input.charAt(this.pos - 1);
    }

    private String peekStr(int n) {
        if (this.pos + n > this.input.length()) {
            return "";
        }
        return this.input.substring(this.pos, this.pos + n);
    }

    private int peek() {
        if (this.atEnd()) {
            return -1;
        }
        return this.input.charAt(this.pos);
    }

    /*
     * Unable to fully structure code
     */
    private Token maybeCommentToken() {
        if (this.peek() != 42 && this.peek() != 47) {
            return null;
        }
        var1_1 = TokenType.TK_INLINE_COMMENT;
        var2_2 = new StringBuilder();
        var3_3 = this.next();
        var2_2.append('/');
        if (var3_3 != 42) ** GOTO lbl25
        while ((var3_3 != 42 || this.peek() != 47) && var3_3 != -1) {
            var2_2.append((char)var3_3);
            if (var3_3 == 10 || var3_3 == 13) {
                var1_1 = TokenType.TK_BLOCK_COMMENT;
            }
            var3_3 = this.next();
        }
        if (var3_3 == 42) {
            this.next();
            var2_2.append("*/");
        }
        return new Token(var1_1, var2_2.toString());
lbl-1000:
        // 1 sources

        {
            var2_2.append((char)var3_3);
            var3_3 = this.next();
lbl25:
            // 2 sources

            ** while (var3_3 != 10 && var3_3 != 13 && var3_3 != -1)
        }
lbl26:
        // 1 sources

        return new Token(TokenType.TK_COMMENT, var2_2.toString());
    }

    private void handleStartExpr(String string) {
        if (string.equals("[")) {
            if (this.lastTokenType == TokenType.TK_WORD || ")".equals(this.lastText)) {
                String[] stringArray = LINE_STARTERS;
                if (LINE_STARTERS.length != 0) {
                    String string2 = stringArray[0];
                    if (string2.equals(string)) {
                        this.printSingleSpace();
                    }
                    this.setMode(FormatterState.Mode.PAREN_EXPR);
                    this.printToken(string);
                    return;
                }
            }
            if (this.state.mode == FormatterState.Mode.ARRAY_EXPR || this.state.mode == FormatterState.Mode.ARRAY_INDENTED_EXPR) {
                if ("]".equals(this.secondLastText) && ",".equals(this.lastText)) {
                    if (this.state.mode == FormatterState.Mode.ARRAY_EXPR) {
                        this.state.mode = FormatterState.Mode.ARRAY_INDENTED_EXPR;
                        if (!this.config.keepArrayIndentation) {
                            this.indent();
                        }
                    }
                    this.setMode(FormatterState.Mode.ARRAY_EXPR);
                    if (!this.config.keepArrayIndentation) {
                        this.printNewline();
                    }
                } else if ("[".equals(this.lastText)) {
                    if (this.state.mode == FormatterState.Mode.ARRAY_EXPR) {
                        this.state.mode = FormatterState.Mode.ARRAY_INDENTED_EXPR;
                        if (!this.config.keepArrayIndentation) {
                            this.indent();
                        }
                    }
                    this.setMode(FormatterState.Mode.ARRAY_EXPR);
                    if (!this.config.keepArrayIndentation) {
                        this.printNewline();
                    }
                } else {
                    this.setMode(FormatterState.Mode.ARRAY_EXPR);
                }
            } else {
                this.setMode(FormatterState.Mode.ARRAY_EXPR);
            }
        } else {
            this.setMode(FormatterState.Mode.ARRAY_EXPR);
        }
        if (";".equals(this.lastText) || this.lastTokenType == TokenType.TK_START_BLOCK) {
            this.printNewline();
        } else if (this.lastTokenType != TokenType.TK_END_EXPR && this.lastTokenType != TokenType.TK_START_EXPR && this.lastTokenType != TokenType.TK_END_BLOCK && !".".equals(this.lastText)) {
            if (this.lastTokenType != TokenType.TK_WORD && this.lastTokenType != TokenType.TK_OPERATOR) {
                this.printSingleSpace();
            } else if ("function".equals(this.lastWord) || "typeof".equals(this.lastWord)) {
                this.printSingleSpace();
            } else if ("catch".equals(this.lastText)) {
                this.printSingleSpace();
            } else {
                String[] stringArray = LINE_STARTERS;
                int n = LINE_STARTERS.length;
                int n2 = 0;
                while (n2 < n) {
                    String string3 = stringArray[n2];
                    if (string3.equals(this.lastText)) {
                        this.printSingleSpace();
                    }
                    ++n2;
                }
            }
        }
        this.printToken(string);
    }

    private void handleEndExpr(String string) {
        if ("]".equals(string)) {
            if (this.config.keepArrayIndentation) {
                if ("}".equals(this.lastText)) {
                    this.removeIndent();
                    this.printToken(string);
                    this.restoreMode();
                }
            } else if (this.state.mode == FormatterState.Mode.ARRAY_INDENTED_EXPR && "]".equals(this.lastText)) {
                this.restoreMode();
                this.printNewline();
                this.printToken(string);
            }
        }
        this.restoreMode();
        this.printToken(string);
    }

    private void handleStartBlock(String string) {
        if (this.isLastWord("do")) {
            this.setMode(FormatterState.Mode.DO_BLOCK);
        } else {
            this.setMode(FormatterState.Mode.BLOCK);
        }
        if (this.config.braceStyle == JavascriptFormatterConfig.BraceStyle.EXPAND) {
            if (this.notLastToken(TokenType.TK_OPERATOR)) {
                if (this.isLastText("return", "=")) {
                    this.printSingleSpace();
                } else {
                    this.printNewline(true);
                }
            }
            this.printToken(string);
            this.indent();
        } else {
            if (this.notLastToken(TokenType.TK_OPERATOR, TokenType.TK_START_EXPR)) {
                if (this.isLastToken(TokenType.TK_START_BLOCK)) {
                    this.printNewline();
                } else {
                    this.printSingleSpace();
                }
            } else if (this.state.previousMode.isArray && this.isLastText(",")) {
                if (this.isSecondLastText("}")) {
                    this.printSingleSpace();
                } else {
                    this.printNewline();
                }
            }
            this.indent();
            this.printToken(string);
        }
    }

    private void handleEndBlock(String string) {
        this.restoreMode();
        if (this.config.braceStyle == JavascriptFormatterConfig.BraceStyle.EXPAND) {
            if (this.notLastText("{")) {
                this.printNewline();
            }
            this.printToken(string);
        } else {
            if (this.isLastToken(TokenType.TK_START_BLOCK)) {
                if (this.justAddedNewline) {
                    this.removeIndent();
                } else {
                    this.trimOutput();
                }
            } else if (this.state.mode.isArray && this.config.keepArrayIndentation) {
                this.config.keepArrayIndentation = false;
                this.printNewline();
                this.config.keepArrayIndentation = true;
            } else {
                this.printNewline();
            }
            this.printToken(string);
        }
    }

    private void handleWord(String string) {
        int n;
        if (this.doBlockJustClosed) {
            this.printSingleSpace();
            this.printToken(string);
            this.printSingleSpace();
            this.doBlockJustClosed = false;
            return;
        }
        if ("function".equals(string)) {
            if (this.state.varLine) {
                this.state.varLineReindented = true;
            }
            if ((this.justAddedNewline || this.isLastText(";")) && this.notLastText("{")) {
                int n2 = this.newlineCount = this.justAddedNewline ? this.newlineCount : 0;
                if (!this.config.preserveNewlines) {
                    this.newlineCount = 1;
                }
                n = 0;
                while (n < 2 - this.newlineCount) {
                    this.printNewline(false);
                    ++n;
                }
            }
        }
        if ("case".equals(string) || "default".equals(string)) {
            if (this.isLastText(":")) {
                this.removeIndent();
            } else {
                --this.state.indentationLevel;
                this.printNewline();
                ++this.state.indentationLevel;
            }
            this.printToken(string);
            this.state.inCase = true;
            return;
        }
        n = 0;
        String string2 = string.toLowerCase();
        if (this.isLastToken(TokenType.TK_END_BLOCK)) {
            if (!("else".equals(string2) || "catch".equals(string2) || "finally".equals(string2))) {
                n = 1;
            } else if (this.config.braceStyle == JavascriptFormatterConfig.BraceStyle.EXPAND || this.config.braceStyle == JavascriptFormatterConfig.BraceStyle.END_EXPAND) {
                n = 1;
            } else {
                n = 2;
                this.printSingleSpace();
            }
        } else if (this.isLastToken(TokenType.TK_SEMICOLON) && (this.state.mode == FormatterState.Mode.BLOCK || this.state.mode == FormatterState.Mode.DO_BLOCK)) {
            n = 1;
        } else if (this.isLastToken(TokenType.TK_SEMICOLON) && this.state.mode.isExpression) {
            n = 2;
        } else if (this.isLastToken(TokenType.TK_STRING)) {
            n = 1;
        } else if (this.isLastToken(TokenType.TK_WORD)) {
            if (this.isLastText("else")) {
                this.trimOutput(true);
            }
            n = 2;
        } else if (this.isLastToken(TokenType.TK_START_BLOCK)) {
            n = 1;
        } else if (this.isLastToken(TokenType.TK_END_EXPR)) {
            this.printSingleSpace();
            n = 1;
        }
        if (this.containsString(LINE_STARTERS, string) && this.notLastText(")")) {
            n = this.isLastText("else") ? 2 : 1;
        }
        if (this.state.ifLine && this.isLastToken(TokenType.TK_END_EXPR)) {
            this.state.ifLine = false;
        }
        if (this.containsString(new String[]{"else", "catch", "finally"}, string2)) {
            if (this.notLastToken(TokenType.TK_END_BLOCK) || this.config.braceStyle == JavascriptFormatterConfig.BraceStyle.EXPAND || this.config.braceStyle == JavascriptFormatterConfig.BraceStyle.END_EXPAND) {
                this.printNewline();
            } else {
                this.trimOutput(true);
                this.printSingleSpace();
            }
        } else if (n == 1) {
            if (!this.isLastToken(TokenType.TK_START_EXPR) && !this.isLastText("=", ",") || !"function".equals(string)) {
                if ("function".equals(string) && this.isLastText("new")) {
                    this.printSingleSpace();
                } else if (this.isLastText("return", "throw")) {
                    this.printSingleSpace();
                } else if (this.notLastToken(TokenType.TK_END_EXPR)) {
                    if ((this.notLastToken(TokenType.TK_START_EXPR) || !"var".equals(string)) && this.notLastText(":")) {
                        if ("if".equals(string) && this.isLastWord("else") && this.notLastText("{")) {
                            this.printSingleSpace();
                        } else {
                            this.state.varLine = false;
                            this.state.varLineReindented = false;
                            this.printNewline();
                        }
                    }
                } else if (this.containsString(LINE_STARTERS, string) && this.notLastText(")")) {
                    this.state.varLine = false;
                    this.state.varLineReindented = false;
                    this.printNewline();
                }
            }
        } else if (this.state.mode.isArray && this.isLastText(",") && this.isSecondLastText(")")) {
            this.printNewline();
        } else if (n == 2) {
            this.printSingleSpace();
        }
        this.printToken(string);
        this.lastWord = string;
        if ("var".equals(string)) {
            this.state.varLine = true;
            this.state.varLineReindented = false;
            this.state.varLineTainted = false;
        } else if ("if".equals(string)) {
            this.state.ifLine = true;
        } else if ("else".equals(string)) {
            this.state.ifLine = false;
        }
    }

    private void handleSemicolon(String string) {
        this.printToken(string);
        this.state.varLine = false;
        this.state.varLineReindented = false;
        if (this.state.mode == FormatterState.Mode.OBJECT) {
            this.state.mode = FormatterState.Mode.BLOCK;
        }
    }

    private void handleString(String string) {
        if (this.isLastToken(TokenType.TK_START_BLOCK, TokenType.TK_END_BLOCK, TokenType.TK_SEMICOLON)) {
            this.printNewline();
        } else if (this.isLastToken(TokenType.TK_WORD)) {
            this.printSingleSpace();
        }
        this.printToken(string);
    }

    private void handleEquals(String string) {
        if (this.state.varLine) {
            this.state.varLineTainted = true;
        }
        this.printSingleSpace();
        this.printToken(string);
        this.printSingleSpace();
    }

    private void handleOperator(String string) {
        boolean bl = true;
        boolean bl2 = true;
        if (this.state.varLine && ",".equals(string) && this.state.mode.isExpression) {
            this.state.varLineTainted = false;
        }
        if (this.state.varLine && ",".equals(string)) {
            if (this.state.varLineTainted) {
                this.printToken(string);
                this.state.varLineReindented = true;
                this.state.varLineTainted = false;
                this.printNewline();
                return;
            }
            this.state.varLineTainted = false;
        }
        if (this.isLastText("return", "throw")) {
            this.printSingleSpace();
            this.printToken(string);
            return;
        }
        if (":".equals(string) && this.state.inCase) {
            this.printToken(string);
            this.printNewline();
            this.state.inCase = false;
            return;
        }
        if ("::".equals(string)) {
            this.printToken(string);
            return;
        }
        if (",".equals(string)) {
            if (this.state.varLine) {
                if (this.state.varLineTainted) {
                    this.printToken(string);
                    this.printNewline();
                    this.state.varLineTainted = false;
                } else {
                    this.printToken(string);
                    this.printSingleSpace();
                }
            } else if (this.isLastToken(TokenType.TK_END_BLOCK) && this.state.mode != FormatterState.Mode.PAREN_EXPR) {
                this.printToken(string);
                if (this.state.mode == FormatterState.Mode.OBJECT && this.isLastText("}")) {
                    this.printNewline();
                } else {
                    this.printSingleSpace();
                }
            } else if (this.state.mode == FormatterState.Mode.OBJECT) {
                this.printToken(string);
                this.printNewline();
            } else {
                this.printToken(string);
                this.printSingleSpace();
            }
            return;
        }
        if (this.containsString(new String[]{"--", "++", "!"}, string) || this.containsString(new String[]{"-", "+"}, string) && this.isLastToken(TokenType.TK_START_BLOCK, TokenType.TK_START_EXPR, TokenType.TK_EQUALS, TokenType.TK_OPERATOR) || this.isLastText(LINE_STARTERS)) {
            bl = false;
            bl2 = false;
            if (this.isLastText(";") && this.state.mode.isExpression) {
                bl = true;
            }
            if (this.isLastToken(TokenType.TK_WORD) && this.isLastText(LINE_STARTERS)) {
                bl = true;
            }
            if (this.state.mode == FormatterState.Mode.BLOCK && this.isLastText("{", ";")) {
                this.printNewline();
            }
        } else if (".".equals(string)) {
            bl = false;
        } else if (":".equals(string)) {
            if (this.state.ternaryDepth == 0) {
                this.state.mode = FormatterState.Mode.OBJECT;
                bl = false;
            } else {
                --this.state.ternaryDepth;
            }
        } else if ("?".equals(string)) {
            ++this.state.ternaryDepth;
        }
        if (bl) {
            this.printSingleSpace();
        }
        this.printToken(string);
        if (bl2) {
            this.printSingleSpace();
        }
    }

    private void handleBlockComment(String string) {
        String[] stringArray = string.split("\\r?\\n");
        if (string.matches("^/\\*\\*")) {
            int n = 0;
            while (n < stringArray.length) {
                this.printNewline();
                if (n > 0) {
                    this.output.append(" ");
                }
                this.output.append(stringArray[n].trim());
                ++n;
            }
        } else {
            if (stringArray.length > 1) {
                this.printNewline();
                this.trimOutput();
            } else {
                this.printSingleSpace();
            }
            int n = 0;
            while (n < stringArray.length) {
                this.output.append(stringArray[n]);
                this.output.append("\n");
                ++n;
            }
        }
        this.printNewline();
    }

    private void handleInlineComment(String string) {
        this.printSingleSpace();
        this.printToken(string);
        if (this.state.mode.isExpression) {
            this.printSingleSpace();
        } else {
            this.printNewline();
        }
    }

    private void handleComment(String string) {
        if (this.wantedNewline) {
            this.printNewline();
        } else {
            this.printSingleSpace();
        }
        this.printToken(string);
        this.printNewline();
    }

    private void handleUnknown(String string) {
        if (this.isLastText("return", "throw")) {
            this.printSingleSpace();
        }
        this.printToken(string);
    }

    private void trimOutput() {
        this.trimOutput(false);
    }

    private void trimOutput(boolean bl) {
        while (this.endsWith(' ') || this.endsWithIndent() || bl && (this.endsWith('\n') || this.endsWith('\r'))) {
            this.dropLast();
        }
    }

    private void printNewline() {
        this.printNewline(true);
    }

    private void printNewline(boolean bl) {
        this.state.eatNextSpace = false;
        if (this.config.keepArrayIndentation && this.state.mode.isArray) {
            return;
        }
        this.trimOutput();
        if (this.outputEmpty()) {
            return;
        }
        if (this.lastOutputChar() != '\n' || !bl) {
            this.justAddedNewline = true;
            this.output.append("\n");
        }
        int n = 0;
        while (n < this.state.indentationLevel) {
            this.output.append(this.indentString);
            ++n;
        }
        if (this.state.varLine && this.state.varLineReindented) {
            if (this.config.indentChar == ' ') {
                this.output.append("    ");
            } else {
                this.output.append(this.indentString);
            }
        }
    }

    private void printSingleSpace() {
        if (this.state.eatNextSpace) {
            this.state.eatNextSpace = false;
            return;
        }
        char c = ' ';
        if (this.output.length() > 0) {
            c = this.output.charAt(this.output.length() - 1);
        }
        if (c != ' ' && c != '\n' && (this.indentString.length() != 1 || this.indentString.charAt(0) != c)) {
            this.output.append(' ');
        }
    }

    private void printToken(String string) {
        this.justAddedNewline = false;
        this.state.eatNextSpace = false;
        this.output.append(string);
    }

    private void indent() {
        ++this.state.indentationLevel;
    }

    private void removeIndent() {
        if (this.output.length() > 0 && this.matchIndentString(this.lastOutputChar())) {
            this.dropLast();
        }
    }

    private void setMode(FormatterState.Mode mode) {
        if (this.state != null) {
            this.stateStack.add(this.state);
        }
        this.state = new FormatterState(this.config, mode, this.state);
    }

    private void restoreMode() {
        boolean bl = this.doBlockJustClosed = this.state.mode == FormatterState.Mode.DO_BLOCK;
        if (this.stateStack.size() > 0) {
            this.state = this.stateStack.remove(this.stateStack.size() - 1);
        }
    }

    private boolean endsWith(char c) {
        if (this.outputEmpty()) {
            return false;
        }
        return this.lastOutputChar() == c;
    }

    private boolean endsWithIndent() {
        if (this.outputEmpty()) {
            return false;
        }
        return this.matchIndentString(this.lastOutputChar());
    }

    private boolean matchIndentString(char c) {
        return this.indentString.length() == 1 && this.indentString.charAt(0) == c;
    }

    private char lastOutputChar() {
        return this.output.charAt(this.output.length() - 1);
    }

    private boolean outputEmpty() {
        return this.output.length() == 0;
    }

    private void dropLast() {
        if (!this.outputEmpty()) {
            this.output.deleteCharAt(this.output.length() - 1);
        }
    }

    private boolean containsString(String[] stringArray, String string) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (string2.equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean notLastToken(TokenType ... tokenTypeArray) {
        TokenType[] tokenTypeArray2 = tokenTypeArray;
        int n = tokenTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TokenType tokenType = tokenTypeArray2[n2];
            if (this.lastTokenType == tokenType) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isLastToken(TokenType ... tokenTypeArray) {
        TokenType[] tokenTypeArray2 = tokenTypeArray;
        int n = tokenTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TokenType tokenType = tokenTypeArray2[n2];
            if (this.lastTokenType == tokenType) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isLastText(String ... stringArray) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            if (string.equals(this.lastText)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean notLastText(String ... stringArray) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            if (string.equals(this.lastText)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isSecondLastText(String string) {
        return string.equals(this.secondLastText);
    }

    private boolean isLastWord(String string) {
        return string.equals(this.lastWord);
    }

    static class Token {
        final TokenType type;
        final String text;

        Token(TokenType tokenType, int n) {
            this.type = tokenType;
            this.text = String.valueOf((char)n);
        }

        Token(TokenType tokenType, String string) {
            this.type = tokenType;
            this.text = string;
        }
    }

    private static enum TokenType {
        TK_START_EXPR,
        TK_END_EXPR,
        TK_START_BLOCK,
        TK_END_BLOCK,
        TK_WORD,
        TK_SEMICOLON,
        TK_STRING,
        TK_EQUALS,
        TK_OPERATOR,
        TK_BLOCK_COMMENT,
        TK_INLINE_COMMENT,
        TK_COMMENT,
        TK_EOF,
        TK_UNKNOWN;

    }
}

