/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor.http;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class HttpVersionRule
implements IRule {
    private static final char[] VERSION_PREFIX = "HTTP/".toCharArray();
    private final IToken token;

    public HttpVersionRule(IToken iToken) {
        this.token = iToken;
    }

    public IToken evaluate(ICharacterScanner iCharacterScanner) {
        if (!this.matchPrefix(VERSION_PREFIX, iCharacterScanner)) {
            return Token.UNDEFINED;
        }
        int n = VERSION_PREFIX.length;
        if (!this.readDigit(iCharacterScanner)) {
            this.rewind(iCharacterScanner, n);
            return Token.UNDEFINED;
        }
        ++n;
        if (!this.readDot(iCharacterScanner)) {
            this.rewind(iCharacterScanner, n);
            return Token.UNDEFINED;
        }
        ++n;
        if (!this.readDigit(iCharacterScanner)) {
            this.rewind(iCharacterScanner, n);
            return Token.UNDEFINED;
        }
        return this.token;
    }

    private boolean matchPrefix(char[] cArray, ICharacterScanner iCharacterScanner) {
        int n = 0;
        while (n < cArray.length) {
            int n2 = iCharacterScanner.read();
            if ((char)n2 != cArray[n]) {
                this.rewind(iCharacterScanner, n + 1);
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean readDigit(ICharacterScanner iCharacterScanner) {
        int n = iCharacterScanner.read();
        if (n >= 48 && n <= 57) {
            return true;
        }
        iCharacterScanner.unread();
        return false;
    }

    private boolean readDot(ICharacterScanner iCharacterScanner) {
        int n = iCharacterScanner.read();
        if (n == 46) {
            return true;
        }
        iCharacterScanner.unread();
        return false;
    }

    private void rewind(ICharacterScanner iCharacterScanner, int n) {
        int n2 = 0;
        while (n2 < n) {
            iCharacterScanner.unread();
            ++n2;
        }
    }
}

