/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor.http;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class HeaderNameRule
implements IRule {
    private static final String SEPARATORS = "()<>@,;:\\\"/[]?={} \t";
    private final IToken token;

    public HeaderNameRule(IToken iToken) {
        this.token = iToken;
    }

    public IToken evaluate(ICharacterScanner iCharacterScanner) {
        int n;
        if (iCharacterScanner.getColumn() != 0) {
            return Token.UNDEFINED;
        }
        int n2 = 1;
        while ((n = iCharacterScanner.read()) != -1) {
            if (n == 58 && n2 > 1) {
                return this.token;
            }
            if (!this.isLegalHeaderNameChar(n)) break;
            ++n2;
        }
        this.rewind(iCharacterScanner, n2);
        return Token.UNDEFINED;
    }

    private void rewind(ICharacterScanner iCharacterScanner, int n) {
        int n2 = 0;
        while (n2 < n) {
            iCharacterScanner.unread();
            ++n2;
        }
    }

    private boolean isLegalHeaderNameChar(int n) {
        return n > 31 && SEPARATORS.indexOf(n) == -1;
    }
}

