/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor.http;

import com.subgraph.vega.ui.httpeditor.http.AbstractSyntaxRule;
import java.util.Arrays;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;

public class DateRule
extends AbstractSyntaxRule {
    private final String[] days = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
    private final String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public DateRule(IToken iToken) {
        super(iToken);
    }

    @Override
    protected boolean evaluateRule(ICharacterScanner iCharacterScanner) {
        return this.matchDay(iCharacterScanner) && this.matchSingleChar(iCharacterScanner, ',') && this.matchWhitespace(iCharacterScanner) && this.matchDigits(iCharacterScanner, 1, 2) && this.matchWhitespace(iCharacterScanner) && this.matchMonth(iCharacterScanner) && this.matchWhitespace(iCharacterScanner) && this.matchDigits(iCharacterScanner, 4) && this.matchWhitespace(iCharacterScanner) && this.matchDigits(iCharacterScanner, 2) && this.matchSingleChar(iCharacterScanner, ':') && this.matchDigits(iCharacterScanner, 2) && this.matchSingleChar(iCharacterScanner, ':') && this.matchDigits(iCharacterScanner, 2) && this.matchWhitespace(iCharacterScanner) && this.matchGMT(iCharacterScanner);
    }

    private boolean matchDay(ICharacterScanner iCharacterScanner) {
        return this.matchStringFromList(iCharacterScanner, this.days);
    }

    private boolean matchMonth(ICharacterScanner iCharacterScanner) {
        return this.matchStringFromList(iCharacterScanner, this.months);
    }

    private boolean matchStringFromList(ICharacterScanner iCharacterScanner, String[] stringArray) {
        char[] cArray = this.readThreeLetters(iCharacterScanner);
        if (cArray == null) {
            return false;
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            if (Arrays.equals(string.toCharArray(), cArray)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean matchGMT(ICharacterScanner iCharacterScanner) {
        int n = iCharacterScanner.read();
        ++this.readCount;
        if (n != 71) {
            return false;
        }
        n = iCharacterScanner.read();
        ++this.readCount;
        if (n != 77) {
            return false;
        }
        n = iCharacterScanner.read();
        ++this.readCount;
        return n == 84;
    }

    private char[] readThreeLetters(ICharacterScanner iCharacterScanner) {
        char[] cArray = new char[3];
        int n = iCharacterScanner.read();
        ++this.readCount;
        if (!this.isUppercase(n)) {
            return null;
        }
        cArray[0] = (char)n;
        n = iCharacterScanner.read();
        ++this.readCount;
        if (!this.isLowercase(n)) {
            return null;
        }
        cArray[1] = (char)n;
        n = iCharacterScanner.read();
        ++this.readCount;
        if (!this.isLowercase(n)) {
            return null;
        }
        cArray[2] = (char)n;
        return cArray;
    }
}

