/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor.highlights;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionViewer;

public class RegionInfo {
    private final IRegion region;
    private final Position position;
    private final Annotation annotation;
    private boolean isAnnotationDisplayed;

    RegionInfo(IRegion iRegion, String string) {
        this.region = iRegion;
        this.position = new Position(iRegion.getOffset(), iRegion.getLength());
        this.annotation = new Annotation(string, false, "");
    }

    IRegion getRegion() {
        return this.region;
    }

    void removeHighlight(SourceViewer sourceViewer) {
        if (!this.isAnnotationDisplayed) {
            return;
        }
        IAnnotationModel iAnnotationModel = sourceViewer.getAnnotationModel();
        if (iAnnotationModel != null) {
            iAnnotationModel.removeAnnotation(this.annotation);
            this.isAnnotationDisplayed = false;
        }
    }

    void displayHighlight(SourceViewer sourceViewer) {
        if (this.isAnnotationDisplayed) {
            return;
        }
        IAnnotationModel iAnnotationModel = sourceViewer.getAnnotationModel();
        if (iAnnotationModel != null) {
            if (sourceViewer instanceof ProjectionViewer) {
                ((ProjectionViewer)sourceViewer).getProjectionAnnotationModel().expandAll(this.region.getOffset(), this.region.getLength());
            }
            iAnnotationModel.addAnnotation(this.annotation, this.position);
            this.isAnnotationDisplayed = true;
        }
    }
}

