/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor.highlights;

import com.subgraph.vega.ui.httpeditor.highlights.MatchChangeListener;
import com.subgraph.vega.ui.httpeditor.highlights.MatchHighlighter;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class NavigationButtons
extends Composite {
    private final MatchHighlighter highlighter;
    private final MatchChangeListener listener;
    private final Button nextMatch;
    private final Button previousMatch;

    public NavigationButtons(Composite composite, MatchHighlighter matchHighlighter, MatchChangeListener matchChangeListener) {
        super(composite, 0);
        this.setLayout((Layout)new RowLayout(256));
        this.highlighter = matchHighlighter;
        this.listener = matchChangeListener;
        this.nextMatch = this.createNextMatchButton();
        this.previousMatch = this.createPreviousMatchButton();
        this.pack();
    }

    private Button createNextMatchButton() {
        return this.createArrowButton(1024, new Listener(){

            public void handleEvent(Event event) {
                NavigationButtons.this.handleNextMatch();
            }
        });
    }

    private Button createPreviousMatchButton() {
        return this.createArrowButton(128, new Listener(){

            public void handleEvent(Event event) {
                NavigationButtons.this.handlePreviousMatch();
            }
        });
    }

    private Button createArrowButton(int n, Listener listener) {
        Button button = new Button((Composite)this, 4 | n);
        button.addListener(13, listener);
        button.setEnabled(false);
        return button;
    }

    public void handleNextMatch() {
        if (this.highlighter.isActive() && this.highlighter.hasNextMatch()) {
            this.highlighter.displayNextMatch();
        }
        this.enableButtonsForMatchState();
        this.listener.matchChanged();
    }

    public void handlePreviousMatch() {
        if (this.highlighter.isActive() && this.highlighter.hasPreviousMatch()) {
            this.highlighter.displayPreviousMatch();
        }
        this.enableButtonsForMatchState();
        this.listener.matchChanged();
    }

    public void enableButtonsForMatchState() {
        if (this.nextMatch.isDisposed() || this.previousMatch.isDisposed()) {
            return;
        }
        if (!this.highlighter.isActive()) {
            this.nextMatch.setEnabled(false);
            this.previousMatch.setEnabled(false);
            return;
        }
        this.nextMatch.setEnabled(this.highlighter.hasNextMatch());
        this.previousMatch.setEnabled(this.highlighter.hasPreviousMatch());
    }
}

