/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor.highlights;

import com.subgraph.vega.api.model.alerts.IScanAlertHighlight;
import com.subgraph.vega.ui.httpeditor.Colors;
import com.subgraph.vega.ui.httpeditor.highlights.MatchChangeListener;
import com.subgraph.vega.ui.httpeditor.highlights.MatchHighlighter;
import com.subgraph.vega.ui.httpeditor.highlights.NavigationButtons;
import java.util.Collection;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class HighlightBar
extends Composite
implements MatchChangeListener {
    private static final String ANNOTATION_HIGHLIGHT = "httpeditor.highlight";
    private final MatchHighlighter highlighter;
    private final Label alertLabel;
    private final NavigationButtons buttons;

    public HighlightBar(Composite composite, ProjectionViewer projectionViewer, Colors colors) {
        super(composite, 0);
        this.setLayout(this.createLayout());
        Color color = colors.get(Colors.ALERT_HIGHLIGHT);
        this.setBackground(color);
        this.highlighter = new MatchHighlighter(projectionViewer, color, ANNOTATION_HIGHLIGHT, false);
        this.alertLabel = this.createAlertLabel(color);
        this.buttons = new NavigationButtons(this, this.highlighter, this);
        this.buttons.setBackground(color);
        this.pack();
        this.hideHighlightBar();
    }

    private Layout createLayout() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        return gridLayout;
    }

    private Label createAlertLabel(Color color) {
        Label label = new Label((Composite)this, 0x1000004);
        label.setBackground(color);
        GridData gridData = new GridData(16384, 0x1000000, true, true);
        gridData.widthHint = 150;
        label.setLayoutData((Object)gridData);
        return label;
    }

    public void clearHighlights() {
        this.highlighter.clearMatches();
        this.hideHighlightBar();
        this.alertLabel.setText("");
    }

    public void addAlertHighlights(Collection<IScanAlertHighlight> collection) {
        for (IScanAlertHighlight iScanAlertHighlight : collection) {
            this.highlighter.searchMatches(iScanAlertHighlight.getMatchString(), iScanAlertHighlight.isRegularExpression(), iScanAlertHighlight.isCaseSensitive());
        }
    }

    public void displayHighlights() {
        if (this.highlighter.isActive() && this.highlighter.getMatchCount() != 0) {
            this.highlighter.displayFirstMatch();
            if (this.highlighter.getMatchCount() > 1) {
                this.displayHighlightBar();
                this.buttons.enableButtonsForMatchState();
                this.summarizeMatchState();
            }
        }
    }

    private void summarizeMatchState() {
        if (!this.highlighter.isActive() || this.highlighter.getMatchCount() <= 1) {
            this.alertLabel.setText("");
            return;
        }
        int n = this.highlighter.getCurrentIndex() + 1;
        int n2 = this.highlighter.getMatchCount();
        this.alertLabel.setText(n + " of " + n2 + " highlights");
    }

    private void displayHighlightBar() {
        this.setVisible(true);
        this.pack();
        this.getParent().layout(true);
    }

    private void hideHighlightBar() {
        this.setVisible(false);
        this.getParent().layout(true);
    }

    @Override
    public void matchChanged() {
        this.summarizeMatchState();
    }
}

