/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor.annotations;

import com.subgraph.vega.ui.httpeditor.annotations.AnnTransaction;
import com.subgraph.vega.ui.httpeditor.annotations.ISelfDrawingAnnotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;

public class AnnotationPainter
implements IPainter,
PaintListener,
ISelectionProvider {
    private Set<ISelectionChangedListener> listeners = new HashSet<ISelectionChangedListener>();
    private SourceViewer viewer;
    private Map<ISelfDrawingAnnotation, Position> anns = new HashMap<ISelfDrawingAnnotation, Position>();

    public AnnotationPainter(SourceViewer sourceViewer) {
        this.viewer = sourceViewer;
        this.viewer.getTextWidget().addPaintListener((PaintListener)this);
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.listeners.add(iSelectionChangedListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.listeners.remove(iSelectionChangedListener);
    }

    private void fireSelectionEvent() {
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.getSelection());
        for (ISelectionChangedListener iSelectionChangedListener : this.listeners) {
            iSelectionChangedListener.selectionChanged(selectionChangedEvent);
        }
    }

    public Position getPosition(ISelfDrawingAnnotation iSelfDrawingAnnotation) {
        return this.anns.get(iSelfDrawingAnnotation);
    }

    public void replaceAnnotations(ISelfDrawingAnnotation[] iSelfDrawingAnnotationArray, Map<ISelfDrawingAnnotation, Position> map) {
        ArrayList<Position> arrayList = new ArrayList<Position>();
        if (iSelfDrawingAnnotationArray != null) {
            ISelfDrawingAnnotation[] iSelfDrawingAnnotationArray2 = iSelfDrawingAnnotationArray;
            int n = iSelfDrawingAnnotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISelfDrawingAnnotation iSelfDrawingAnnotation = iSelfDrawingAnnotationArray2[n2];
                Position position = this.anns.remove(iSelfDrawingAnnotation);
                if (position != null) {
                    arrayList.add(position);
                }
                ++n2;
            }
        }
        if (map != null) {
            this.anns.putAll(map);
            arrayList.addAll(map.values());
        }
        this.fireAnnotationChangedEvent(arrayList);
    }

    public void replaceAnnotations(AnnTransaction annTransaction) {
        annTransaction.replaceAnnotations(this);
    }

    public void addAnnotation(ISelfDrawingAnnotation iSelfDrawingAnnotation, Position position) {
        this.anns.put(iSelfDrawingAnnotation, position);
        ArrayList<Position> arrayList = new ArrayList<Position>(1);
        arrayList.add(position);
        this.fireAnnotationChangedEvent(arrayList);
    }

    public void removeAnnotation(ISelfDrawingAnnotation iSelfDrawingAnnotation) {
        Position position = this.anns.remove(iSelfDrawingAnnotation);
        if (position != null) {
            ArrayList<Position> arrayList = new ArrayList<Position>(1);
            arrayList.add(position);
            this.fireAnnotationChangedEvent(arrayList);
        }
    }

    public void removeAllAnnotations() {
        ArrayList<Position> arrayList = new ArrayList<Position>(this.anns.values());
        this.anns.clear();
        this.fireAnnotationChangedEvent(arrayList);
    }

    private void fireAnnotationChangedEvent(Collection<Position> collection) {
        if (collection.isEmpty()) {
            return;
        }
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        for (Position position : collection) {
            int n3;
            if (n > position.getOffset()) {
                n = position.offset;
            }
            if (n2 >= (n3 = position.getOffset() + position.getLength())) continue;
            n2 = n3;
        }
        n = this.widgetIndex(n);
        n2 = this.widgetIndex(n2);
        this.viewer.getTextWidget().redrawRange(n, n2 - n, false);
    }

    public void deactivate(boolean bl) {
    }

    public void setPositionManager(IPaintPositionManager iPaintPositionManager) {
    }

    public void paint(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                this.fireSelectionEvent();
            }
        }
    }

    public void dispose() {
        this.refresh();
        this.anns.clear();
        this.paint(8);
        this.viewer.getTextWidget().removePaintListener((PaintListener)this);
        this.viewer.removePainter((IPainter)this);
    }

    public void paintControl(PaintEvent paintEvent) {
        for (Map.Entry<ISelfDrawingAnnotation, Position> entry : this.anns.entrySet()) {
            ISelfDrawingAnnotation iSelfDrawingAnnotation = entry.getKey();
            Position position = entry.getValue();
            IRegion iRegion = this.viewer.modelRange2WidgetRange((IRegion)new Region(position.offset, position.length));
            if (iRegion == null) continue;
            iSelfDrawingAnnotation.draw(paintEvent.gc, this.viewer.getTextWidget(), iRegion.getOffset(), iRegion.getLength());
        }
    }

    private int widgetIndex(int n) {
        int n2 = this.viewer.modelOffset2WidgetOffset(n);
        if (n2 < 0) {
            n2 = this.viewer.getBottomIndexEndOffset();
        }
        return n2;
    }

    public ITextSelection getSelection() {
        return (ITextSelection)this.viewer.getSelection();
    }

    public void setSelection(ISelection iSelection) {
        this.viewer.setSelection(iSelection);
    }

    public Iterator<ISelfDrawingAnnotation> getAnnotationIterator() {
        return this.anns.keySet().iterator();
    }

    private void refresh() {
        this.fireAnnotationChangedEvent(this.anns.values());
    }

    public void refresh(Collection<ISelfDrawingAnnotation> collection) {
        ArrayList<Position> arrayList = new ArrayList<Position>();
        for (ISelfDrawingAnnotation iSelfDrawingAnnotation : collection) {
            arrayList.add(this.anns.get(iSelfDrawingAnnotation));
        }
        this.fireAnnotationChangedEvent(arrayList);
    }
}

