/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.ImageData;

public class HttpMessageEntity {
    private final HttpEntity entity;
    private final EntityType entityType;
    private final ImageData entityImage;
    private final String entityText;
    private final byte[] entityBytes;
    private final String contentType;
    private final String contentEncoding;

    static HttpMessageEntity createFromEntity(HttpEntity httpEntity) {
        if (httpEntity == null || httpEntity.getContentLength() == 0L) {
            return HttpMessageEntity.createEmptyEntity();
        }
        try {
            String string = EntityUtils.toString((HttpEntity)httpEntity);
            if (HttpMessageEntity.isBodyAscii(string)) {
                return HttpMessageEntity.createAsciiEntity(httpEntity, string);
            }
            return HttpMessageEntity.createFromBinaryEntity(httpEntity, EntityUtils.toByteArray((HttpEntity)httpEntity));
        }
        catch (ParseException parseException) {
            return HttpMessageEntity.createEmptyEntity();
        }
        catch (IOException iOException) {
            return HttpMessageEntity.createEmptyEntity();
        }
    }

    private static HttpMessageEntity createFromBinaryEntity(HttpEntity httpEntity, byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return HttpMessageEntity.createEmptyEntity();
        }
        ImageData imageData = HttpMessageEntity.binaryToImageData(byArray);
        if (imageData != null) {
            return HttpMessageEntity.createImageEntity(httpEntity, byArray, imageData);
        }
        return HttpMessageEntity.createBinaryEntity(httpEntity, byArray);
    }

    private static boolean isBodyAscii(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        int n = string.length() > 500 ? 500 : string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c >= ' ' && c <= '\u007f' || Character.isWhitespace(c)) {
                ++n2;
            }
            ++n3;
        }
        return n2 * 100 / n > 90;
    }

    private static ImageData binaryToImageData(byte[] byArray) {
        try {
            return new ImageData((InputStream)new ByteArrayInputStream(byArray));
        }
        catch (SWTException sWTException) {
            return null;
        }
    }

    private static HttpMessageEntity createEmptyEntity() {
        return new HttpMessageEntity(EntityType.ENTITY_NONE, null, "", new byte[0], null);
    }

    private static HttpMessageEntity createImageEntity(HttpEntity httpEntity, byte[] byArray, ImageData imageData) {
        return new HttpMessageEntity(EntityType.ENTITY_IMAGE, httpEntity, "", byArray, imageData);
    }

    private static HttpMessageEntity createBinaryEntity(HttpEntity httpEntity, byte[] byArray) {
        return new HttpMessageEntity(EntityType.ENTITY_BINARY, httpEntity, "", byArray, null);
    }

    private static HttpMessageEntity createAsciiEntity(HttpEntity httpEntity, String string) {
        return new HttpMessageEntity(EntityType.ENTITY_ASCII, httpEntity, string, new byte[0], null);
    }

    private HttpMessageEntity(EntityType entityType, HttpEntity httpEntity, String string, byte[] byArray, ImageData imageData) {
        this.entityType = entityType;
        this.entity = httpEntity;
        this.entityText = string;
        this.entityBytes = byArray;
        this.entityImage = imageData;
        this.contentType = this.getContentType(httpEntity);
        this.contentEncoding = this.getContentEncoding(httpEntity);
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    private String getContentType(HttpEntity httpEntity) {
        if (httpEntity == null) {
            return "";
        }
        return this.getHeaderValue(httpEntity.getContentType());
    }

    private String getContentEncoding(HttpEntity httpEntity) {
        if (httpEntity == null) {
            return "";
        }
        return this.getHeaderValue(httpEntity.getContentEncoding());
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    private String getHeaderValue(Header header) {
        if (header == null || header.getValue() == null) {
            return "";
        }
        return header.getValue();
    }

    public boolean isEmptyEntity() {
        return this.entityType == EntityType.ENTITY_NONE;
    }

    public boolean isImageEntity() {
        return this.entityType == EntityType.ENTITY_IMAGE;
    }

    public boolean isBinaryEntity() {
        return this.entityType == EntityType.ENTITY_BINARY;
    }

    public boolean isAsciiEntity() {
        return this.entityType == EntityType.ENTITY_ASCII;
    }

    public ImageData getImageData() {
        return this.entityImage;
    }

    public byte[] getBinaryData() {
        return this.entityBytes;
    }

    public String getTextData() {
        return this.entityText;
    }

    static enum EntityType {
        ENTITY_NONE,
        ENTITY_IMAGE,
        ENTITY_BINARY,
        ENTITY_ASCII;

    }
}

