/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor;

import com.subgraph.vega.ui.httpeditor.HeaderDecoder;
import com.subgraph.vega.ui.httpeditor.HttpMessageEntity;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;

public class HttpMessageDocument
implements IDocumentListener {
    static final String SECTION_POSITION_CATEGORY = "__section_category";
    private final IDocument document;
    private final HttpMessageEntity messageEntity;
    private final Position headerSectionPosition;
    private final Position bodySectionPosition;
    private final HeaderDecoder headerDecoder;
    private boolean isHeaderSectionDirty;
    private boolean isBodySectionDirty;

    HttpMessageDocument(IDocument iDocument, HttpMessageEntity httpMessageEntity) {
        this.document = iDocument;
        this.messageEntity = httpMessageEntity;
        Position[] positionArray = this.getSectionPositions();
        this.headerSectionPosition = positionArray[0];
        this.bodySectionPosition = positionArray[1];
        this.headerDecoder = new HeaderDecoder(this);
        iDocument.addDocumentListener((IDocumentListener)this);
    }

    private Position[] getSectionPositions() {
        try {
            Position[] positionArray = this.document.getPositions(SECTION_POSITION_CATEGORY);
            if (positionArray.length == 0 || positionArray.length > 2) {
                throw new IllegalStateException();
            }
            if (positionArray.length == 1) {
                Position[] positionArray2 = new Position[2];
                positionArray2[0] = positionArray[0];
                return positionArray2;
            }
            return new Position[]{positionArray[0], positionArray[1]};
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            throw new IllegalStateException(badPositionCategoryException);
        }
    }

    boolean isHeaderSectionDirty() {
        return this.isHeaderSectionDirty;
    }

    boolean isBodyEntityDirty() {
        if (this.bodySectionPosition != null) {
            return this.isBodySectionDirty;
        }
        return false;
    }

    IDocument getDocument() {
        return this.document;
    }

    HttpMessageEntity getMessageEntity() {
        return this.messageEntity;
    }

    Position getHeaderSection() {
        return this.headerSectionPosition;
    }

    Position getBodySection() {
        return this.bodySectionPosition;
    }

    public String getHeaderSectionText() {
        return this.headerDecoder.getUndecodedHeaderContent();
    }

    public void setHeaderSectionText(String string) {
        try {
            this.document.replace(this.headerSectionPosition.getOffset(), this.headerSectionPosition.getLength(), string);
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalStateException(badLocationException);
        }
    }

    public String getBodySectionText() {
        return this.getTextByPosition(this.bodySectionPosition);
    }

    private String getTextByPosition(Position position) {
        if (position == null) {
            return "";
        }
        try {
            return this.document.get(position.getOffset(), position.getLength());
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalStateException(badLocationException);
        }
    }

    void setHeaderDecodeState(boolean bl) {
        if (bl) {
            this.headerDecoder.decodeHeaders();
        } else {
            this.headerDecoder.undecodeHeaders();
        }
    }

    void toggleHeaderDecodeState() {
        this.headerDecoder.toggleDecodeState();
    }

    public void documentAboutToBeChanged(DocumentEvent documentEvent) {
    }

    public void documentChanged(DocumentEvent documentEvent) {
        if (this.headerSectionPosition.overlapsWith(documentEvent.getOffset(), documentEvent.getLength())) {
            this.isHeaderSectionDirty = true;
        }
        if (this.bodySectionPosition != null && this.bodySectionPosition.overlapsWith(documentEvent.getOffset(), documentEvent.getLength())) {
            this.isBodySectionDirty = true;
        }
    }

    public void addProjectionAnnotations(ProjectionAnnotationModel projectionAnnotationModel) {
        if (this.headerSectionPosition != null) {
            projectionAnnotationModel.addAnnotation((Annotation)new ProjectionAnnotation(), new Position(this.headerSectionPosition.offset, this.headerSectionPosition.length));
        }
        if (this.bodySectionPosition != null) {
            projectionAnnotationModel.addAnnotation((Annotation)new ProjectionAnnotation(), new Position(this.bodySectionPosition.offset, this.bodySectionPosition.length));
        }
    }
}

