/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.ui.macros.macrodialog;

import com.subgraph.vega.api.http.requests.IHttpRequestBuilder;
import com.subgraph.vega.api.model.macros.IHttpMacroItem;
import com.subgraph.vega.api.model.macros.IHttpMacroItemParam;
import com.subgraph.vega.internal.ui.macros.macrodialog.MacroItemParamValueEditingSupport;
import com.subgraph.vega.internal.ui.macros.macrodialog.MacroItemParamValueSourceEditingSupport;
import com.subgraph.vega.internal.ui.macros.macrodialog.MacroItemParamsTableContentProvider;
import com.subgraph.vega.ui.http.builder.BuilderParseException;
import com.subgraph.vega.ui.http.builder.IHttpBuilderPart;
import com.subgraph.vega.ui.util.dialogs.ErrorDialog;
import java.util.Iterator;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class MacroItemEditor
extends Composite
implements IHttpBuilderPart {
    private IHttpRequestBuilder requestBuilder;
    private IHttpMacroItem macroItem;
    private Button useCookiesButton;
    private Button keepCookiesButton;
    private TableViewer paramsTableViewer;
    private boolean paramsTableHasSelection;
    private Button createButton;
    private Button removeButton;
    private Button moveUpButton;
    private Button moveDownButton;

    public MacroItemEditor(Composite composite, IHttpRequestBuilder iHttpRequestBuilder) {
        super(composite, 0);
        this.requestBuilder = iHttpRequestBuilder;
        this.setLayout((Layout)new GridLayout(1, false));
        this.createConfigGroup(this).setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.createParamsGroup(this).setLayoutData((Object)new GridData(1808));
    }

    public Control getControl() {
        return this;
    }

    public void setEditable(boolean bl) {
        this.useCookiesButton.setEnabled(bl);
        this.keepCookiesButton.setEnabled(bl);
        this.createButton.setEnabled(bl);
        this.removeButton.setEnabled(bl && this.paramsTableHasSelection);
        this.moveUpButton.setEnabled(bl && this.paramsTableHasSelection);
        this.moveDownButton.setEnabled(bl && this.paramsTableHasSelection);
    }

    public void refresh() {
        try {
            if (this.macroItem != null) {
                this.macroItem.updateFromRequestBuilder(this.requestBuilder);
            }
        }
        catch (Exception exception) {
            ErrorDialog.displayError((Shell)this.getShell(), (String)"An unexpected error occurred while processing the request");
            exception.printStackTrace();
            return;
        }
        if (this.macroItem != null) {
            this.useCookiesButton.setSelection(this.macroItem.getUseCookies());
            this.keepCookiesButton.setSelection(this.macroItem.getKeepCookies());
        } else {
            this.useCookiesButton.setSelection(false);
            this.keepCookiesButton.setSelection(false);
        }
        this.paramsTableViewer.setInput((Object)this.macroItem);
    }

    public void processContents() throws BuilderParseException {
        if (this.macroItem != null) {
            try {
                this.macroItem.setRequestBuilder(this.requestBuilder, null);
            }
            catch (Exception exception) {
                ErrorDialog.displayError((Shell)this.getShell(), (String)"An unexpected error occurred while processing the request");
                exception.printStackTrace();
                return;
            }
            this.macroItem.setUseCookies(this.useCookiesButton.getSelection());
            this.macroItem.setKeepCookies(this.keepCookiesButton.getSelection());
        }
    }

    public void setMacroItem(IHttpMacroItem iHttpMacroItem) {
        this.macroItem = iHttpMacroItem;
    }

    private Composite createConfigGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText("Configuration");
        this.useCookiesButton = new Button((Composite)group, 32);
        Label label = new Label((Composite)group, 0);
        label.setText("Use cookies in the request that were already set");
        this.keepCookiesButton = new Button((Composite)group, 32);
        label = new Label((Composite)group, 0);
        label.setText("Keep cookies from the response");
        return group;
    }

    private Composite createParamsGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText("Request Parameters");
        GridData gridData = new GridData(1808);
        this.createParamsTable((Composite)group, gridData, 8).setLayoutData((Object)gridData);
        this.createParamsButtons((Composite)group).setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        return group;
    }

    private Composite createParamsTable(Composite composite, GridData gridData, int n) {
        Composite composite2 = new Composite(composite, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        composite2.setLayout((Layout)tableColumnLayout);
        this.paramsTableViewer = new TableViewer(composite2, 68354);
        this.paramsTableViewer.setContentProvider((IContentProvider)new MacroItemParamsTableContentProvider());
        this.paramsTableViewer.addSelectionChangedListener(this.createParamsTableSelectionChangedListener());
        this.createParamsTableColumns(this.paramsTableViewer, tableColumnLayout);
        Table table = this.paramsTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData.heightHint = table.getItemHeight() * n;
        return composite2;
    }

    private ISelectionChangedListener createParamsTableSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                MacroItemEditor.this.paramsTableHasSelection = !selectionChangedEvent.getSelection().isEmpty();
                MacroItemEditor.this.removeButton.setEnabled(MacroItemEditor.this.paramsTableHasSelection);
                MacroItemEditor.this.moveUpButton.setEnabled(MacroItemEditor.this.paramsTableHasSelection);
                MacroItemEditor.this.moveDownButton.setEnabled(MacroItemEditor.this.paramsTableHasSelection);
            }
        };
    }

    private void createParamsTableColumns(TableViewer tableViewer, TableColumnLayout tableColumnLayout) {
        String[] stringArray = new String[]{"Name", "Source", "Value"};
        ColumnLayoutData[] columnLayoutDataArray = new ColumnLayoutData[]{new ColumnPixelData(70, true, true), new ColumnPixelData(140, true, true), new ColumnWeightData(100, 100, true)};
        EditingSupport[] editingSupportArray = new EditingSupport[3];
        editingSupportArray[1] = new MacroItemParamValueSourceEditingSupport(tableViewer);
        editingSupportArray[2] = new MacroItemParamValueEditingSupport(tableViewer);
        EditingSupport[] editingSupportArray2 = editingSupportArray;
        ColumnLabelProvider[] columnLabelProviderArray = new ColumnLabelProvider[]{new ColumnLabelProvider(){

            public String getText(Object object) {
                return ((IHttpMacroItemParam)object).getName();
            }
        }, new ColumnLabelProvider(){

            public String getText(Object object) {
                return ((IHttpMacroItemParam)object).getValueSource().getDescription();
            }
        }, new ColumnLabelProvider(){

            public String getText(Object object) {
                return ((IHttpMacroItemParam)object).getValue();
            }
        }};
        int n = 0;
        while (n < stringArray.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumnLayout.setColumnData((Widget)tableColumn, columnLayoutDataArray[n]);
            tableColumn.setText(stringArray[n]);
            tableColumn.setMoveable(true);
            tableViewerColumn.setEditingSupport(editingSupportArray2[n]);
            tableViewerColumn.setLabelProvider((CellLabelProvider)columnLabelProviderArray[n]);
            ++n;
        }
    }

    private Composite createParamsButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, true));
        this.createButton = new Button(composite2, 8);
        this.createButton.setText("create");
        this.createButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.createButton.addSelectionListener(this.createCreateButtonSelectionListener());
        this.removeButton = new Button(composite2, 8);
        this.removeButton.setText("remove");
        this.removeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.removeButton.addSelectionListener(this.createRemoveButtonSelectionListener());
        this.moveUpButton = new Button(composite2, 8);
        this.moveUpButton.setText("move up");
        this.moveUpButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.moveUpButton.addSelectionListener(this.createMoveUpButtonSelectionListener());
        this.moveDownButton = new Button(composite2, 8);
        this.moveDownButton.setText("move down");
        this.moveDownButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.moveDownButton.addSelectionListener(this.createMoveDownButtonSelectionListener());
        return composite2;
    }

    private SelectionListener createCreateButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        };
    }

    private SelectionListener createRemoveButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)MacroItemEditor.this.paramsTableViewer.getSelection();
                Iterator iterator = iStructuredSelection.iterator();
                while (iterator.hasNext()) {
                    MacroItemEditor.this.macroItem.removeParam((IHttpMacroItemParam)iterator.next());
                }
                MacroItemEditor.this.paramsTableViewer.refresh();
            }
        };
    }

    private SelectionListener createMoveUpButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)MacroItemEditor.this.paramsTableViewer.getSelection();
                Iterator iterator = iStructuredSelection.iterator();
                while (iterator.hasNext()) {
                    int n = MacroItemEditor.this.macroItem.indexOfParam((IHttpMacroItemParam)iterator.next());
                    if (n == 0) break;
                    MacroItemEditor.this.macroItem.swapParams(n - 1, n);
                }
                MacroItemEditor.this.paramsTableViewer.refresh();
            }
        };
    }

    private SelectionListener createMoveDownButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)MacroItemEditor.this.paramsTableViewer.getSelection();
                int[] nArray = new int[iStructuredSelection.size()];
                int n = 1;
                Iterator iterator = iStructuredSelection.iterator();
                while (iterator.hasNext()) {
                    nArray[nArray.length - n] = MacroItemEditor.this.macroItem.indexOfParam((IHttpMacroItemParam)iterator.next());
                    ++n;
                }
                if (nArray[0] + 1 != MacroItemEditor.this.macroItem.paramsSize()) {
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        MacroItemEditor.this.macroItem.swapParams(nArray[n2], nArray[n2] + 1);
                        ++n2;
                    }
                }
                MacroItemEditor.this.paramsTableViewer.refresh();
            }
        };
    }
}

