/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.urls;

import com.subgraph.vega.api.model.scope.ITargetScope;
import com.subgraph.vega.api.scanner.IScannerConfig;
import com.subgraph.vega.api.util.VegaURI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class UriFilter {
    private final IScannerConfig scannerConfig;
    private final Set<VegaURI> visitedURIs = new HashSet<VegaURI>();
    private final ArrayList<Pattern> exclusionList = new ArrayList();

    public UriFilter(IScannerConfig iScannerConfig) {
        this.scannerConfig = iScannerConfig;
        if (iScannerConfig.getScanIdentity() != null) {
            for (String string : iScannerConfig.getScanIdentity().getPathExclusions()) {
                this.exclusionList.add(Pattern.compile(string));
            }
        }
    }

    public boolean isExcluded(VegaURI vegaURI) {
        for (Pattern pattern : this.exclusionList) {
            if (!pattern.matcher(vegaURI.toString()).find()) continue;
            return true;
        }
        return false;
    }

    public boolean isAllowed(VegaURI vegaURI) {
        ITargetScope iTargetScope = this.scannerConfig.getScanTargetScope();
        return iTargetScope.filter(vegaURI.toURI()) && !this.isExcluded(vegaURI);
    }

    public synchronized boolean filter(VegaURI vegaURI) {
        if (this.visitedURIs.contains(vegaURI) || !this.isAllowed(vegaURI)) {
            return false;
        }
        this.visitedURIs.add(vegaURI);
        return true;
    }
}

