/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.urls;

import com.google.common.collect.ImmutableMap;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.scanner.IInjectionModuleContext;
import com.subgraph.vega.impl.scanner.urls.ResponseAnalyzer;
import org.apache.http.client.methods.HttpUriRequest;

public class SQLErrorMessageDetector {
    private static final ImmutableMap<databaseErrorTypes, String> DATABASE_ALERTS = ImmutableMap.builder().put((Object)databaseErrorTypes.SQLSERVER, (Object)"vinfo-sqlserver-error").put((Object)databaseErrorTypes.ASP, (Object)"vinfo-sql-error").put((Object)databaseErrorTypes.MS, (Object)"vinfo-sql-error").put((Object)databaseErrorTypes.ACCESS, (Object)"vinfo-sql-error").put((Object)databaseErrorTypes.MYSQL, (Object)"vinfo-mysql-error").put((Object)databaseErrorTypes.POSTGRES, (Object)"vinfo-sql-error").put((Object)databaseErrorTypes.JAVA, (Object)"vinfo-sql-error").put((Object)databaseErrorTypes.ORACLE, (Object)"vinfo-sql-error").put((Object)databaseErrorTypes.DQL, (Object)"vinfo-sql-error").put((Object)databaseErrorTypes.CF, (Object)"vinfo-sql-error").put((Object)databaseErrorTypes.DB2, (Object)"vinfo-sql-error").build();
    private static final ImmutableMap<String, databaseErrorTypes> ERROR_STRINGS = ImmutableMap.builder().put((Object)"Incorrect syntax near", (Object)databaseErrorTypes.SQLSERVER).put((Object)"Unclosed quotation mark", (Object)databaseErrorTypes.SQLSERVER).put((Object)"Dynamic SQL Error", (Object)databaseErrorTypes.SQLSERVER).put((Object)"SqlClient.SqlException: Syntax error", (Object)databaseErrorTypes.ASP).put((Object)"[Microsoft][ODBC SQL Server Driver]", (Object)databaseErrorTypes.MS).put((Object)"Microsoft OLE DB Provider for ODBC Drivers</font>", (Object)databaseErrorTypes.MS).put((Object)"Microsoft OLE DB Provider for ODBC Drivers</FONT>", (Object)databaseErrorTypes.MS).put((Object)"Syntax error in string in query expression", (Object)databaseErrorTypes.ACCESS).put((Object)"<b>Warning</b>:  MySQL: ", (Object)databaseErrorTypes.MYSQL).put((Object)"You have an error in your SQL syntax", (Object)databaseErrorTypes.MYSQL).put((Object)"supplied argument is not a valid MySQL", (Object)databaseErrorTypes.MYSQL).put((Object)"PostgreSQL query failed:", (Object)databaseErrorTypes.POSTGRES).put((Object)"unterminated quoted string at or near", (Object)databaseErrorTypes.POSTGRES).put((Object)"syntax error at or near", (Object)databaseErrorTypes.POSTGRES).put((Object)"invalid input syntax for integer:", (Object)databaseErrorTypes.POSTGRES).put((Object)"Query failed: ERROR: syntax error", (Object)databaseErrorTypes.POSTGRES).put((Object)"Unexpected end of command in statement", (Object)databaseErrorTypes.JAVA).put((Object)"java.sql.SQLException:", (Object)databaseErrorTypes.JAVA).put((Object)"quoted string not properly terminated", (Object)databaseErrorTypes.ORACLE).put((Object)"SQL command not properly ended", (Object)databaseErrorTypes.ORACLE).put((Object)"unable to perform query", (Object)databaseErrorTypes.ORACLE).put((Object)"[DM_QUERY_E_SYNTAX]", (Object)databaseErrorTypes.DQL).put((Object)"[Macromedia][SQLServer JDBC Driver]", (Object)databaseErrorTypes.CF).put((Object)"[Macromedia][MySQL JDBC Driver]", (Object)databaseErrorTypes.CF).put((Object)"DB2 SQL Error:", (Object)databaseErrorTypes.DB2).build();
    private final ResponseAnalyzer responseAnalyzer;

    public SQLErrorMessageDetector(ResponseAnalyzer responseAnalyzer) {
        this.responseAnalyzer = responseAnalyzer;
    }

    public void detectErrorMessages(IInjectionModuleContext iInjectionModuleContext, HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse) {
        String string = iHttpResponse.getBodyAsString();
        if (string == null || string.isEmpty()) {
            return;
        }
        for (String string2 : ERROR_STRINGS.keySet()) {
            if (!string.contains(string2)) continue;
            this.processDetectedErrorMessage(iInjectionModuleContext, httpUriRequest, iHttpResponse, string2, (databaseErrorTypes)((Object)ERROR_STRINGS.get((Object)string2)));
        }
    }

    private void processDetectedErrorMessage(IInjectionModuleContext iInjectionModuleContext, HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse, String string, databaseErrorTypes databaseErrorTypes2) {
        iInjectionModuleContext.addStringHighlight(string);
        this.responseAnalyzer.alert(iInjectionModuleContext, (String)DATABASE_ALERTS.get((Object)databaseErrorTypes2), "SQL Error Message Detected", httpUriRequest, iHttpResponse, null);
    }

    private static enum databaseErrorTypes {
        SQLSERVER,
        ASP,
        MS,
        ACCESS,
        MYSQL,
        POSTGRES,
        JAVA,
        ORACLE,
        DQL,
        CF,
        DB2;

    }
}

