/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.urls;

import com.subgraph.vega.api.analysis.IContentAnalyzer;
import com.subgraph.vega.api.analysis.IContentAnalyzerResult;
import com.subgraph.vega.api.html.IHTMLParseResult;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.scanner.IInjectionModuleContext;
import com.subgraph.vega.api.scanner.IScannerConfig;
import com.subgraph.vega.api.util.UriTools;
import com.subgraph.vega.api.util.VegaURI;
import com.subgraph.vega.impl.scanner.forms.FormProcessor;
import com.subgraph.vega.impl.scanner.urls.SQLErrorMessageDetector;
import com.subgraph.vega.impl.scanner.urls.UriFilter;
import com.subgraph.vega.impl.scanner.urls.UriParser;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html2.HTMLDocument;

public class ResponseAnalyzer {
    private final IContentAnalyzer contentAnalyzer;
    private final UriParser uriParser;
    private final UriFilter uriFilter;
    private final FormProcessor formProcessor;
    private final SQLErrorMessageDetector sqlDetector;
    private final boolean isProxyScan;
    private static final Logger logger = Logger.getLogger("modules");

    public ResponseAnalyzer(IScannerConfig iScannerConfig, IContentAnalyzer iContentAnalyzer, UriParser uriParser, UriFilter uriFilter, boolean bl) {
        this.contentAnalyzer = iContentAnalyzer;
        this.uriParser = uriParser;
        this.uriFilter = uriFilter;
        this.isProxyScan = bl;
        this.formProcessor = new FormProcessor(iScannerConfig, uriFilter, uriParser);
        this.sqlDetector = new SQLErrorMessageDetector(this);
    }

    public IContentAnalyzer getContentAnalyzer() {
        return this.contentAnalyzer;
    }

    public void analyzePivot(IInjectionModuleContext iInjectionModuleContext, HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse) {
    }

    public void analyzePage(IInjectionModuleContext iInjectionModuleContext, HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse) {
        IContentAnalyzerResult iContentAnalyzerResult = this.contentAnalyzer.processResponse(iHttpResponse, false, true);
        if (this.isProxyScan) {
            return;
        }
        for (VegaURI vegaURI : iContentAnalyzerResult.getDiscoveredURIs()) {
            if (!this.uriFilter.filter(vegaURI)) continue;
            this.uriParser.processUri(vegaURI);
        }
        this.formProcessor.processForms(iInjectionModuleContext, httpUriRequest, iHttpResponse);
    }

    public void analyzeContent(IInjectionModuleContext iInjectionModuleContext, HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse) {
        this.analyzeHtml(iInjectionModuleContext, httpUriRequest, iHttpResponse);
        if (!this.filterInjectedPath(iHttpResponse.getRequestUri().getPath())) {
            this.contentAnalyzer.processResponse(iHttpResponse, false, false);
        }
        this.sqlDetector.detectErrorMessages(iInjectionModuleContext, httpUriRequest, iHttpResponse);
    }

    private void analyzeHtml(IInjectionModuleContext iInjectionModuleContext, HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse) {
        IHTMLParseResult iHTMLParseResult = iHttpResponse.getParsedHTML();
        if (iHTMLParseResult == null) {
            return;
        }
        HTMLDocument hTMLDocument = iHTMLParseResult.getDOMDocument();
        NodeList nodeList = hTMLDocument.getElementsByTagName("*");
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                this.analyzeHtmlElement(iInjectionModuleContext, httpUriRequest, iHttpResponse, (Element)node);
            }
            ++n;
        }
    }

    private boolean filterInjectedPath(String string) {
        return string.contains("vega://") || string.contains("//vega.invalid") || this.pathContainsXssTag(string);
    }

    private boolean pathContainsXssTag(String string) {
        int n = string.indexOf("vvv");
        if (n == -1) {
            return false;
        }
        return this.extractXssTag(string, n) != null;
    }

    private void analyzeHtmlElement(IInjectionModuleContext iInjectionModuleContext, HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse, Element element) {
        String string;
        boolean bl = false;
        NamedNodeMap namedNodeMap = element.getAttributes();
        String string2 = element.getTagName().toLowerCase();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Node node = namedNodeMap.item(n);
            if (node instanceof Attr) {
                String string3 = ((Attr)node).getName().toLowerCase();
                String string4 = ((Attr)node).getValue().toLowerCase();
                if (this.match(string2, "script") && this.match(string3, "src")) {
                    bl = true;
                }
                if (string4 != null && (this.match(string3, "href", "src", "action", "codebase") || this.match(string3, "value") && !this.match(string2, "input"))) {
                    if (string4.startsWith("vega://")) {
                        this.alert(iInjectionModuleContext, "vinfo-url-inject", "URL injection into <" + string2 + "> tag", httpUriRequest, iHttpResponse, null);
                    }
                    if (string4.startsWith("http://vega.invalid/") || string4.startsWith("//vega.invalid/")) {
                        if (this.match(string2, "script", "link")) {
                            iInjectionModuleContext.addStringHighlight(((Attr)node).getValue());
                            this.alert(iInjectionModuleContext, "vinfo-xss-inject", "URL injection into actively fetched field in tag <" + string2 + "> (high risk)", httpUriRequest, iHttpResponse, null);
                        } else if (this.match(string2, "a")) {
                            iInjectionModuleContext.addStringHighlight(((Attr)node).getValue());
                            this.alert(iInjectionModuleContext, "vinfo-url-inject", "URL injection into anchor tag (low risk)", httpUriRequest, iHttpResponse, null);
                        } else {
                            iInjectionModuleContext.addStringHighlight(((Attr)node).getValue());
                            this.alert(iInjectionModuleContext, "vinfo-url-inject", "URL injection into tag <" + string2 + ">", httpUriRequest, iHttpResponse, null);
                        }
                    }
                }
                if (string4 != null && (string3.startsWith("on") || string3.equals("style"))) {
                    this.checkJavascriptXSS(iInjectionModuleContext, httpUriRequest, iHttpResponse, string4);
                }
                if (this.match(string2, "script", "frame", "iframe") && this.match(string3, "src") && string4 != null && (string4.startsWith("javascript:") || string4.startsWith("vbscript:"))) {
                    this.checkJavascriptXSS(iInjectionModuleContext, httpUriRequest, iHttpResponse, string4);
                }
                if (string3.contains("vvv")) {
                    this.possibleXssAlert(iInjectionModuleContext, httpUriRequest, iHttpResponse, string3, string3.indexOf("vvv"), "vinfo-xss-inject", "Injected XSS tag into HTML attribute value");
                }
            }
            ++n;
        }
        if (string2.startsWith("vvv")) {
            this.possibleXssAlert(iInjectionModuleContext, httpUriRequest, iHttpResponse, string2, 0, "vinfo-xss-inject", "Injected XSS tag into HTML tag name");
        }
        if ((string2.equals("style") || string2.equals("script") && !bl) && (string = element.getTextContent()) != null) {
            this.checkJavascriptXSS(iInjectionModuleContext, httpUriRequest, iHttpResponse, string);
        }
    }

    private void possibleXssAlert(IInjectionModuleContext iInjectionModuleContext, HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse, String string, int n, String string2, String string3) {
        int[] nArray = this.extractXssTag(string, n);
        String string4 = this.extractXssString(string, n);
        if (nArray == null) {
            return;
        }
        if (string4 == null) {
            return;
        }
        HttpUriRequest httpUriRequest2 = iInjectionModuleContext.getPathState().getXssRequest(nArray[0], nArray[1]);
        if (httpUriRequest2 != null) {
            if (string.length() > 20) {
                iInjectionModuleContext.addStringHighlight(string);
            } else {
                iInjectionModuleContext.addStringHighlight(string4);
            }
            this.alert(iInjectionModuleContext, string2, string3, httpUriRequest2, iHttpResponse, null);
        } else {
            int n2;
            if (string.length() > 20) {
                iInjectionModuleContext.addStringHighlight(string);
            } else {
                iInjectionModuleContext.addStringHighlight(string4);
            }
            String string5 = httpUriRequest.getURI().normalize().getPath();
            String string6 = n == 0 ? ((n2 = iHttpResponse.getBodyAsString().indexOf(string)) + 26 < iHttpResponse.getBodyAsString().length() ? iHttpResponse.getBodyAsString().substring(n2 + 16, n2 + 26) : iHttpResponse.getBodyAsString().substring(n2, iHttpResponse.getBodyAsString().length() - 1)) : (n + 26 < string.length() ? string.substring(n + 16, n + 26) : string.substring(n + 16, string.length() - 1));
            n2 = string5.indexOf(63);
            if (n2 != -1) {
                string5 = string5.substring(0, n2);
            }
            this.alert(iInjectionModuleContext, "vinfo-xss-stored", String.valueOf(string3) + " (from previous scan)", httpUriRequest, iHttpResponse, "vinfo-xss-stored:" + string5 + ":" + string6);
        }
    }

    private boolean match(String string, String ... stringArray) {
        if (string == null) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private String extractXssString(String string, int n) {
        if (string.length() < n + 16) {
            return null;
        }
        if (string.charAt(n + 9) != 'v') {
            return null;
        }
        return string.substring(n, n + 16);
    }

    private int[] extractXssTag(String string, int n) {
        if (string.length() < n + 16) {
            return null;
        }
        if (string.charAt(n + 9) != 'v') {
            return null;
        }
        int[] nArray = new int[]{this.extractXssId(string, n + 3), this.extractXssId(string, n + 10)};
        if (nArray[0] == -1 || nArray[1] == -1) {
            return null;
        }
        return nArray;
    }

    private int extractXssId(String string, int n) {
        if (string.length() < n + 6) {
            return -1;
        }
        String string2 = string.substring(n, n + 6);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private void checkJavascriptXSS(IInjectionModuleContext iInjectionModuleContext, HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse, String string) {
        if (string == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        while (n2 < string.length()) {
            if ((n2 = this.maybeSkipJavascriptComment(string, n2)) >= string.length()) {
                return;
            }
            char c = string.charAt(n2);
            if (!(bl || c != '\'' && c != '\"')) {
                bl = true;
                if (this.matchStartsWith(string, n, "innerHTML", "open", "asyncRequest", "url", "href", "write", "src", "location", "action")) {
                    bl3 = true;
                    n3 = n2 + 1;
                }
                if (this.matchStartsWith(string, n, "innerHTML", "open", "url", "href", "write") && this.matchStartsWith(string, n2 + 1, "//vega.invalid/", "http://vega.invalid", "vega:")) {
                    this.alert(iInjectionModuleContext, "vinfo-url-inject", "Injected URL in JS/CSS code", httpUriRequest, iHttpResponse, null);
                }
            } else if (c == '\'' || c == '\"') {
                if (bl3) {
                    this.addPossibleUrl(httpUriRequest.getURI(), string.substring(n3, n2));
                    n3 = 0;
                    bl3 = false;
                }
                bl = false;
            } else if (!bl && string.startsWith("vvv", n2)) {
                this.possibleXssAlert(iInjectionModuleContext, httpUriRequest, iHttpResponse, string, n2, "vinfo-xss-inject", "Injected syntax into JS/CSS code");
            } else if (Character.isWhitespace(c) || c == '.') {
                bl2 = true;
            } else if (bl2 && Character.isLetterOrDigit(c)) {
                n = n2;
                bl2 = false;
            }
            ++n2;
        }
    }

    private void addPossibleUrl(URI uRI, String string) {
        VegaURI vegaURI;
        HttpHost httpHost;
        if (this.isProxyScan) {
            return;
        }
        String string2 = !string.startsWith("http") ? this.absUri(uRI, string) : string;
        URI uRI2 = this.createURI(string2);
        if (uRI2 != null && this.hasValidHttpScheme(uRI2) && this.validateHost(httpHost = URIUtils.extractHost((URI)uRI2)) && this.uriFilter.filter(vegaURI = new VegaURI(httpHost, uRI2.normalize().getPath(), uRI2.getQuery()))) {
            this.uriParser.processUri(vegaURI);
        }
    }

    private URI createURI(String string) {
        block3: {
            try {
                if (!string.isEmpty()) break block3;
                return null;
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
        return new URI(string);
    }

    private boolean validateHost(HttpHost httpHost) {
        if (httpHost.getHostName() == null || httpHost.getHostName().isEmpty()) {
            return false;
        }
        try {
            new URI(httpHost.getSchemeName(), null, httpHost.getHostName(), httpHost.getPort(), null, null, null);
            return true;
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    private boolean hasValidHttpScheme(URI uRI) {
        String string = uRI.getScheme();
        return string != null && (string.equalsIgnoreCase("http") || string.equalsIgnoreCase("https"));
    }

    private String absUri(URI uRI, String string) {
        String string2;
        if (string.startsWith("/")) {
            string2 = String.valueOf(uRI.getScheme()) + "://" + uRI.getHost() + string;
        } else {
            int n = 0;
            int n2 = 0;
            n = 0;
            while (n <= uRI.normalize().getPath().length() - 1) {
                if (uRI.normalize().getPath().charAt(n) == '/') {
                    n2 = n;
                }
                ++n;
            }
            string2 = String.valueOf(uRI.getScheme()) + "://" + uRI.getHost() + uRI.normalize().getPath().substring(0, n2) + "/" + string;
        }
        return string2;
    }

    private boolean matchStartsWith(String string, int n, String ... stringArray) {
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string.startsWith(stringArray[n2], n)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private int maybeSkipJavascriptComment(String string, int n) {
        char c;
        char c2;
        int n2 = string.length();
        int n3 = n;
        if (n >= n2) {
            return n;
        }
        if ((c2 = string.charAt(n++)) == '\\') {
            return n + 1;
        }
        if (c2 != '/') {
            return n3;
        }
        if (n >= n2) {
            return n;
        }
        if ((c = string.charAt(n++)) == '/') {
            while (n < n2) {
                char c3 = string.charAt(n);
                if (c3 == '\n' || c2 == '\r') {
                    return n;
                }
                ++n;
            }
            return n2;
        }
        if (c == '*') {
            int n4 = string.indexOf("*/", n);
            if (n4 == -1) {
                return n2;
            }
            return n4 + 2;
        }
        return n3;
    }

    public void alert(IInjectionModuleContext iInjectionModuleContext, String string, String string2, HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse, String string3) {
        String string4;
        int n;
        if (string3 == null) {
            string3 = this.createAlertKey(iInjectionModuleContext, string, httpUriRequest);
        }
        if ((n = (string4 = httpUriRequest.getURI().normalize().getPath()).indexOf(63)) != -1) {
            string4 = string4.substring(0, n);
        }
        iInjectionModuleContext.publishAlert(string, string3, string2, (HttpRequest)httpUriRequest, iHttpResponse, new Object[]{"resource", string4});
    }

    private String createAlertKey(IInjectionModuleContext iInjectionModuleContext, String string, HttpUriRequest httpUriRequest) {
        if (iInjectionModuleContext.getPathState().isParametric()) {
            String string2 = UriTools.stripQueryFromUri((URI)httpUriRequest.getURI()).toString();
            return String.valueOf(string) + ":" + string2 + ":" + iInjectionModuleContext.getPathState().getFuzzableParameter().getName();
        }
        return String.valueOf(string) + ":" + httpUriRequest.getURI();
    }
}

