/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.handlers;

import com.subgraph.vega.api.crawler.ICrawlerResponseProcessor;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.http.requests.IPageFingerprint;
import com.subgraph.vega.api.scanner.IInjectionModuleContext;
import com.subgraph.vega.api.scanner.IPathState;
import com.subgraph.vega.http.requests.custom.VegaHttpUriRequest;
import com.subgraph.vega.impl.scanner.handlers.CrawlerModule;
import com.subgraph.vega.impl.scanner.handlers.InjectionChecks;
import java.net.URI;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.message.BasicRequestLine;

public class PutChecks
extends CrawlerModule {
    private final InjectionChecks injectionChecks;

    PutChecks(InjectionChecks injectionChecks) {
        this.injectionChecks = injectionChecks;
    }

    @Override
    public void initialize(IPathState iPathState) {
        IInjectionModuleContext iInjectionModuleContext = iPathState.createModuleContext();
        URI uRI = iPathState.getPath().getUri().resolve("PUT-putfile");
        HttpHost httpHost = URIUtils.extractHost((URI)uRI);
        BasicRequestLine basicRequestLine = new BasicRequestLine("PUT", uRI.getPath(), (ProtocolVersion)HttpVersion.HTTP_1_1);
        VegaHttpUriRequest vegaHttpUriRequest = new VegaHttpUriRequest(httpHost, (RequestLine)basicRequestLine);
        iInjectionModuleContext.submitRequest((HttpUriRequest)vegaHttpUriRequest, (ICrawlerResponseProcessor)this);
    }

    @Override
    public void runModule(HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse, IInjectionModuleContext iInjectionModuleContext) {
        IPathState iPathState = iInjectionModuleContext.getPathState();
        if (iHttpResponse.isFetchFail()) {
            iInjectionModuleContext.error(httpUriRequest, iHttpResponse, "during PUT checks");
        } else {
            int n = iHttpResponse.getResponseCode();
            IPageFingerprint iPageFingerprint = iHttpResponse.getPageFingerprint();
            if (n >= 200 && n < 300 && !iPathState.matchesPathFingerprint(iPageFingerprint) && !iPathState.has404FingerprintMatching(iPageFingerprint)) {
                String string = httpUriRequest.getURI().toString();
                String string2 = "vinfo-http-put:" + string;
                iInjectionModuleContext.publishAlert("vinfo-http-put", string2, "HTTP PUT succeeded", (HttpRequest)httpUriRequest, iHttpResponse, new Object[]{"resource", string});
            }
        }
        this.injectionChecks.runPageVariabilityCheck(iInjectionModuleContext.getPathState());
    }
}

