/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.forms;

import com.subgraph.vega.api.scanner.IFormCredential;
import com.subgraph.vega.api.util.VegaURI;
import com.subgraph.vega.impl.scanner.forms.FormHints;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class FormProcessingState {
    private static final Logger logger = Logger.getLogger("scanner");
    private static final FormHints formHints = new FormHints();
    private final VegaURI baseURI;
    private final String action;
    private final String method;
    private final List<NameValuePair> parameters = new ArrayList<NameValuePair>();
    private VegaURI cachedTargetURI;
    private boolean passwordFlag;
    private boolean fileFieldFlag;

    FormProcessingState(VegaURI vegaURI, String string, String string2, List<IFormCredential> list) {
        this.baseURI = vegaURI;
        this.action = string;
        this.method = string2;
    }

    boolean isValid() {
        return this.getTargetURI() != null;
    }

    boolean isPostMethod() {
        return this.method != null && this.method.toLowerCase().equals("post");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VegaURI getTargetURI() {
        FormProcessingState formProcessingState = this;
        synchronized (formProcessingState) {
            if (this.cachedTargetURI == null) {
                this.cachedTargetURI = this.createTargetURI();
            }
            return this.cachedTargetURI;
        }
    }

    private VegaURI createTargetURI() {
        if (this.baseURI == null) {
            return null;
        }
        if (this.action == null || this.action.trim().equals("#")) {
            return this.baseURI;
        }
        try {
            VegaURI vegaURI = this.baseURI.resolve(this.action);
            String string = vegaURI.getTargetHost().getSchemeName();
            if (string.equalsIgnoreCase("http") || string.equalsIgnoreCase("https")) {
                return vegaURI;
            }
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.log(Level.WARNING, "Failed to create new URI from base: " + this.baseURI + " and action=" + this.action, illegalArgumentException);
            return null;
        }
    }

    void add(String string, String string2) {
        this.parameters.add((NameValuePair)new BasicNameValuePair(string, string2 == null ? "" : string2));
    }

    void addGuessedValue(String string) {
        this.add(string, this.guessFormValue(string));
    }

    void setPasswordFieldFlag() {
        this.passwordFlag = true;
    }

    boolean getPasswordFieldFlag() {
        return this.passwordFlag;
    }

    void setFileFieldFlag() {
        this.fileFieldFlag = true;
    }

    boolean getFileFieldFlag() {
        return this.fileFieldFlag;
    }

    private String guessFormValue(String string) {
        return formHints.lookupHint(string);
    }

    List<NameValuePair> getParameters() {
        return this.parameters;
    }

    public String toString() {
        if (this.isPostMethod()) {
            return "POST " + this.getTargetURI().toString() + this.parametersAsPostString();
        }
        return "GET " + this.getTargetURI().toString() + this.parametersAsQueryString();
    }

    private String parametersAsQueryString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("?");
        for (NameValuePair nameValuePair : this.parameters) {
            if (stringBuilder.length() > 1) {
                stringBuilder.append("&");
            }
            stringBuilder.append(nameValuePair.getName());
            if (nameValuePair.getValue() == null) continue;
            stringBuilder.append("=");
            stringBuilder.append(nameValuePair.getValue());
        }
        return stringBuilder.toString();
    }

    private String parametersAsPostString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        stringBuilder.append(" [");
        for (NameValuePair nameValuePair : this.parameters) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(nameValuePair.getName());
            if (nameValuePair.getValue() == null) continue;
            stringBuilder.append("=");
            stringBuilder.append(nameValuePair.getValue());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

