/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner;

import com.subgraph.vega.api.model.identity.IIdentity;
import com.subgraph.vega.api.model.scope.ITargetScope;
import com.subgraph.vega.api.scanner.IFormCredential;
import com.subgraph.vega.api.scanner.IScannerConfig;
import com.subgraph.vega.impl.scanner.forms.FormCredential;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.http.cookie.Cookie;

public class ScannerConfig
implements IScannerConfig {
    private static final String[] defaultExcludedParameters = new String[]{"xsrftoken", "__eventvalidation", "__eventargument", "__eventtarget", "__viewstateencrypted", "__viewstate", "anticsrf", "csrfmiddlewaretoken", "csrftoken"};
    private ITargetScope scanTargetScope;
    private String userAgent = "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; .NET CLR 1.1.4322; InfoPath.1; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; Vega/1.0";
    private IIdentity scanIdentity;
    private List<Cookie> cookieList;
    private List<String> modulesList;
    private final Set<String> excludedParameterNames = new HashSet<String>();
    private boolean logAllRequests;
    private boolean displayDebugOutput;
    private int maxRequestsPerSecond = 25;
    private int maxDescendants = 8192;
    private int maxChildren = 512;
    private int maxDepth = 16;
    private int maxDuplicatePaths = 3;
    private int maxParameterCount = 16;
    private int maxConnections = 50;
    private int maxResponseKilobytes = 1024;
    private final List<IFormCredential> formCredentials = new ArrayList<IFormCredential>();

    public synchronized void setUserAgent(String string) {
        this.userAgent = string;
    }

    public synchronized void setScanIdentity(IIdentity iIdentity) {
        this.scanIdentity = iIdentity;
    }

    public synchronized void setCookieList(List<Cookie> list) {
        this.cookieList = list;
    }

    public synchronized void setModulesList(List<String> list) {
        this.modulesList = list;
    }

    public synchronized void setExcludedParameterNames(Set<String> set) {
        this.excludedParameterNames.clear();
        this.excludedParameterNames.addAll(set);
    }

    public Set<String> getDefaultExcludedParameterNames() {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(defaultExcludedParameters)));
    }

    public synchronized Set<String> getExcludedParameterNames() {
        return Collections.unmodifiableSet(new HashSet<String>(this.excludedParameterNames));
    }

    public synchronized String getUserAgent() {
        return this.userAgent;
    }

    public synchronized IIdentity getScanIdentity() {
        return this.scanIdentity;
    }

    public synchronized List<Cookie> getCookieList() {
        return this.cookieList;
    }

    public synchronized List<String> getModulesList() {
        return this.modulesList;
    }

    public synchronized void setLogAllRequests(boolean bl) {
        this.logAllRequests = bl;
    }

    public synchronized boolean getLogAllRequests() {
        return this.logAllRequests;
    }

    public synchronized void setDisplayDebugOutput(boolean bl) {
        this.displayDebugOutput = bl;
    }

    public synchronized boolean getDisplayDebugOutput() {
        return this.displayDebugOutput;
    }

    public synchronized boolean getDirectoryInjectionChecksFlag() {
        return true;
    }

    public synchronized boolean getNonParameterFileInjectionChecksFlag() {
        return true;
    }

    public synchronized IFormCredential createFormCredential(String string, String string2) {
        FormCredential formCredential = new FormCredential(string, string2);
        this.formCredentials.add(formCredential);
        return formCredential;
    }

    public synchronized List<IFormCredential> getFormCredentials() {
        return this.formCredentials;
    }

    public synchronized void setMaxRequestsPerSecond(int n) {
        this.maxRequestsPerSecond = n;
    }

    public synchronized int getMaxRequestsPerSecond() {
        return this.maxRequestsPerSecond;
    }

    public synchronized int getMaxDescendants() {
        return this.maxDescendants;
    }

    public synchronized int getMaxChildren() {
        return this.maxChildren;
    }

    public synchronized int getMaxDepth() {
        return this.maxDepth;
    }

    public synchronized void setMaxDescendants(int n) {
        this.maxDescendants = n;
    }

    public synchronized void setMaxChildren(int n) {
        this.maxChildren = n;
    }

    public synchronized void setMaxDepth(int n) {
        this.maxDepth = n;
    }

    public synchronized int getMaxDuplicatePaths() {
        return this.maxDuplicatePaths;
    }

    public synchronized void setMaxDuplicatePaths(int n) {
        this.maxDuplicatePaths = n;
    }

    public synchronized void setMaxParameterCount(int n) {
        this.maxParameterCount = n;
    }

    public synchronized int getMaxParameterCount() {
        return this.maxParameterCount;
    }

    public synchronized void setMaxConnections(int n) {
        this.maxConnections = n;
    }

    public synchronized int getMaxConnections() {
        return this.maxConnections;
    }

    public synchronized void setMaxResponseKilobytes(int n) {
        this.maxResponseKilobytes = n;
    }

    public synchronized int getMaxResponseKilobytes() {
        return this.maxResponseKilobytes;
    }

    public void setScanTargetScope(ITargetScope iTargetScope) {
        this.scanTargetScope = iTargetScope;
    }

    public ITargetScope getScanTargetScope() {
        return this.scanTargetScope;
    }
}

