/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.http.requests.IHttpRequestEngine;
import com.subgraph.vega.api.http.requests.IHttpRequestEngineConfig;
import com.subgraph.vega.api.http.requests.IHttpRequestEngineFactory;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.WorkspaceCloseEvent;
import com.subgraph.vega.api.model.WorkspaceResetEvent;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.api.model.identity.IIdentity;
import com.subgraph.vega.api.model.requests.IRequestOrigin;
import com.subgraph.vega.api.model.requests.IRequestOriginScanner;
import com.subgraph.vega.api.scanner.IScan;
import com.subgraph.vega.api.scanner.IScanProbeResult;
import com.subgraph.vega.api.scanner.IScannerConfig;
import com.subgraph.vega.api.scanner.modules.IBasicModuleScript;
import com.subgraph.vega.api.scanner.modules.IResponseProcessingModule;
import com.subgraph.vega.api.scanner.modules.IScannerModule;
import com.subgraph.vega.api.scanner.modules.IScannerModuleRegistry;
import com.subgraph.vega.impl.scanner.ScanProbe;
import com.subgraph.vega.impl.scanner.Scanner;
import com.subgraph.vega.impl.scanner.ScannerConfig;
import com.subgraph.vega.impl.scanner.ScannerTask;
import com.subgraph.vega.sslprobe.SSLProbe;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class Scan
implements IScan {
    private final Scanner scanner;
    private final IEventHandler workspaceListener;
    private final IScannerConfig config;
    private IScanInstance scanInstance;
    private IWorkspace workspace;
    private ScanProbe scanProbe;
    private SSLProbe sslProbe;
    private IHttpRequestEngine requestEngine;
    private ScannerTask scannerTask;
    private Thread scannerThread;
    private URI redirectURI = null;
    private List<IResponseProcessingModule> responseProcessingModules;
    private List<IBasicModuleScript> basicModules;

    public static Scan createScan(Scanner scanner, IWorkspace iWorkspace) {
        if (iWorkspace == null) {
            return null;
        }
        Scan scan = new Scan(scanner);
        scan.setWorkspace(iWorkspace);
        scan.reloadModules();
        return scan;
    }

    private Scan(Scanner scanner) {
        this.scanner = scanner;
        this.workspaceListener = new IEventHandler(){

            public void handleEvent(IEvent iEvent) {
                if (iEvent instanceof WorkspaceCloseEvent || iEvent instanceof WorkspaceResetEvent) {
                    Scan.this.handleWorkspaceCloseOrReset();
                }
            }
        };
        this.config = new ScannerConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWorkspace(IWorkspace iWorkspace) {
        Scan scan = this;
        synchronized (scan) {
            iWorkspace.lock();
            this.workspace = iWorkspace;
            iWorkspace.getModel().addWorkspaceListener(this.workspaceListener);
            this.scanInstance = iWorkspace.getScanAlertRepository().createNewScanInstance();
            this.scanInstance.setScan((IScan)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWorkspaceCloseOrReset() {
        Scan scan = this;
        synchronized (scan) {
            this.scanInstance = null;
            this.workspace.getModel().removeWorkspaceListener(this.workspaceListener);
            this.workspace = null;
        }
    }

    public IScannerConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IScannerModule> getModuleList() {
        Scan scan = this;
        synchronized (scan) {
            this.reloadModules();
            ArrayList<IScannerModule> arrayList = new ArrayList<IScannerModule>();
            arrayList.addAll(this.responseProcessingModules);
            arrayList.addAll(this.basicModules);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IScanProbeResult probeTargetUri(URI uRI) {
        Scan scan = this;
        synchronized (scan) {
            if (this.scanInstance == null) {
                throw new IllegalStateException("Scan is detached from workspace; scan instance was lost. A new scan must be created");
            }
            IScanInstance iScanInstance = this.scanInstance;
            synchronized (iScanInstance) {
                int n = this.scanInstance.getScanStatus();
                if (n != 0) {
                    if (n != 1) {
                        throw new IllegalStateException("Unable to run a probe for a scan that is already running or complete");
                    }
                    if (this.scanProbe != null) {
                        throw new IllegalStateException("Another probe is already in progress");
                    }
                } else {
                    this.requestEngine = this.createRequestEngine(this.config);
                    this.workspace.getScanAlertRepository().addActiveScanInstance(this.scanInstance);
                }
                this.scanInstance.updateScanStatus(1);
            }
            this.scanProbe = new ScanProbe(uRI, this.requestEngine);
            if (uRI.getScheme().contains("https")) {
                String string;
                int n;
                if (uRI.getPort() == -1) {
                    n = 443;
                    string = "https://" + uRI.getHost();
                } else {
                    n = uRI.getPort();
                    string = "https://" + uRI.getHost() + ":" + n;
                }
                this.sslProbe = new SSLProbe(this.scanInstance, uRI.getHost(), n, string);
                this.sslProbe.run();
            }
        }
        scan = this.scanProbe.runProbe();
        Scan scan2 = this;
        synchronized (scan2) {
            this.scanProbe = null;
        }
        this.redirectURI = scan.getRedirectTarget();
        return scan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startScan() {
        Scan scan = this;
        synchronized (scan) {
            if (this.scanInstance == null) {
                throw new IllegalStateException("Scan is detached from workspace; scan instance was lost. A new scan must be created");
            }
            if (this.config.getScanTargetScope() == null) {
                throw new IllegalArgumentException("Cannot start scan because no target was specified");
            }
            IScanInstance iScanInstance = this.scanInstance;
            synchronized (iScanInstance) {
                int n = this.scanInstance.getScanStatus();
                if (n != 0) {
                    if (n != 1) {
                        throw new IllegalStateException("Scan is already running or complete");
                    }
                    if (this.scanProbe != null) {
                        throw new IllegalStateException("A scan probe is in progress");
                    }
                } else {
                    this.requestEngine = this.createRequestEngine(this.config);
                    this.workspace.getScanAlertRepository().addActiveScanInstance(this.scanInstance);
                }
                this.scanInstance.updateScanStatus(2);
            }
            this.reloadModules();
            this.scannerTask = new ScannerTask(this);
            this.scannerThread = new Thread(this.scannerTask);
            this.scannerThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopScan() {
        Scan scan = this;
        synchronized (scan) {
            if (this.scannerTask != null) {
                this.scannerTask.stop();
            } else {
                if (this.scanProbe != null) {
                    this.scanProbe.abort();
                }
                if (this.scanInstance != null) {
                    IScanInstance iScanInstance = this.scanInstance;
                    synchronized (iScanInstance) {
                        if (this.scanInstance.getScanStatus() != 0) {
                            this.scanInstance.updateScanStatus(5);
                        }
                    }
                }
                this.doFinish();
            }
        }
    }

    private IHttpRequestEngine createRequestEngine(IScannerConfig iScannerConfig) {
        IHttpRequestEngineFactory iHttpRequestEngineFactory = this.scanner.getHttpRequestEngineFactory();
        IHttpRequestEngineConfig iHttpRequestEngineConfig = iHttpRequestEngineFactory.createConfig();
        if (iScannerConfig.getMaxRequestsPerSecond() > 0) {
            iHttpRequestEngineConfig.setRequestsPerMinute(iScannerConfig.getMaxRequestsPerSecond() * 60);
        }
        iHttpRequestEngineConfig.setMaxConnections(iScannerConfig.getMaxConnections());
        iHttpRequestEngineConfig.setMaxConnectionsPerRoute(iScannerConfig.getMaxConnections());
        iHttpRequestEngineConfig.setMaximumResponseKilobytes(iScannerConfig.getMaxResponseKilobytes());
        IRequestOriginScanner iRequestOriginScanner = this.workspace.getRequestLog().getRequestOriginScanner(this.scanInstance);
        IHttpRequestEngine iHttpRequestEngine = iHttpRequestEngineFactory.createRequestEngine(IHttpRequestEngine.EngineConfigType.CONFIG_SCANNER, iHttpRequestEngineConfig, (IRequestOrigin)iRequestOriginScanner);
        HttpProtocolParams.setUserAgent((HttpParams)iHttpRequestEngine.getHttpClient().getParams(), (String)iScannerConfig.getUserAgent());
        IIdentity iIdentity = iScannerConfig.getScanIdentity();
        if (iIdentity != null && iIdentity.getAuthMethod() != null) {
            iIdentity.getAuthMethod().setAuth(iHttpRequestEngine);
        }
        if (iScannerConfig.getCookieList() != null && !iScannerConfig.getCookieList().isEmpty()) {
            CookieStore cookieStore = iHttpRequestEngine.getCookieStore();
            for (Cookie cookie : iScannerConfig.getCookieList()) {
                cookieStore.addCookie(cookie);
            }
        }
        return iHttpRequestEngine;
    }

    private void reloadModules() {
        IScannerModuleRegistry iScannerModuleRegistry = this.scanner.getScannerModuleRegistry();
        if (this.responseProcessingModules == null || this.basicModules == null) {
            this.responseProcessingModules = iScannerModuleRegistry.getResponseProcessingModules();
            this.basicModules = iScannerModuleRegistry.getBasicModules();
        } else {
            this.responseProcessingModules = iScannerModuleRegistry.updateResponseProcessingModules(this.responseProcessingModules);
            this.basicModules = iScannerModuleRegistry.updateBasicModules(this.basicModules);
        }
    }

    public Scanner getScanner() {
        return this.scanner;
    }

    public synchronized IScanInstance getScanInstance() {
        return this.scanInstance;
    }

    public synchronized IWorkspace getWorkspace() {
        return this.workspace;
    }

    public synchronized List<IResponseProcessingModule> getResponseModules() {
        return this.responseProcessingModules;
    }

    public synchronized List<IBasicModuleScript> getBasicModules() {
        return this.basicModules;
    }

    public synchronized IHttpRequestEngine getRequestEngine() {
        return this.requestEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFinish() {
        Scan scan = this;
        synchronized (scan) {
            this.scanInstance.setScan(null);
            this.workspace.getScanAlertRepository().removeActiveScanInstance(this.scanInstance);
            this.workspace.unlock();
        }
    }

    public URI getRedirectURI() {
        return this.redirectURI;
    }

    public void pauseScan() {
        if (this.scannerTask != null) {
            this.scannerTask.pauseScan();
        }
    }

    public void unpauseScan() {
        if (this.scannerTask != null) {
            this.scannerTask.unpauseScan();
        }
    }

    public boolean isPausedScan() {
        if (this.scannerTask != null) {
            return this.scannerTask.isPaused();
        }
        return false;
    }
}

