/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner;

import com.subgraph.vega.api.analysis.IContentAnalyzer;
import com.subgraph.vega.api.crawler.IWebCrawler;
import com.subgraph.vega.api.http.requests.IHttpRequestEngine;
import com.subgraph.vega.api.http.requests.IHttpRequestEngineConfig;
import com.subgraph.vega.api.http.requests.IHttpRequestEngineFactory;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.api.model.identity.IIdentity;
import com.subgraph.vega.api.model.requests.IRequestOrigin;
import com.subgraph.vega.api.scanner.IProxyScan;
import com.subgraph.vega.api.scanner.IScannerConfig;
import com.subgraph.vega.api.scanner.modules.IBasicModuleScript;
import com.subgraph.vega.api.scanner.modules.IScannerModuleRegistry;
import com.subgraph.vega.api.util.VegaURI;
import com.subgraph.vega.impl.scanner.Scanner;
import com.subgraph.vega.impl.scanner.ScannerConfig;
import com.subgraph.vega.impl.scanner.urls.UriFilter;
import com.subgraph.vega.impl.scanner.urls.UriParser;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.NameValuePair;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class ProxyScan
implements IProxyScan {
    private final Logger logger = Logger.getLogger("scanner");
    private final IWorkspace workspace;
    private final CookieStore cookieStore;
    private final Scanner scanner;
    private final IScanInstance scanInstance;
    private final IScannerConfig config;
    private IWebCrawler crawler;
    private UriParser uriParser;
    private List<IBasicModuleScript> basicModules;
    private Object startLock = new Object();
    private boolean isStarted = false;

    ProxyScan(IWorkspace iWorkspace, CookieStore cookieStore, Scanner scanner) {
        this.workspace = iWorkspace;
        this.cookieStore = cookieStore;
        this.scanner = scanner;
        this.scanInstance = iWorkspace.getScanAlertRepository().getScanInstanceByScanId(-1L);
        this.config = new ScannerConfig();
        this.reloadModules();
        this.logger.setLevel(Level.ALL);
    }

    public IScannerConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanGetTarget(VegaURI vegaURI, List<NameValuePair> list) {
        Object object = this.startLock;
        synchronized (object) {
            if (!this.isStarted) {
                this.start();
            }
        }
        object = this.uriParser.processUri(this.stripQuery(vegaURI));
        object.maybeAddParameters(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanPostTarget(VegaURI vegaURI, List<NameValuePair> list) {
        Object object = this.startLock;
        synchronized (object) {
            if (!this.isStarted) {
                this.start();
            }
        }
        object = this.uriParser.processUri(this.stripQuery(vegaURI));
        object.maybeAddPostParameters(list);
    }

    private VegaURI stripQuery(VegaURI vegaURI) {
        if (vegaURI.getQuery() != null) {
            return new VegaURI(vegaURI.getTargetHost(), vegaURI.getPath(), null);
        }
        return vegaURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.startLock;
        synchronized (object) {
            if (!this.isStarted) {
                return;
            }
            try {
                this.crawler.stop();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Attempt to stop proxy scan crawler was interrupted", interruptedException);
            }
            this.crawler = null;
            this.uriParser = null;
            this.isStarted = false;
        }
    }

    private void start() {
        if (this.isStarted) {
            return;
        }
        this.crawler = this.createWebCrawler();
        this.uriParser = this.createUriParser(this.crawler);
        this.crawler.start();
        this.isStarted = true;
        this.reloadModules();
    }

    private UriParser createUriParser(IWebCrawler iWebCrawler) {
        IContentAnalyzer iContentAnalyzer = this.scanner.getContentAnalyzerFactory().createContentAnalyzer(this.scanInstance);
        return new UriParser(this.config, this.basicModules, this.workspace, iWebCrawler, new UriFilter(this.config), iContentAnalyzer, this.scanInstance, true);
    }

    private IWebCrawler createWebCrawler() {
        IWebCrawler iWebCrawler = this.scanner.getWebCrawlerFactory().create(this.createRequestEngine(this.config));
        iWebCrawler.setStopOnEmptyQueue(false);
        return iWebCrawler;
    }

    private IHttpRequestEngine createRequestEngine(IScannerConfig iScannerConfig) {
        Cookie cookie2;
        IHttpRequestEngineFactory iHttpRequestEngineFactory = this.scanner.getHttpRequestEngineFactory();
        IHttpRequestEngineConfig iHttpRequestEngineConfig = iHttpRequestEngineFactory.createConfig();
        if (iScannerConfig.getCookieList() != null && !iScannerConfig.getCookieList().isEmpty()) {
            for (Cookie cookie2 : iScannerConfig.getCookieList()) {
                this.cookieStore.addCookie(cookie2);
            }
        }
        if (iScannerConfig.getMaxRequestsPerSecond() > 0) {
            iHttpRequestEngineConfig.setRequestsPerMinute(iScannerConfig.getMaxRequestsPerSecond() * 60);
        }
        iHttpRequestEngineConfig.setMaxConnections(iScannerConfig.getMaxConnections());
        iHttpRequestEngineConfig.setMaxConnectionsPerRoute(iScannerConfig.getMaxConnections());
        iHttpRequestEngineConfig.setMaximumResponseKilobytes(iScannerConfig.getMaxResponseKilobytes());
        cookie2 = this.workspace.getRequestLog().getRequestOriginScanner(this.scanInstance);
        IHttpRequestEngine iHttpRequestEngine = iHttpRequestEngineFactory.createRequestEngine(IHttpRequestEngine.EngineConfigType.CONFIG_SCANNER, iHttpRequestEngineConfig, (IRequestOrigin)cookie2);
        HttpProtocolParams.setUserAgent((HttpParams)iHttpRequestEngine.getHttpClient().getParams(), (String)iScannerConfig.getUserAgent());
        iHttpRequestEngine.setCookieStore(this.cookieStore);
        IIdentity iIdentity = iScannerConfig.getScanIdentity();
        if (iIdentity != null && iIdentity.getAuthMethod() != null) {
            iIdentity.getAuthMethod().setAuth(iHttpRequestEngine);
        }
        return iHttpRequestEngine;
    }

    public List<IBasicModuleScript> getInjectionModules() {
        return Collections.unmodifiableList(this.basicModules);
    }

    public void reloadModules() {
        IScannerModuleRegistry iScannerModuleRegistry = this.scanner.getScannerModuleRegistry();
        this.basicModules = this.basicModules == null ? iScannerModuleRegistry.getBasicModules() : iScannerModuleRegistry.updateBasicModules(this.basicModules);
        if (this.uriParser != null) {
            this.uriParser.updateInjectionModules(this.basicModules);
        }
    }
}

