/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.web;

import com.db4o.ObjectContainer;
import com.db4o.activation.ActivationPurpose;
import com.db4o.collections.ActivatableHashMap;
import com.google.common.base.Objects;
import com.subgraph.vega.api.events.EventListenerManager;
import com.subgraph.vega.api.model.web.IWebEntity;
import com.subgraph.vega.api.model.web.IWebModelVisitor;
import com.subgraph.vega.api.model.web.IWebMountPoint;
import com.subgraph.vega.api.model.web.IWebPath;
import com.subgraph.vega.api.model.web.IWebPathParameters;
import com.subgraph.vega.api.model.web.IWebResponse;
import com.subgraph.vega.internal.model.web.WebEntity;
import com.subgraph.vega.internal.model.web.WebPathParameters;
import com.subgraph.vega.internal.model.web.WebResponse;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class WebPath
extends WebEntity
implements IWebPath {
    private final WebPath parentPath;
    private final String pathComponent;
    private final Map<String, WebPath> childPathMap = new ActivatableHashMap();
    private IWebMountPoint mountPoint;
    private final WebPathParameters getParameters = new WebPathParameters();
    private final WebPathParameters postParameters = new WebPathParameters();
    private final Map<List<NameValuePair>, IWebResponse> getResponses = new ActivatableHashMap();
    private final Map<List<NameValuePair>, IWebResponse> postResponses = new ActivatableHashMap();
    private IWebPath.PathType pathType;
    private String mimeType;
    private transient URI cachedUri;
    private transient String cachedFullPath;

    static WebPath createRootPath(EventListenerManager eventListenerManager, ObjectContainer objectContainer) {
        return new WebPath(eventListenerManager, objectContainer, null, "");
    }

    private WebPath(EventListenerManager eventListenerManager, ObjectContainer objectContainer, WebPath webPath, String string) {
        this(eventListenerManager, objectContainer, webPath, string, null);
    }

    WebPath(EventListenerManager eventListenerManager, ObjectContainer objectContainer, WebPath webPath, String string, IWebMountPoint iWebMountPoint) {
        super(eventListenerManager, objectContainer);
        this.parentPath = webPath;
        this.pathComponent = string;
        this.mountPoint = iWebMountPoint;
        this.pathType = IWebPath.PathType.PATH_UNKNOWN;
    }

    public WebPath getParentPath() {
        return this.parentPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getUri() {
        this.activate(ActivationPurpose.READ);
        WebPath webPath = this;
        synchronized (webPath) {
            if (this.cachedUri == null) {
                this.cachedUri = this.generateURI();
            }
            return this.cachedUri;
        }
    }

    private URI generateURI() {
        URI uRI = this.mountPoint.getWebHost().getUri();
        try {
            return new URI(uRI.getScheme(), uRI.getAuthority(), this.getFullPath(), null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return null;
        }
    }

    public String getFullPath() {
        if (this.cachedFullPath == null) {
            this.cachedFullPath = this.generateFullPath();
        }
        return this.cachedFullPath;
    }

    private String generateFullPath() {
        this.activate(ActivationPurpose.READ);
        if (this.parentPath == null) {
            return "/";
        }
        String string = this.parentPath.getFullPath();
        if (string.endsWith("/")) {
            return String.valueOf(string) + this.pathComponent;
        }
        return String.valueOf(string) + "/" + this.pathComponent;
    }

    public IWebMountPoint getMountPoint() {
        this.activate(ActivationPurpose.READ);
        return this.mountPoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IWebPath> getChildPaths() {
        this.activate(ActivationPurpose.READ);
        Map<String, WebPath> map = this.childPathMap;
        synchronized (map) {
            return new HashSet<IWebPath>(this.childPathMap.values());
        }
    }

    void setMountPoint(IWebMountPoint iWebMountPoint) {
        this.activate(ActivationPurpose.READ);
        this.mountPoint = iWebMountPoint;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof WebPath) {
            WebPath webPath = (WebPath)object;
            return this.getMountPoint().getWebHost().equals(webPath.getMountPoint().getWebHost()) && this.getFullPath().equals(webPath.getFullPath());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getMountPoint().getWebHost(), this.getFullPath()});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("host", (Object)this.mountPoint.getWebHost()).add("path", (Object)this.getFullPath()).toString();
    }

    public boolean isGetTarget() {
        this.activate(ActivationPurpose.READ);
        return this.getParameters.hasParameters();
    }

    public boolean isPostTarget() {
        this.activate(ActivationPurpose.READ);
        return this.postParameters.hasParameters();
    }

    public void addGetParameterList(List<NameValuePair> list) {
        this.activate(ActivationPurpose.READ);
        this.getParameters.addParameterList(list);
    }

    public void addPostParameterList(List<NameValuePair> list) {
        this.activate(ActivationPurpose.READ);
        this.postParameters.addParameterList(list);
    }

    public IWebPathParameters getGetParameters() {
        this.activate(ActivationPurpose.READ);
        return this.getParameters;
    }

    public IWebPathParameters getPostParameters() {
        this.activate(ActivationPurpose.READ);
        return this.postParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWebPath getChildPath(String string) {
        this.activate(ActivationPurpose.READ);
        Map<String, WebPath> map = this.childPathMap;
        synchronized (map) {
            return this.childPathMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebPath addChildPath(String string) {
        this.activate(ActivationPurpose.READ);
        Map<String, WebPath> map = this.childPathMap;
        synchronized (map) {
            if (this.childPathMap.containsKey(string)) {
                return this.childPathMap.get(string);
            }
            WebPath webPath = new WebPath(this.eventManager, this.database, this, string, this.getMountPoint());
            ObjectContainer objectContainer = this.getDatabase();
            objectContainer.store((Object)webPath);
            webPath.setDatabase(objectContainer);
            this.childPathMap.put(string, webPath);
            this.notifyNewEntity(webPath);
            return webPath;
        }
    }

    public String getPathComponent() {
        this.activate(ActivationPurpose.READ);
        return this.pathComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IWebResponse> getGetResponses() {
        this.activate(ActivationPurpose.READ);
        Map<List<NameValuePair>, IWebResponse> map = this.getResponses;
        synchronized (map) {
            return Collections.unmodifiableList(new ArrayList<IWebResponse>(this.getResponses.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IWebResponse> getPostResponses() {
        this.activate(ActivationPurpose.READ);
        Map<List<NameValuePair>, IWebResponse> map = this.postResponses;
        synchronized (map) {
            return Collections.unmodifiableList(new ArrayList<IWebResponse>(this.postResponses.values()));
        }
    }

    public IWebEntity getParent() {
        this.activate(ActivationPurpose.READ);
        if (this.parentPath != null) {
            return this.parentPath;
        }
        if (this.mountPoint != null) {
            return this.mountPoint.getWebHost();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPostResponse(List<NameValuePair> list, String string) {
        this.activate(ActivationPurpose.READ);
        Map<List<NameValuePair>, IWebResponse> map = this.postResponses;
        synchronized (map) {
            this.maybeAddWebResponse(this.postResponses, list, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGetResponse(String string, String string2) {
        this.activate(ActivationPurpose.READ);
        Map<List<NameValuePair>, IWebResponse> map = this.getResponses;
        synchronized (map) {
            this.maybeAddWebResponse(this.getResponses, WebPath.parseParameters(string), string2);
        }
    }

    private void maybeAddWebResponse(Map<List<NameValuePair>, IWebResponse> map, List<NameValuePair> list, String string) {
        IWebResponse iWebResponse;
        if (map.containsKey(list)) {
            iWebResponse = map.get(list);
            if (string == null || string.equals(iWebResponse.getMimeType())) {
                return;
            }
        }
        iWebResponse = this.createWebResponse(list, string);
        map.put(list, iWebResponse);
        this.notifyNewEntity((IWebEntity)iWebResponse);
    }

    private WebResponse createWebResponse(List<NameValuePair> list, String string) {
        WebResponse webResponse = new WebResponse(this.eventManager, this.database, this, list, string);
        ObjectContainer objectContainer = this.getDatabase();
        webResponse.setDatabase(objectContainer);
        objectContainer.store((Object)webResponse);
        return webResponse;
    }

    private static List<NameValuePair> parseParameters(String string) {
        if (string == null || string.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        try {
            URLEncodedUtils.parse(arrayList, (Scanner)new Scanner(string), (String)"UTF-8");
        }
        catch (RuntimeException runtimeException) {
            arrayList.clear();
            arrayList.add((NameValuePair)new BasicNameValuePair(string, null));
        }
        return arrayList;
    }

    public void setPathType(IWebPath.PathType pathType) {
        this.activate(ActivationPurpose.READ);
        this.pathType = pathType;
        this.cachedFullPath = null;
        this.cachedUri = null;
        this.activate(ActivationPurpose.WRITE);
    }

    public IWebPath.PathType getPathType() {
        this.activate(ActivationPurpose.READ);
        return this.pathType;
    }

    public void setMimeType(String string) {
        this.activate(ActivationPurpose.READ);
        this.mimeType = string;
        this.activate(ActivationPurpose.WRITE);
    }

    public String getMimeType() {
        this.activate(ActivationPurpose.READ);
        return this.mimeType;
    }

    public void accept(IWebModelVisitor iWebModelVisitor) {
        iWebModelVisitor.visit((IWebPath)this);
        for (IWebPath iWebPath : this.getChildPaths()) {
            iWebPath.accept(iWebModelVisitor);
        }
        for (IWebResponse iWebResponse : this.getGetResponses()) {
            iWebResponse.accept(iWebModelVisitor);
        }
        for (IWebResponse iWebResponse : this.getPostResponses()) {
            iWebResponse.accept(iWebModelVisitor);
        }
    }

    public HttpHost getHttpHost() {
        return this.mountPoint.getWebHost().getHttpHost();
    }
}

