/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.web;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.events.CancellableObjectEventArgs;
import com.db4o.events.Event4;
import com.db4o.events.EventListener4;
import com.db4o.events.EventRegistry;
import com.db4o.events.EventRegistryFactory;
import com.db4o.query.Predicate;
import com.subgraph.vega.api.events.EventListenerManager;
import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.web.IWebEntity;
import com.subgraph.vega.api.model.web.IWebHost;
import com.subgraph.vega.api.model.web.IWebModel;
import com.subgraph.vega.api.model.web.IWebModelVisitor;
import com.subgraph.vega.api.model.web.IWebPath;
import com.subgraph.vega.api.model.web.NewWebEntityEvent;
import com.subgraph.vega.api.model.web.forms.IWebForm;
import com.subgraph.vega.api.util.VegaURI;
import com.subgraph.vega.internal.model.web.WebEntity;
import com.subgraph.vega.internal.model.web.WebHost;
import com.subgraph.vega.internal.model.web.forms.FormParser;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.HttpHost;
import org.apache.http.client.utils.URLEncodedUtils;
import org.w3c.dom.html2.HTMLDocument;

public class WebModel
implements IWebModel {
    private final EventListenerManager eventManager = new EventListenerManager();
    private final ObjectContainer database;
    private final FormParser formParser = new FormParser(this);

    public WebModel(ObjectContainer objectContainer) {
        this.database = objectContainer;
        EventRegistry eventRegistry = EventRegistryFactory.forObjectContainer((ObjectContainer)objectContainer);
        eventRegistry.activating().addListener((EventListener4)new EventListener4<CancellableObjectEventArgs>(){

            public void onEvent(Event4<CancellableObjectEventArgs> event4, CancellableObjectEventArgs cancellableObjectEventArgs) {
                Object object = cancellableObjectEventArgs.object();
                if (object instanceof WebEntity) {
                    WebEntity webEntity = (WebEntity)object;
                    webEntity.setEventManager(WebModel.this.eventManager);
                    webEntity.setDatabase(WebModel.this.database);
                }
            }
        });
    }

    public synchronized Collection<IWebHost> getAllWebHosts() {
        return this.database.query(IWebHost.class);
    }

    public Collection<IWebHost> getUnscannedHosts() {
        return this.database.query((Predicate)new Predicate<IWebHost>(){
            private static final long serialVersionUID = 1L;

            public boolean match(IWebHost iWebHost) {
                return !iWebHost.isScanned();
            }
        });
    }

    public Collection<IWebPath> getUnscannedPaths() {
        ObjectSet objectSet = this.database.query((Predicate)new Predicate<IWebPath>(){
            private static final long serialVersionUID = 1L;

            public boolean match(IWebPath iWebPath) {
                return !iWebPath.isScanned();
            }
        });
        return objectSet;
    }

    public Collection<IWebPath> getAllPaths() {
        return this.database.query(IWebPath.class);
    }

    public synchronized IWebPath getWebPathByUri(VegaURI vegaURI) {
        HttpHost httpHost = vegaURI.getTargetHost();
        if (httpHost != null) {
            WebHost webHost = this.getWebHostByHttpHost(httpHost);
            if (webHost == null) {
                webHost = this.createWebHostFromHttpHost(httpHost);
            }
            return webHost.addPath(vegaURI.getPath());
        }
        return null;
    }

    public IWebPath addGetTarget(VegaURI vegaURI) {
        IWebPath iWebPath = this.getWebPathByUri(vegaURI);
        if (iWebPath != null) {
            List list = URLEncodedUtils.parse((String)vegaURI.getQuery(), (Charset)Consts.UTF_8);
            iWebPath.addGetParameterList(list);
        }
        return iWebPath;
    }

    public synchronized WebHost getWebHostByHttpHost(HttpHost httpHost) {
        for (WebHost webHost : this.database.query(WebHost.class)) {
            if (!webHost.getHttpHost().equals((Object)httpHost)) continue;
            return webHost;
        }
        return null;
    }

    public synchronized IWebHost createWebHostFromHttpHost(HttpHost httpHost) {
        WebHost webHost = this.getWebHostByHttpHost(httpHost);
        if (webHost != null) {
            return webHost;
        }
        WebHost webHost2 = WebHost.createWebHost(this.eventManager, this.database, httpHost);
        webHost2.setDatabase(this.database);
        webHost2.getRootPath().setDatabase(this.database);
        this.database.store((Object)webHost2);
        this.database.store((Object)webHost2.getRootMountPoint());
        this.database.store((Object)webHost2.getRootPath());
        this.notifyNewEntity(webHost2);
        return webHost2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListenerAndPopulate(IEventHandler iEventHandler) {
        WebModel webModel = this;
        synchronized (webModel) {
            for (IWebHost iWebHost : this.getAllWebHosts()) {
                iEventHandler.handleEvent((IEvent)new NewWebEntityEvent((IWebEntity)iWebHost));
            }
            this.eventManager.addListener(iEventHandler);
        }
    }

    public void removeChangeListener(IEventHandler iEventHandler) {
        this.eventManager.removeListener(iEventHandler);
    }

    private void notifyNewEntity(IWebEntity iWebEntity) {
        this.eventManager.fireEvent((IEvent)new NewWebEntityEvent(iWebEntity));
    }

    public Collection<IWebForm> parseForms(IWebPath iWebPath, HTMLDocument hTMLDocument) {
        return this.formParser.parseForms(iWebPath, hTMLDocument);
    }

    public void accept(IWebModelVisitor iWebModelVisitor) {
        for (IWebHost iWebHost : this.getAllWebHosts()) {
            iWebHost.accept(iWebModelVisitor);
        }
    }
}

