/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.scope;

import com.db4o.activation.ActivationPurpose;
import com.db4o.activation.Activator;
import com.db4o.collections.ActivatableHashSet;
import com.db4o.ta.Activatable;
import com.subgraph.vega.api.events.EventListenerManager;
import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.model.scope.ActiveScopeChangedEvent;
import com.subgraph.vega.api.model.scope.ITargetScope;
import com.subgraph.vega.api.util.UriTools;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.http.HttpHost;
import org.apache.http.client.utils.URIUtils;

public class TargetScope
implements ITargetScope,
Activatable {
    private final long id;
    private final Set<String> scopeURIs;
    private final Set<String> exclusionPatterns;
    private final Set<String> exclusionURIs;
    private final boolean isDefault;
    private String name;
    private boolean isActiveScope;
    private boolean isReadOnly;
    private boolean isDetached;
    private transient EventListenerManager scopeChangedListeners;
    private transient List<Pattern> compiledPatterns;
    private transient Activator activator;

    TargetScope(long l, boolean bl, EventListenerManager eventListenerManager) {
        this.id = l;
        this.name = "";
        this.isDefault = bl;
        this.scopeURIs = new ActivatableHashSet();
        this.exclusionPatterns = new ActivatableHashSet();
        this.exclusionURIs = new ActivatableHashSet();
        this.scopeChangedListeners = eventListenerManager;
    }

    public long getScopeId() {
        this.activate(ActivationPurpose.READ);
        return this.id;
    }

    public String getName() {
        this.activate(ActivationPurpose.READ);
        return this.name;
    }

    private void checkReadOnly() {
        if (this.isReadOnly) {
            throw new IllegalStateException("Attempt to modify TargetScope instance which is marked Read Only");
        }
    }

    public void setName(String string) {
        this.activate(ActivationPurpose.READ);
        this.checkReadOnly();
        this.name = string;
        this.activate(ActivationPurpose.WRITE);
        this.notifyIfActiveScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addScopeURI(URI uRI) {
        this.activate(ActivationPurpose.READ);
        this.checkReadOnly();
        Set<String> set = this.scopeURIs;
        synchronized (set) {
            this.scopeURIs.add(uRI.toString());
        }
        this.activate(ActivationPurpose.WRITE);
        this.notifyIfActiveScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeScopeURI(URI uRI, boolean bl) {
        this.activate(ActivationPurpose.READ);
        this.checkReadOnly();
        Set<String> set = this.scopeURIs;
        synchronized (set) {
            this.scopeURIs.remove(uRI.toString());
            if (bl) {
                this.removeContainedURIs(uRI);
            }
        }
        this.activate(ActivationPurpose.WRITE);
        this.notifyIfActiveScope();
    }

    private void removeContainedURIs(URI uRI) {
        ArrayList<String> arrayList = new ArrayList<String>(this.scopeURIs);
        for (String string : arrayList) {
            if (!UriTools.doesBaseUriContain((URI)uRI, (URI)URI.create(string))) continue;
            this.scopeURIs.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<URI> getScopeURIs() {
        this.activate(ActivationPurpose.READ);
        ArrayList<URI> arrayList = new ArrayList<URI>();
        Set<String> set = this.scopeURIs;
        synchronized (set) {
            for (String string : this.scopeURIs) {
                arrayList.add(URI.create(string));
            }
            return Collections.unmodifiableCollection(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExclusionPattern(String string) {
        this.activate(ActivationPurpose.READ);
        this.checkReadOnly();
        Set<String> set = this.exclusionPatterns;
        synchronized (set) {
            this.exclusionPatterns.add(string);
            this.compiledPatterns = this.compilePatterns();
        }
        this.activate(ActivationPurpose.WRITE);
        this.notifyIfActiveScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExclusionURI(URI uRI) {
        this.activate(ActivationPurpose.READ);
        this.checkReadOnly();
        Set<String> set = this.exclusionURIs;
        synchronized (set) {
            this.exclusionURIs.add(uRI.toString());
        }
        this.activate(ActivationPurpose.WRITE);
        this.notifyIfActiveScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExclusionPattern(String string) {
        this.activate(ActivationPurpose.READ);
        this.checkReadOnly();
        Set<String> set = this.exclusionPatterns;
        synchronized (set) {
            this.exclusionPatterns.remove(string);
            this.compiledPatterns = this.compilePatterns();
        }
        this.activate(ActivationPurpose.WRITE);
        this.notifyIfActiveScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExclusionURI(URI uRI) {
        this.activate(ActivationPurpose.READ);
        this.checkReadOnly();
        Set<String> set = this.exclusionURIs;
        synchronized (set) {
            this.exclusionURIs.remove(uRI.toString());
        }
        this.activate(ActivationPurpose.WRITE);
        this.notifyIfActiveScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getExclusionPatterns() {
        this.activate(ActivationPurpose.READ);
        Set<String> set = this.exclusionPatterns;
        synchronized (set) {
            return Collections.unmodifiableCollection(new ArrayList<String>(this.exclusionPatterns));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<URI> getExclusionURIs() {
        this.activate(ActivationPurpose.READ);
        ArrayList<URI> arrayList = new ArrayList<URI>();
        Set<String> set = this.exclusionURIs;
        synchronized (set) {
            for (String string : this.exclusionURIs) {
                arrayList.add(URI.create(string));
            }
            return Collections.unmodifiableCollection(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isExcluded(URI uRI) {
        Object object;
        this.activate(ActivationPurpose.READ);
        String string = uRI.toString();
        Object object2 = this.getCompiledPatterns().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (!((Pattern)object).matcher(string).find()) continue;
            return true;
        }
        object = this.exclusionURIs;
        synchronized (object) {
            Iterator<String> iterator = this.exclusionURIs.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!UriTools.doesBaseUriContain((URI)URI.create((String)(object2 = iterator.next())), (URI)uRI));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isExcluded(HttpHost httpHost, String string) {
        Object object;
        this.activate(ActivationPurpose.READ);
        String string2 = String.valueOf(httpHost.toString()) + string;
        Object object2 = this.getCompiledPatterns().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (!((Pattern)object).matcher(string2).find()) continue;
            return true;
        }
        object = this.exclusionURIs;
        synchronized (object) {
            Iterator<String> iterator = this.exclusionURIs.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!this.matchesBase(URI.create((String)(object2 = iterator.next())), httpHost, string));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isInsideScope(URI uRI) {
        this.activate(ActivationPurpose.READ);
        Set<String> set = this.scopeURIs;
        synchronized (set) {
            String string;
            Iterator<String> iterator = this.scopeURIs.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!UriTools.doesBaseUriContain((URI)URI.create(string = iterator.next()), (URI)uRI));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isInsideScope(HttpHost httpHost, String string) {
        this.activate(ActivationPurpose.READ);
        Set<String> set = this.scopeURIs;
        synchronized (set) {
            String string2;
            Iterator<String> iterator = this.scopeURIs.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!this.matchesBase(URI.create(string2 = iterator.next()), httpHost, string));
            return true;
        }
    }

    private boolean matchesBase(URI uRI, HttpHost httpHost, String string) {
        HttpHost httpHost2 = URIUtils.extractHost((URI)uRI);
        String string2 = this.getPathPart(uRI);
        if (!this.hostsMatch(httpHost2, httpHost)) {
            return false;
        }
        return string.startsWith(string2);
    }

    private boolean hostsMatch(HttpHost httpHost, HttpHost httpHost2) {
        return this.stringsMatch(httpHost.getHostName(), httpHost2.getHostName()) && this.stringsMatch(httpHost.getSchemeName(), httpHost2.getSchemeName()) && this.portsMatch(httpHost.getSchemeName(), httpHost.getPort(), httpHost2.getPort());
    }

    private boolean stringsMatch(String string, String string2) {
        if (string == null && string2 != null) {
            return false;
        }
        return string.equalsIgnoreCase(string2);
    }

    private boolean portsMatch(String string, int n, int n2) {
        if (n == n2) {
            return true;
        }
        if ("http".equalsIgnoreCase(string) && (n == -1 && n2 == 80 || n == 80 && n2 == -1)) {
            return true;
        }
        return "https".equalsIgnoreCase(string) && (n == -1 && n2 == 443 || n == 443 && n2 == -1);
    }

    private String getPathPart(URI uRI) {
        if (uRI.getQuery() == null) {
            return uRI.getPath();
        }
        return String.valueOf(uRI.getPath()) + '?' + uRI.getQuery();
    }

    public boolean filter(URI uRI) {
        return this.isInsideScope(uRI) && !this.isExcluded(uRI);
    }

    public boolean filter(HttpHost httpHost, String string) {
        return this.isInsideScope(httpHost, string) && !this.isExcluded(httpHost, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.activate(ActivationPurpose.READ);
        this.checkReadOnly();
        Set<String> set = this.scopeURIs;
        synchronized (set) {
            Set<String> set2 = this.exclusionPatterns;
            synchronized (set2) {
                this.scopeURIs.clear();
                this.exclusionPatterns.clear();
                this.exclusionURIs.clear();
            }
        }
        this.activate(ActivationPurpose.WRITE);
        this.notifyIfActiveScope();
    }

    public boolean isEmpty() {
        return this.scopeURIs.isEmpty();
    }

    public boolean isActiveScope() {
        this.activate(ActivationPurpose.READ);
        return this.isActiveScope;
    }

    public void setReadOnly(boolean bl) {
        this.activate(ActivationPurpose.READ);
        this.isReadOnly = bl;
        this.activate(ActivationPurpose.WRITE);
    }

    public void setDetached(boolean bl) {
        this.activate(ActivationPurpose.READ);
        if (bl && this.isActiveScope) {
            throw new IllegalStateException("Cannot detach the active scope.");
        }
        if (bl && this.isDefault) {
            throw new IllegalStateException("Cannot detach the default scope");
        }
        this.isDetached = bl;
        this.activate(ActivationPurpose.WRITE);
    }

    public boolean isReadOnly() {
        this.activate(ActivationPurpose.READ);
        return this.isReadOnly;
    }

    public boolean isDetached() {
        return this.isDetached;
    }

    public void setIsActiveScope(boolean bl) {
        this.activate(ActivationPurpose.READ);
        if (bl && this.isDetached) {
            throw new IllegalStateException("Cannot use a detached scope as the active scope");
        }
        this.isActiveScope = bl;
        this.activate(ActivationPurpose.WRITE);
    }

    public boolean isDefaultScope() {
        this.activate(ActivationPurpose.READ);
        return this.isDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Pattern> getCompiledPatterns() {
        Set<String> set = this.exclusionPatterns;
        synchronized (set) {
            if (this.compiledPatterns == null) {
                this.compiledPatterns = this.compilePatterns();
            }
        }
        return this.compiledPatterns;
    }

    private List<Pattern> compilePatterns() {
        this.activate(ActivationPurpose.READ);
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
        for (String string : this.exclusionPatterns) {
            arrayList.add(Pattern.compile(string));
        }
        return arrayList;
    }

    public String toString() {
        return this.getName();
    }

    private void notifyIfActiveScope() {
        if (this.isActiveScope) {
            this.scopeChangedListeners.fireEvent((IEvent)new ActiveScopeChangedEvent((ITargetScope)this));
        }
    }

    void setEventListenerManager(EventListenerManager eventListenerManager) {
        this.scopeChangedListeners = eventListenerManager;
    }

    public void activate(ActivationPurpose activationPurpose) {
        if (this.activator != null) {
            this.activator.activate(activationPurpose);
        }
    }

    public void bind(Activator activator) {
        if (this.activator == activator) {
            return;
        }
        if (activator != null && this.activator != null) {
            throw new IllegalStateException("Object can only be bound to one activator");
        }
        this.activator = activator;
    }
}

